/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.collect.ImmutableSortedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.data.DataCache;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.model.EntityDTO;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderFacade;
import net.minecraft.client.renderer.entity.RenderHorse;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;

public class EntityHelper {
    public static EntityDistanceComparator entityDistanceComparator = new EntityDistanceComparator();
    public static EntityDTODistanceComparator entityDTODistanceComparator = new EntityDTODistanceComparator();
    public static EntityMapComparator entityMapComparator = new EntityMapComparator();
    private static final String[] HORSE_TEXTURES = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};

    public static List<EntityDTO> getEntitiesNearby(String timerName, int maxEntities, boolean living, boolean hostile, Class<?> ... entityClasses) {
        StatTimer timer = StatTimer.get("EntityHelper." + timerName);
        timer.start();
        List<EntityDTO> list = new ArrayList<EntityDTO>();
        EntityPlayerSP player = Journeymap.clientPlayer();
        World world = Journeymap.clientWorld();
        ArrayList allEntities = new ArrayList(world.field_72996_f);
        AxisAlignedBB bb = EntityHelper.getBB(player);
        try {
            block2: for (Entity entity : allEntities) {
                if (living && (!(entity instanceof EntityLivingBase) || entity.field_70128_L) || !entity.field_70175_ag || !bb.func_72326_a(entity.func_174813_aQ())) continue;
                for (Class<?> entityClass : entityClasses) {
                    if (!entityClass.isAssignableFrom(entity.getClass())) continue;
                    EntityDTO dto = DataCache.INSTANCE.getEntityDTO(entity);
                    dto.update(entity, hostile);
                    list.add(dto);
                    continue block2;
                }
            }
            if (list.size() > maxEntities) {
                int before = list.size();
                EntityHelper.entityDTODistanceComparator.player = player;
                Collections.sort(list, entityDTODistanceComparator);
                list = list.subList(0, maxEntities);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Failed to " + timerName + ": " + LogFormatter.toString(t));
        }
        timer.stop();
        return list;
    }

    public static List<EntityDTO> getMobsNearby() {
        return EntityHelper.getEntitiesNearby("getMobsNearby", Journeymap.getClient().getCoreProperties().maxMobsData.get(), true, true, IMob.class);
    }

    public static List<EntityDTO> getNpcsNearby() {
        return EntityHelper.getEntitiesNearby("getNpcsNearby", Journeymap.getClient().getCoreProperties().maxVillagersData.get(), true, false, INpc.class, IMerchant.class);
    }

    public static List<EntityDTO> getPassiveMobsNearby() {
        return EntityHelper.getEntitiesNearby("getPassiveMobsNearby", Journeymap.getClient().getCoreProperties().maxAnimalsData.get(), true, false, EntityAnimal.class, EntityGolem.class, EntityWaterMob.class);
    }

    public static List<EntityDTO> getVehiclesNearby() {
        return EntityHelper.getEntitiesNearby("getVehiclesNearby", Journeymap.getClient().getCoreProperties().maxVehiclesData.get(), false, false, EntityMinecart.class, EntityBoat.class);
    }

    public static boolean isPassive(EntityLiving entityLiving) {
        if (entityLiving == null) {
            return false;
        }
        if (entityLiving instanceof IMob) {
            return false;
        }
        EntityLivingBase attackTarget = entityLiving.func_70638_az();
        return attackTarget == null || !(attackTarget instanceof EntityPlayer) && !(attackTarget instanceof IEntityOwnable);
    }

    public static List<EntityDTO> getPlayersNearby() {
        StatTimer timer = StatTimer.get("EntityHelper.getPlayersNearby");
        timer.start();
        World world = Journeymap.clientWorld();
        EntityPlayerSP player = Journeymap.clientPlayer();
        List allPlayers = new ArrayList(world.field_73010_i);
        allPlayers.remove(player);
        int max = Journeymap.getClient().getCoreProperties().maxPlayersData.get();
        if (allPlayers.size() > max) {
            EntityHelper.entityDistanceComparator.player = player;
            Collections.sort(allPlayers, entityDistanceComparator);
            allPlayers = allPlayers.subList(0, max);
        }
        ArrayList<EntityDTO> playerDTOs = new ArrayList<EntityDTO>(allPlayers.size());
        for (EntityPlayer aPlayer : allPlayers) {
            EntityDTO dto = DataCache.INSTANCE.getEntityDTO((Entity)aPlayer);
            dto.update((Entity)aPlayer, false);
            playerDTOs.add(dto);
        }
        timer.stop();
        return playerDTOs;
    }

    private static AxisAlignedBB getBB(EntityPlayerSP player) {
        int lateralDistance = Journeymap.getClient().getCoreProperties().radarLateralDistance.get();
        int verticalDistance = Journeymap.getClient().getCoreProperties().radarVerticalDistance.get();
        return EntityHelper.getBoundingBox((EntityPlayer)player, lateralDistance, verticalDistance);
    }

    public static AxisAlignedBB getBoundingBox(EntityPlayer player, double lateralDistance, double verticalDistance) {
        return new AxisAlignedBB(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70165_t, player.field_70163_u, player.field_70161_v).func_72321_a(lateralDistance, verticalDistance, lateralDistance);
    }

    public static Map<String, EntityDTO> buildEntityIdMap(List<? extends EntityDTO> list, boolean sort) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        if (sort) {
            Collections.sort(list, new EntityMapComparator());
        }
        LinkedHashMap<String, EntityDTO> idMap = new LinkedHashMap<String, EntityDTO>(list.size());
        for (EntityDTO entityDTO : list) {
            idMap.put("id" + entityDTO.entityId, entityDTO);
        }
        return ImmutableSortedMap.copyOf(idMap);
    }

    public static ResourceLocation getIconTextureLocation(Entity entity) {
        try {
            Render entityRender = FMLClientHandler.instance().getClient().func_175598_ae().func_78713_a(entity);
            ResourceLocation original = null;
            if (entityRender instanceof RenderHorse) {
                EntityHorse horse = (EntityHorse)entity;
                original = new ResourceLocation("minecraft", horse.func_110212_cp()[0]);
            } else {
                original = RenderFacade.getEntityTexture(entityRender, entity);
            }
            if (original == null) {
                JMLogger.logOnce("Can't get entityTexture for " + entity.getClass() + " via " + entityRender.getClass(), null);
                return null;
            }
            if (!original.func_110623_a().contains("/entity/")) {
                return null;
            }
            ResourceLocation entityIconLoc = new ResourceLocation(original.func_110624_b(), original.func_110623_a().replace("/entity/", "/entity_icon/"));
            return entityIconLoc;
        }
        catch (Throwable t) {
            JMLogger.logOnce("Can't get entityTexture for " + entity.func_70005_c_(), t);
            return null;
        }
    }

    private static class EntityDTODistanceComparator
    implements Comparator<EntityDTO> {
        EntityPlayer player;

        private EntityDTODistanceComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            Entity e1 = (Entity)o1.entityRef.get();
            Entity e2 = (Entity)o2.entityRef.get();
            if (e1 == null || e2 == null) {
                return 0;
            }
            return Double.compare(e1.func_70068_e((Entity)this.player), e2.func_70068_e((Entity)this.player));
        }
    }

    private static class EntityDistanceComparator
    implements Comparator<Entity> {
        EntityPlayer player;

        private EntityDistanceComparator() {
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            return Double.compare(o1.func_70068_e((Entity)this.player), o2.func_70068_e((Entity)this.player));
        }
    }

    private static class EntityMapComparator
    implements Comparator<EntityDTO> {
        private EntityMapComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            Integer n;
            Integer n2;
            Integer o1rank = 0;
            Integer o2rank = 0;
            if (o1.customName != null) {
                n2 = o1rank;
                n = o1rank = Integer.valueOf(o1rank + 1);
            } else if (o1.username != null) {
                o1rank = o1rank + 2;
            }
            if (o2.customName != null) {
                n2 = o2rank;
                n = o2rank = Integer.valueOf(o2rank + 1);
            } else if (o2.username != null) {
                o2rank = o2rank + 2;
            }
            return o1rank.compareTo(o2rank);
        }
    }
}

