/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.service;

import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import journeymap.client.api.display.Waypoint;
import journeymap.client.data.AllData;
import journeymap.client.data.DataCache;
import journeymap.client.data.HostileMobsData;
import journeymap.client.data.ImagesData;
import journeymap.client.data.MessagesData;
import journeymap.client.data.NpcsData;
import journeymap.client.data.PassiveMobsData;
import journeymap.client.data.PlayerData;
import journeymap.client.data.PlayersData;
import journeymap.client.data.WaypointsData;
import journeymap.client.data.WorldData;
import journeymap.client.model.EntityDTO;
import journeymap.client.service.BaseService;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import se.rupy.http.Event;
import se.rupy.http.Query;

public class DataService
extends BaseService {
    public static final String combinedPath;
    public static final HashMap<String, Class> providerMap;
    private static final long serialVersionUID = 4412225358529161454L;

    @Override
    public String path() {
        return combinedPath;
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        try {
            Query query = event.query();
            query.parse();
            String path = query.path();
            if (!path.equals("/data/messages")) {
                if (!Journeymap.getClient().isMapping().booleanValue()) {
                    this.throwEventException(503, "JourneyMap not mapping", event, false);
                } else if (Journeymap.clientWorld() == null) {
                    this.throwEventException(503, "World not connected", event, false);
                }
            }
            long since = 0L;
            Object sinceVal = query.get("images.since");
            if (sinceVal != null) {
                try {
                    since = Long.parseLong(sinceVal.toString());
                }
                catch (Exception e) {
                    Journeymap.getLogger().warn("Bad value for images.since: " + sinceVal);
                    since = new Date().getTime();
                }
            }
            Class dpClass = providerMap.get(path);
            Object data = null;
            if (dpClass == AllData.class) {
                data = DataCache.INSTANCE.getAll(since);
            } else if (dpClass == PassiveMobsData.class) {
                data = DataCache.INSTANCE.getPassiveMobs(false);
            } else if (dpClass == HostileMobsData.class) {
                data = DataCache.INSTANCE.getHostileMobs(false);
            } else if (dpClass == ImagesData.class) {
                data = new ImagesData(since);
            } else if (dpClass == MessagesData.class) {
                data = DataCache.INSTANCE.getMessages(false);
            } else if (dpClass == PlayerData.class) {
                data = DataCache.INSTANCE.getPlayer(false);
            } else if (dpClass == PlayersData.class) {
                data = DataCache.INSTANCE.getPlayers(false);
            } else if (dpClass == WorldData.class) {
                data = DataCache.INSTANCE.getWorld(false);
            } else if (dpClass == NpcsData.class) {
                data = DataCache.INSTANCE.getNpcs(false);
            } else if (dpClass == NpcsData.class) {
                data = DataCache.INSTANCE.getNpcs(false);
            } else if (dpClass == WaypointsData.class) {
                HashMap<String, EntityDTO> wpMap = new HashMap<String, EntityDTO>();
                int playerDim = Journeymap.clientPlayer().field_71093_bK;
                for (Waypoint waypoint : WaypointStore.INSTANCE.getAll(playerDim)) {
                    wpMap.put(waypoint.getId(), (EntityDTO)((Object)waypoint));
                }
                data = wpMap;
            }
            String dataString = GSON.toJson(data);
            StringBuffer jsonData = new StringBuffer();
            boolean useJsonP = query.containsKey("callback");
            if (useJsonP) {
                jsonData.append(URLEncoder.encode(query.get("callback").toString(), UTF8.name()));
                jsonData.append("(");
            } else {
                jsonData.append("data=");
            }
            jsonData.append(dataString);
            if (useJsonP) {
                jsonData.append(")");
            }
            BaseService.ResponseHeader.on(event).noCache().contentType(BaseService.ContentType.jsonp);
            this.gzipResponse(event, jsonData.toString());
        }
        catch (Event eventEx) {
            throw eventEx;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Unexpected error in data service: %s", LogFormatter.toString(t)));
            this.throwEventException(500, "Error retrieving " + this.path, event, true);
        }
    }

    static {
        providerMap = new HashMap(14);
        providerMap.put("/data/all", AllData.class);
        providerMap.put("/data/image", ImagesData.class);
        providerMap.put("/data/messages", MessagesData.class);
        providerMap.put("/data/player", PlayerData.class);
        providerMap.put("/data/world", WorldData.class);
        providerMap.put("/data/waypoints", WaypointsData.class);
        StringBuffer sb = new StringBuffer();
        for (String key : providerMap.keySet()) {
            sb.append(key).append(":");
        }
        combinedPath = sb.toString();
    }
}

