/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.feature.ClientFeatures;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.dialog.FeatureDialog;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Mouse;

public abstract class JmUI
extends GuiScreen {
    protected final String title;
    protected final int headerHeight = 35;
    protected final Logger logger = Journeymap.getLogger();
    protected GuiScreen returnDisplay;
    protected int scaleFactor = 1;
    protected TextureImpl logo = TextureCache.getTexture(TextureCache.Logo);

    public JmUI(String title) {
        this(title, null);
    }

    public JmUI(String title, GuiScreen returnDisplay) {
        this.title = title;
        this.returnDisplay = returnDisplay;
        if (this.returnDisplay != null && this.returnDisplay instanceof JmUI) {
            JmUI jmReturnDisplay = (JmUI)this.returnDisplay;
            if (jmReturnDisplay.returnDisplay instanceof JmUI) {
                jmReturnDisplay.returnDisplay = null;
            }
        }
    }

    public Minecraft getMinecraft() {
        return this.field_146297_k;
    }

    public void func_146280_a(Minecraft minecraft, int width, int height) {
        super.func_146280_a(minecraft, width, height);
        this.scaleFactor = new ScaledResolution(minecraft).func_78325_e();
    }

    public boolean func_73868_f() {
        return true;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public static FontRenderer fontRenderer() {
        return FMLClientHandler.instance().getClient().field_71466_p;
    }

    public void sizeDisplay(boolean scaled) {
        int glwidth = scaled ? this.field_146294_l : this.field_146297_k.field_71443_c;
        int glheight = scaled ? this.field_146295_m : this.field_146297_k.field_71440_d;
        DrawUtil.sizeDisplay(glwidth, glheight);
    }

    protected boolean isMouseOverButton(int mouseX, int mouseY) {
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            Button button;
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
            if (!(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseEvent) {
        super.func_146286_b(mouseX, mouseY, mouseEvent);
    }

    protected void drawLogo() {
        if (this.logo.isDefunct()) {
            this.logo = TextureCache.getTexture(TextureCache.Logo);
        }
        DrawUtil.sizeDisplay(this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        DrawUtil.drawImage(this.logo, 8.0, 8.0, false, 0.5f, 0.0);
        DrawUtil.sizeDisplay(this.field_146294_l, this.field_146295_m);
    }

    protected void drawTitle() {
        DrawUtil.drawRectangle(0.0, 0.0, this.field_146294_l, 35.0, 0, 0.4f);
        DrawUtil.drawLabel(this.title, this.field_146294_l / 2, 17.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 0.0f, Color.CYAN.getRGB(), 1.0f, 1.0, true, 0.0);
        String apiVersion = "API v2.0-SNAPSHOT";
        DrawUtil.drawLabel(apiVersion, this.field_146294_l - 10, 17.0, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, 0xCCCCCC, 1.0f, 0.5, true, 0.0);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
    }

    public void func_146278_c(int tint) {
        if (Journeymap.clientWorld() == null) {
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
        } else {
            this.func_146276_q_();
        }
    }

    protected abstract void layoutButtons();

    public List getButtonList() {
        return this.field_146292_n;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        try {
            this.func_146278_c(0);
            this.layoutButtons();
            this.drawTitle();
            this.drawLogo();
            List<String> tooltip = null;
            for (int k = 0; k < this.field_146292_n.size(); ++k) {
                Button button;
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
                guibutton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
                if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(mouseX, mouseY)) continue;
                tooltip = button.getTooltip();
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.drawHoveringText(tooltip, mouseX, mouseY, this.getFontRenderer());
                RenderHelper.func_74518_a();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Error in UI %s: %s", ((Object)((Object)this)).getClass().getSimpleName(), LogFormatter.toString(t)));
            this.closeAndReturn();
        }
    }

    protected void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    public void close() {
    }

    protected void closeAndReturn() {
        if (this.returnDisplay == null) {
            if (Journeymap.clientWorld() != null) {
                UIManager.INSTANCE.openFullscreenMap();
            } else {
                UIManager.INSTANCE.closeAll();
            }
        } else {
            if (this.returnDisplay instanceof JmUI) {
                ((JmUI)this.returnDisplay).returnDisplay = null;
            }
            UIManager.INSTANCE.open(this.returnDisplay);
        }
    }

    protected void func_73869_a(char c, int i) throws IOException {
        switch (i) {
            case 1: {
                this.closeAndReturn();
            }
        }
    }

    public void drawHoveringText(String[] tooltip, int mouseX, int mouseY) {
        this.drawHoveringText(Arrays.asList(tooltip), mouseX, mouseY, this.getFontRenderer());
    }

    public GuiScreen getReturnDisplay() {
        return this.returnDisplay;
    }

    public void drawHoveringText(List tooltip, int mouseX, int mouseY, FontRenderer fontRenderer) {
        super.drawHoveringText(tooltip, mouseX, mouseY, fontRenderer);
    }

    protected boolean showDisabled(Feature feature, int dimension, int mouseX, int mouseY) {
        boolean disabled;
        boolean bl = disabled = !ClientFeatures.instance().isAllowed(feature, dimension);
        if (disabled) {
            boolean mouseIsOver;
            FontRenderer fr = this.getFontRenderer();
            int y = this.field_146295_m / 2 - fr.field_78288_b;
            String title = ClientFeatures.getFeatureName(feature);
            String subtitle = TextFormatting.RED + Constants.getString("jm.common.disabled_feature");
            int boxWidth = Math.max(fr.func_78256_a(title), fr.func_78256_a(subtitle));
            int x = (this.field_146294_l - boxWidth) / 2 - 12;
            boolean bl2 = mouseIsOver = mouseX >= x + 6 && mouseX <= x + boxWidth + 16 && mouseY >= y - fr.field_78288_b * 2 + 2 && mouseY <= y + fr.field_78288_b + 2;
            if (mouseIsOver) {
                title = TextFormatting.UNDERLINE + title;
            }
            this.func_146283_a(Arrays.asList(title, subtitle), x, y);
            RenderHelper.func_74518_a();
            if (mouseIsOver && Mouse.isButtonDown((int)0)) {
                UIManager.INSTANCE.open(FeatureDialog.class, this);
                this.close();
            }
        }
        return disabled;
    }
}

