/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.properties.config;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import journeymap.client.cartography.color.RGB;
import journeymap.client.model.GridSpec;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.DimensionPolicies;
import journeymap.common.feature.PlayerFeatures;
import journeymap.common.feature.Policy;
import journeymap.common.feature.PolicyTable;
import journeymap.common.properties.Category;
import journeymap.common.properties.CategorySet;
import journeymap.common.properties.config.BooleanField;
import journeymap.common.properties.config.ConfigField;
import journeymap.common.properties.config.EnumField;
import journeymap.common.properties.config.IntegerField;
import journeymap.common.properties.config.StringField;
import journeymap.common.version.Version;
import net.minecraft.world.GameType;

public abstract class GsonHelper<T extends ConfigField> {
    protected final boolean verbose;

    public static final GsonBuilder BUILDER_COMPACT() {
        return GsonHelper.getGsonBuilder(false, false);
    }

    public static final GsonBuilder BUILDER_TERSE() {
        return GsonHelper.getGsonBuilder(false, true);
    }

    public static final GsonBuilder BUILDER_VERBOSE() {
        return GsonHelper.getGsonBuilder(true, true);
    }

    private static GsonBuilder getGsonBuilder(boolean verbose, boolean pretty) {
        FeatureSerializer fs = new FeatureSerializer();
        GsonBuilder gb = new GsonBuilder().serializeNulls().registerTypeAdapter(BooleanField.class, (Object)new BooleanFieldSerializer(verbose)).registerTypeAdapter(IntegerField.class, (Object)new IntegerFieldSerializer(verbose)).registerTypeAdapter(StringField.class, (Object)new StringFieldSerializer(verbose)).registerTypeAdapter(EnumField.class, (Object)new EnumFieldSerializer(verbose)).registerTypeAdapter(CategorySet.class, (Object)new CategorySetSerializer(verbose)).registerTypeAdapter(Version.class, (Object)new VersionSerializer(verbose)).registerTypeAdapter(GridSpec.class, (Object)new GridSpecSerializer(verbose)).registerTypeAdapter(Feature.Action.class, (Object)fs).registerTypeAdapter(Feature.Display.class, (Object)fs).registerTypeAdapter(Feature.Radar.class, (Object)fs).registerTypeAdapter(Feature.MapType.class, (Object)fs).registerTypeAdapter(Feature.class, (Object)fs).registerTypeAdapter(DimensionPolicies.class, (Object)new DimensionPoliciesSerializer(verbose)).registerTypeAdapter(PolicyTable.class, (Object)new PolicyTableSerializer(verbose));
        if (pretty) {
            gb.setPrettyPrinting();
        }
        return gb;
    }

    public GsonHelper(Boolean verbose) {
        this.verbose = verbose;
    }

    public JsonElement serializeAttributes(ConfigField<?> src, Type typeOfSrc, JsonSerializationContext context) {
        if (!this.verbose) {
            return context.serialize((Object)src.getStringAttr("value"));
        }
        JsonObject jsonObject = new JsonObject();
        for (String attrName : src.getAttributeNames()) {
            jsonObject.addProperty(attrName, src.getStringAttr(attrName));
        }
        return jsonObject;
    }

    protected T deserializeAttributes(T result, JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!this.verbose || !json.isJsonObject()) {
            ((ConfigField)result).put("value", json.getAsString());
        } else {
            Set set = json.getAsJsonObject().entrySet();
            for (Map.Entry entry : set) {
                try {
                    ((ConfigField)result).put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                catch (Throwable t) {
                    Journeymap.getLogger().warn("Error deserializing %s in %s: %s", (Object)entry, (Object)json, (Object)t);
                }
            }
        }
        return result;
    }

    public static class DimensionPoliciesSerializer
    implements JsonSerializer<DimensionPolicies>,
    JsonDeserializer<DimensionPolicies> {
        protected final boolean verbose;

        public DimensionPoliciesSerializer(boolean verbose) {
            this.verbose = verbose;
        }

        public JsonElement serialize(DimensionPolicies src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            result.addProperty("dimension", (Number)src.getDimension());
            result.add("policies", context.serialize((Object)src, PolicyTable.class));
            return result;
        }

        public DimensionPolicies deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject result = json.getAsJsonObject();
            int dimension = result.get("dimension").getAsInt();
            PolicyTable table = (PolicyTable)context.deserialize(result.get("policies"), PolicyTable.class);
            DimensionPolicies dimPolicies = new DimensionPolicies(dimension);
            dimPolicies.update(table);
            return dimPolicies;
        }
    }

    public static class PolicyTableSerializer
    implements JsonSerializer<PolicyTable>,
    JsonDeserializer<PolicyTable> {
        protected final boolean verbose;

        public PolicyTableSerializer(boolean verbose) {
            this.verbose = verbose;
        }

        public JsonElement serialize(PolicyTable src, Type typeOfSrc, JsonSerializationContext context) {
            HashBasedTable<Feature, GameType, Policy> policies = src.getTable();
            JsonObject jsonTable = new JsonObject();
            for (Feature feature : PlayerFeatures.ALL_FEATURES) {
                if (!policies.containsRow((Object)feature)) continue;
                String featureString = context.serialize((Object)feature).getAsString();
                JsonArray jsonPolicies = this.verbose ? new JsonArray() : new JsonObject();
                jsonTable.add(featureString, (JsonElement)jsonPolicies);
                for (GameType gameType : PlayerFeatures.VALID_GAME_TYPES) {
                    if (!policies.contains((Object)feature, (Object)gameType)) continue;
                    Policy policy = (Policy)policies.get((Object)feature, (Object)gameType);
                    if (this.verbose) {
                        jsonPolicies.getAsJsonArray().add(context.serialize((Object)policy));
                        continue;
                    }
                    jsonPolicies.getAsJsonObject().addProperty(gameType.func_77149_b(), Boolean.valueOf(policy.isAllowed()));
                }
            }
            return jsonTable;
        }

        public PolicyTable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonTable = json.getAsJsonObject();
            PolicyTable table = new PolicyTable();
            for (Map.Entry jsonFeatureRow : jsonTable.entrySet()) {
                JsonArray jsonPolicies;
                Feature feature = (Feature)context.deserialize((JsonElement)new JsonPrimitive((String)jsonFeatureRow.getKey()), Feature.class);
                JsonElement value = (JsonElement)jsonFeatureRow.getValue();
                if (value.isJsonArray()) {
                    jsonPolicies = value.getAsJsonArray();
                    for (JsonElement jsonPolicy : jsonPolicies) {
                        Policy policy = (Policy)context.deserialize(jsonPolicy, Policy.class);
                        table.getTable().put((Object)feature, (Object)policy.getGameType(), (Object)policy);
                    }
                    continue;
                }
                jsonPolicies = value.getAsJsonObject();
                String origin = "jm.common.server_config";
                for (Map.Entry entry : jsonPolicies.entrySet()) {
                    GameType gameType = GameType.func_77142_a((String)((String)entry.getKey()));
                    if (!PlayerFeatures.VALID_GAME_TYPES.contains(gameType)) continue;
                    Policy policy = Policy.update(origin, gameType, feature, ((JsonElement)entry.getValue()).getAsBoolean());
                    table.getTable().put((Object)feature, (Object)policy.getGameType(), (Object)policy);
                }
            }
            return table;
        }
    }

    public static class FeatureSerializer
    implements JsonSerializer<Enum<? extends Feature>>,
    JsonDeserializer<Feature> {
        private final String BASE = Feature.class.getCanonicalName() + "$";

        public JsonElement serialize(Enum<? extends Feature> src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)String.format("%s.%s", ((Class)typeOfSrc).getSimpleName(), src.name()));
        }

        public Feature deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                String prim = json.getAsString();
                int idx = prim.lastIndexOf(46);
                String className = this.BASE + prim.substring(0, idx);
                String name = prim.substring(idx + 1);
                Class<?> klass = Class.forName(className);
                return (Feature)Enum.valueOf(klass, name);
            }
            catch (Exception e) {
                throw new JsonParseException("Couldn't parse: " + json + ": " + e.getMessage());
            }
        }
    }

    public static class EnumFieldSerializer
    extends GsonHelper<EnumField>
    implements JsonSerializer<EnumField>,
    JsonDeserializer<EnumField> {
        public EnumFieldSerializer(boolean verbose) {
            super(verbose);
        }

        public JsonElement serialize(EnumField src, Type typeOfSrc, JsonSerializationContext context) {
            return this.serializeAttributes(src, typeOfSrc, context);
        }

        public EnumField deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.deserializeAttributes(new EnumField(), json, typeOfT, context);
        }
    }

    public static class StringFieldSerializer
    extends GsonHelper<StringField>
    implements JsonSerializer<StringField>,
    JsonDeserializer<StringField> {
        public StringFieldSerializer(boolean verbose) {
            super(verbose);
        }

        public JsonElement serialize(StringField src, Type typeOfSrc, JsonSerializationContext context) {
            return this.serializeAttributes(src, typeOfSrc, context);
        }

        public StringField deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.deserializeAttributes(new StringField(), json, typeOfT, context);
        }
    }

    public static class IntegerFieldSerializer
    extends GsonHelper<IntegerField>
    implements JsonSerializer<IntegerField>,
    JsonDeserializer<IntegerField> {
        public IntegerFieldSerializer(boolean verbose) {
            super(verbose);
        }

        public JsonElement serialize(IntegerField src, Type typeOfSrc, JsonSerializationContext context) {
            return this.serializeAttributes(src, typeOfSrc, context);
        }

        public IntegerField deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.deserializeAttributes(new IntegerField(), json, typeOfT, context);
        }
    }

    public static class BooleanFieldSerializer
    extends GsonHelper<BooleanField>
    implements JsonSerializer<BooleanField>,
    JsonDeserializer<BooleanField> {
        public BooleanFieldSerializer(boolean verbose) {
            super(verbose);
        }

        public JsonElement serialize(BooleanField src, Type typeOfSrc, JsonSerializationContext context) {
            return this.serializeAttributes(src, typeOfSrc, context);
        }

        public BooleanField deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return this.deserializeAttributes(new BooleanField(), json, typeOfT, context);
        }
    }

    public static class GridSpecSerializer
    implements JsonSerializer<GridSpec>,
    JsonDeserializer<GridSpec> {
        public GridSpecSerializer(boolean verbose) {
        }

        public JsonElement serialize(GridSpec src, Type typeOfSrc, JsonSerializationContext context) {
            String string = Joiner.on((String)",").join((Object)src.style, (Object)RGB.toHexString(src.getColor()), new Object[]{Float.valueOf(src.alpha), src.getColorX(), src.getColorY()});
            return context.serialize((Object)string);
        }

        public GridSpec deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = json.getAsJsonObject();
                GridSpec gridSpec = new GridSpec(GridSpec.Style.valueOf(GridSpec.Style.class, jo.get("style").getAsString()), jo.get("red").getAsFloat(), jo.get("green").getAsFloat(), jo.get("blue").getAsFloat(), jo.get("alpha").getAsFloat());
                gridSpec.setColorCoords(jo.get("colorX").getAsInt(), jo.get("colorY").getAsInt());
                return gridSpec;
            }
            String[] parts = json.getAsString().split(",");
            GridSpec gridSpec = new GridSpec(GridSpec.Style.valueOf(GridSpec.Style.class, parts[0]), new Color(RGB.hexToInt(parts[1])), Float.parseFloat(parts[2]));
            gridSpec.setColorCoords(Integer.parseInt(parts[3]), Integer.parseInt(parts[4]));
            return gridSpec;
        }
    }

    public static class VersionSerializer
    implements JsonSerializer<Version>,
    JsonDeserializer<Version> {
        public VersionSerializer(boolean verbose) {
        }

        public JsonElement serialize(Version src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.toString());
        }

        public Version deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jo = json.getAsJsonObject();
                return Version.from(jo.get("major").getAsString(), jo.get("minor").getAsString(), jo.get("micro").getAsString(), jo.get("patch").getAsString(), Journeymap.JM_VERSION);
            }
            return Version.from(json.getAsString(), Journeymap.JM_VERSION);
        }
    }

    public static class CategorySetSerializer
    implements JsonSerializer<CategorySet>,
    JsonDeserializer<CategorySet> {
        protected final boolean verbose;

        public CategorySetSerializer(boolean verbose) {
            this.verbose = verbose;
        }

        public JsonElement serialize(CategorySet src, Type typeOfSrc, JsonSerializationContext context) {
            if (!this.verbose) {
                return null;
            }
            Category[] array = new Category[src.size()];
            return context.serialize((Object)src.toArray(array));
        }

        public CategorySet deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            CategorySet categorySet = new CategorySet();
            if (this.verbose) {
                JsonArray jsonArray = json.getAsJsonArray();
                for (JsonElement jsonElement : jsonArray) {
                    categorySet.add((Category)context.deserialize(jsonElement, Category.class));
                }
            }
            return categorySet;
        }
    }
}

