/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.api.impl;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.DimensionPolicies;
import journeymap.common.feature.PlayerFeatures;
import journeymap.common.network.PacketHandler;
import journeymap.server.JourneymapServer;
import journeymap.server.api.IServerAPI;
import journeymap.server.feature.ServerFeatures;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public enum ServerAPI implements IServerAPI
{
    INSTANCE;

    private final Logger LOGGER = Journeymap.getLogger();
    final Map<UUID, PlayerFeatures> playerFeaturesMap = Collections.synchronizedMap(new HashMap());
    final Multimap<UUID, Integer> pausedPlayerQueue = MultimapBuilder.hashKeys().hashSetValues().build();
    final transient ScheduledExecutorService taskExecutor = Executors.newScheduledThreadPool(0);

    private ServerAPI() {
        this.log("implements JourneyMap API 2.0-SNAPSHOT");
    }

    @Override
    public void setPlayerFeatures(String modId, UUID playerID, int dimension, GameType gameType, Map<Feature, Boolean> featureMap) {
        DimensionPolicies newPolicies = new DimensionPolicies(dimension);
        newPolicies.update(gameType, featureMap, modId);
        DimensionPolicies currentPolicies = this.getFeatures(playerID).get(dimension);
        currentPolicies.update(newPolicies);
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(playerID);
        if (player != null && !this.pausedPlayerQueue.containsEntry((Object)playerID, (Object)dimension)) {
            PacketHandler.sendDimensionPolicyPacketToPlayer(player, newPolicies, false);
        }
    }

    @Override
    public Map<Feature, Boolean> getPlayerFeatures(UUID playerID, int dimension, GameType gameType) {
        return this.getFeatures(playerID).get(dimension).getPermissionMap(gameType);
    }

    @Override
    public Map<Feature, Boolean> getServerFeatures(int dimension, GameType gameType) {
        return ServerFeatures.createDimensionPolicies(dimension, false).getPermissionMap(gameType);
    }

    public boolean pauseClientPackets(EntityPlayerMP player) {
        return this.pausedPlayerQueue.put((Object)player.func_110124_au(), (Object)player.field_71093_bK);
    }

    public boolean resumeClientPackets(EntityPlayerMP player) {
        return this.pausedPlayerQueue.remove((Object)player.func_110124_au(), (Object)player.field_71093_bK);
    }

    public void sendDimensionPolicies(EntityPlayerMP player, int dimension, int delayMs) {
        if (delayMs < 1) {
            this.sendDimensionPolicies(player, dimension);
        } else {
            this.taskExecutor.schedule(() -> this.sendDimensionPolicies(player, dimension), (long)delayMs, TimeUnit.MILLISECONDS);
        }
    }

    public void sendDimensionPolicies(EntityPlayerMP player, int dimension) {
        if (JourneymapServer.isOp(player.func_110124_au())) {
            Journeymap.getLogger().info("SENDING OP FEATURES: " + dimension);
        } else {
            Journeymap.getLogger().info("SENDING PLAYER FEATURES: " + dimension);
        }
        DimensionPolicies dimPolicies = this.getFeatures(player.func_110124_au()).get(dimension);
        PacketHandler.sendDimensionPolicyPacketToPlayer(player, dimPolicies, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerFeatures getFeatures(UUID playerUUID) {
        Map<UUID, PlayerFeatures> map = this.playerFeaturesMap;
        synchronized (map) {
            return this.playerFeaturesMap.computeIfAbsent(playerUUID, id -> new ServerFeatures(playerUUID));
        }
    }

    private void log(String message) {
        this.LOGGER.info(String.format("[%s] %s", this.getClass().getSimpleName(), message));
    }

    private void logError(String message) {
        this.LOGGER.error(String.format("[%s] %s", this.getClass().getSimpleName(), message));
    }

    private void logDebug(String message) {
        this.LOGGER.debug(String.format("[%s] %s", this.getClass().getSimpleName(), message));
    }

    void logError(String message, Throwable t) {
        this.LOGGER.error(String.format("[%s] %s", this.getClass().getSimpleName(), message), t);
    }
}

