/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import java.io.File;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.api.util.ClientPluginHelper;
import journeymap.client.cartography.ChunkRenderController;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.data.DataCache;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.io.FileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.log.ChatLog;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.model.RegionImageCache;
import journeymap.client.network.WorldInfoHandler;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.properties.TopoProperties;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.properties.WebMapProperties;
import journeymap.client.render.map.TileDrawStepCache;
import journeymap.client.service.WebServer;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.main.MainTaskController;
import journeymap.client.task.main.MappingMonitorTask;
import journeymap.client.task.multi.ITaskManager;
import journeymap.client.task.multi.TaskController;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.CommonProxy;
import journeymap.common.Journeymap;
import journeymap.common.command.CommandJTP;
import journeymap.common.log.LogFormatter;
import journeymap.common.migrate.Migration;
import journeymap.common.network.PacketHandler;
import journeymap.common.version.VersionCheck;
import journeymap.server.JourneymapServer;
import modinfo.ModInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class JourneymapClient
implements CommonProxy {
    public static final String FULL_VERSION = "1.12.2-" + Journeymap.JM_VERSION;
    public static final String MOD_NAME = "JourneyMap " + FULL_VERSION;
    private boolean serverEnabled = false;
    public volatile ASMDataTable asmDataTable;
    private volatile CoreProperties coreProperties;
    private volatile FullMapProperties fullMapProperties;
    private volatile MiniMapProperties miniMapProperties1;
    private volatile MiniMapProperties miniMapProperties2;
    private volatile TopoProperties topoProperties;
    private volatile WebMapProperties webMapProperties;
    private volatile WaypointProperties waypointProperties;
    private volatile Boolean initialized = false;
    private volatile String currentWorldId = null;
    private Logger logger;
    private boolean threadLogging = false;
    private final MainTaskController mainThreadTaskController = new MainTaskController();
    private TaskController multithreadTaskController;
    private ChunkRenderController chunkRenderController;

    public static GameType getGameType() {
        return FMLClientHandler.instance().getClient().field_71442_b.func_178889_l();
    }

    public CoreProperties getCoreProperties() {
        return this.coreProperties;
    }

    public FullMapProperties getFullMapProperties() {
        return this.fullMapProperties;
    }

    public TopoProperties getTopoProperties() {
        return this.topoProperties;
    }

    public void disable() {
        this.initialized = false;
        EventHandlerManager.unregisterAll();
        this.stopMapping();
        ClientAPI.INSTANCE.purge();
        DataCache.INSTANCE.purge();
    }

    public MiniMapProperties getMiniMapProperties(int which) {
        switch (which) {
            case 2: {
                this.miniMapProperties2.setActive(true);
                this.miniMapProperties1.setActive(false);
                return this.getMiniMapProperties2();
            }
        }
        this.miniMapProperties1.setActive(true);
        this.miniMapProperties2.setActive(false);
        return this.getMiniMapProperties1();
    }

    public int getActiveMinimapId() {
        if (this.miniMapProperties1.isActive()) {
            return 1;
        }
        return 2;
    }

    public MiniMapProperties getMiniMapProperties1() {
        return this.miniMapProperties1;
    }

    public MiniMapProperties getMiniMapProperties2() {
        return this.miniMapProperties2;
    }

    public WebMapProperties getWebMapProperties() {
        return this.webMapProperties;
    }

    public WaypointProperties getWaypointProperties() {
        return this.waypointProperties;
    }

    @Override
    public void preInitialize(FMLPreInitializationEvent event) throws Throwable {
        try {
            this.asmDataTable = event.getAsmData();
            ClientPluginHelper.instance().preInitPlugins(this.asmDataTable);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void initialize(FMLInitializationEvent event) throws Throwable {
        PacketHandler.init(Side.CLIENT);
        StatTimer timer = null;
        try {
            timer = StatTimer.getDisposable("elapsed").start();
            boolean migrationOk = new Migration("journeymap.client.task.migrate").performTasks();
            this.logger = JMLogger.init();
            this.logger.info("initialize ENTER");
            if (this.initialized.booleanValue()) {
                this.logger.warn("Already initialized, aborting");
                return;
            }
            EntityRegistry.instance();
            this.loadConfigProperties();
            JMLogger.logProperties();
            EventHandlerManager.registerHandlers();
            this.threadLogging = false;
            ClientPluginHelper.instance().initPlugins(ClientAPI.INSTANCE);
            this.logger.info("initialize EXIT, " + (timer == null ? "" : timer.getLogReportString()));
        }
        catch (Throwable t) {
            if (this.logger == null) {
                this.logger = LogManager.getLogger((String)"journeymap");
            }
            this.logger.error(LogFormatter.toString(t));
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postInitialize(FMLPostInitializationEvent event) {
        StatTimer timer = null;
        try {
            this.logger.debug("postInitialize ENTER");
            timer = StatTimer.getDisposable("elapsed").start();
            this.queueMainThreadTask(new MappingMonitorTask());
            ThemeLoader.initialize(true);
            WebServer.setEnabled(this.webMapProperties.enabled.get(), false);
            this.initialized = true;
            VersionCheck.getVersionAvailable();
            ModInfo modInfo = new ModInfo("UA-28839029-5", "en_US", "journeymap", MOD_NAME, FULL_VERSION, false);
            modInfo.reportAppView();
            this.logger.debug("postInitialize EXIT, " + (timer == null ? "" : timer.stopAndReport()));
        }
        catch (Throwable t) {
            try {
                if (this.logger == null) {
                    this.logger = LogManager.getLogger((String)"journeymap");
                }
                this.logger.error(LogFormatter.toString(t));
                this.logger.debug("postInitialize EXIT, " + (timer == null ? "" : timer.stopAndReport()));
            }
            catch (Throwable throwable) {
                this.logger.debug("postInitialize EXIT, " + (timer == null ? "" : timer.stopAndReport()));
                throw throwable;
            }
        }
        JMLogger.setLevelFromProperties();
    }

    @Override
    public void serverStartingEvent(FMLServerStartingEvent event) throws Throwable {
        event.registerServerCommand((ICommand)new CommandJTP());
        if (!event.getServer().func_71262_S() && this.asmDataTable != null) {
            JourneymapServer.preInitialize(this.asmDataTable);
            JourneymapServer.initialize();
        }
    }

    @Override
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return true;
    }

    @Override
    public boolean isUpdateCheckEnabled() {
        return this.getCoreProperties().checkUpdates.get();
    }

    public Boolean isInitialized() {
        return this.initialized;
    }

    public Boolean isMapping() {
        return this.initialized != false && this.multithreadTaskController != null && this.multithreadTaskController.isActive() != false;
    }

    public Boolean isThreadLogging() {
        return this.threadLogging;
    }

    public WebServer getJmServer() {
        return WebServer.getInstance();
    }

    public void queueOneOff(Runnable runnable) throws Exception {
        if (this.multithreadTaskController != null) {
            this.multithreadTaskController.queueOneOff(runnable);
        }
    }

    public void toggleTask(Class<? extends ITaskManager> managerClass, boolean enable, Object params) {
        if (this.multithreadTaskController != null) {
            this.multithreadTaskController.toggleTask(managerClass, enable, params);
        }
    }

    public boolean isTaskManagerEnabled(Class<? extends ITaskManager> managerClass) {
        if (this.multithreadTaskController != null) {
            return this.multithreadTaskController.isTaskManagerEnabled(managerClass);
        }
        return false;
    }

    public boolean isMainThreadTaskActive() {
        if (this.mainThreadTaskController != null) {
            return this.mainThreadTaskController.isActive();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMapping() {
        JourneymapClient journeymapClient = this;
        synchronized (journeymapClient) {
            boolean created;
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (mc == null || this.world() == null || !this.initialized.booleanValue() || !this.coreProperties.mappingEnabled.get().booleanValue()) {
                return;
            }
            File worldDir = FileHandler.getJMWorldDir(mc, this.currentWorldId);
            if (worldDir == null) {
                return;
            }
            if (!worldDir.exists() && !(created = worldDir.mkdirs())) {
                JMLogger.logOnce("CANNOT CREATE DATA DIRECTORY FOR WORLD: " + worldDir.getPath(), null);
                return;
            }
            this.reset();
            this.multithreadTaskController = new TaskController();
            this.multithreadTaskController.enableTasks();
            long totalMB = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
            long freeMB = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
            String memory = String.format("Memory: %sMB total, %sMB free", totalMB, freeMB);
            int dimension = this.world().field_73011_w.getDimension();
            this.logger.info(String.format("Mapping started in %s%sDIM%s. %s ", FileHandler.getJMWorldDir(mc, this.currentWorldId), File.separator, dimension, memory));
            ClientAPI.INSTANCE.getClientEventManager().fireMappingEvent(true, dimension);
            UIManager.INSTANCE.getMiniMap().reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMapping() {
        JourneymapClient journeymapClient = this;
        synchronized (journeymapClient) {
            DataCache.INSTANCE.invalidateChunkMDCache();
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (this.isMapping().booleanValue() && mc != null) {
                this.logger.info(String.format("Mapping halted in %s%sDIM%s", FileHandler.getJMWorldDir(mc, this.currentWorldId), File.separator, this.world().field_73011_w.getDimension()));
                RegionImageCache.INSTANCE.flushToDiskAsync(true);
                ColorPalette colorPalette = ColorPalette.getActiveColorPalette();
                if (colorPalette != null) {
                    colorPalette.writeToFile();
                }
            }
            if (this.multithreadTaskController != null) {
                this.multithreadTaskController.disableTasks();
                this.multithreadTaskController.clear();
                this.multithreadTaskController = null;
            }
            if (mc != null) {
                int dimension = this.world() != null ? this.world().field_73011_w.getDimension() : 0;
                ClientAPI.INSTANCE.getClientEventManager().fireMappingEvent(false, dimension);
            }
        }
    }

    private void reset() {
        if (!FMLClientHandler.instance().getClient().func_71356_B() && this.currentWorldId == null) {
            WorldInfoHandler.requestWorldID();
        }
        this.loadConfigProperties();
        DataCache.INSTANCE.purge();
        this.chunkRenderController = new ChunkRenderController();
        Fullscreen.state().requireRefresh();
        Fullscreen.state().follow.set(true);
        StatTimer.resetAll();
        TileDrawStepCache.clear();
        UIManager.INSTANCE.getMiniMap().reset();
        UIManager.INSTANCE.reset();
        WaypointStore.INSTANCE.reset();
    }

    public void queueMainThreadTask(IMainThreadTask task) {
        this.mainThreadTaskController.addTask(task);
    }

    public void performMainThreadTasks() {
        this.mainThreadTaskController.performTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMultithreadTasks() {
        try {
            JourneymapClient journeymapClient = this;
            synchronized (journeymapClient) {
                if (this.isMapping().booleanValue()) {
                    this.multithreadTaskController.performTasks();
                }
            }
        }
        catch (Throwable t) {
            String error = "Error in JourneyMap.performMultithreadTasks(): " + t.getMessage();
            ChatLog.announceError(error);
            this.logger.error(LogFormatter.toString(t));
        }
    }

    public ChunkRenderController getChunkRenderController() {
        return this.chunkRenderController;
    }

    public void saveConfigProperties() {
        if (this.coreProperties != null) {
            this.coreProperties.save();
        }
        if (this.fullMapProperties != null) {
            this.fullMapProperties.save();
        }
        if (this.miniMapProperties1 != null) {
            this.miniMapProperties1.save();
        }
        if (this.miniMapProperties2 != null) {
            this.miniMapProperties2.save();
        }
        if (this.miniMapProperties2 != null) {
            this.miniMapProperties2.save();
        }
        if (this.topoProperties != null) {
            this.topoProperties.save();
        }
        if (this.webMapProperties != null) {
            this.webMapProperties.save();
        }
        if (this.waypointProperties != null) {
            this.waypointProperties.save();
        }
    }

    public void loadConfigProperties() {
        this.saveConfigProperties();
        this.coreProperties = (CoreProperties)new CoreProperties().load();
        this.fullMapProperties = (FullMapProperties)new FullMapProperties().load();
        this.miniMapProperties1 = (MiniMapProperties)new MiniMapProperties(1).load();
        this.miniMapProperties2 = (MiniMapProperties)new MiniMapProperties(2).load();
        this.topoProperties = (TopoProperties)new TopoProperties().load();
        this.webMapProperties = (WebMapProperties)new WebMapProperties().load();
        this.waypointProperties = (WaypointProperties)new WaypointProperties().load();
    }

    @Override
    public void handleWorldIdMessage(String worldId, EntityPlayerMP playerEntity) {
        this.setCurrentWorldId(worldId);
    }

    public String getCurrentWorldId() {
        return this.currentWorldId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentWorldId(String worldId) {
        JourneymapClient journeymapClient = this;
        synchronized (journeymapClient) {
            boolean directoryUnchanged;
            Minecraft mc = FMLClientHandler.instance().getClient();
            File currentWorldDirectory = FileHandler.getJMWorldDirForWorldId(mc, this.currentWorldId);
            File newWorldDirectory = FileHandler.getJMWorldDir(mc, worldId);
            boolean worldIdUnchanged = Constants.safeEqual(worldId, this.currentWorldId);
            boolean bl = directoryUnchanged = currentWorldDirectory != null && newWorldDirectory != null && currentWorldDirectory.getPath().equals(newWorldDirectory.getPath());
            if (worldIdUnchanged && directoryUnchanged && worldId != null) {
                Journeymap.getLogger().info("World UID hasn't changed: " + worldId);
                return;
            }
            boolean wasMapping = this.isMapping();
            if (wasMapping) {
                this.stopMapping();
            }
            this.currentWorldId = worldId;
            Journeymap.getLogger().info("World UID is set to: " + worldId);
        }
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public void setServerEnabled(boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
    }

    public WorldClient world() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    public EntityPlayerSP player() {
        return FMLClientHandler.instance().getClient().field_71439_g;
    }
}

