/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.model;

import com.google.common.base.MoreObjects;
import journeymap.client.api.display.Displayable;

public class MapText<T extends MapText> {
    public static float DEFAULT_SCALE = 1.0f;
    public static int DEFAULT_COLOR = 0xFFFFFF;
    public static float DEFAULT_OPACITY = 1.0f;
    public static int DEFAULT_BACKGROUND_COLOR = 0;
    public static float DEFAULT_BACKGROUND_OPACITY = 0.7f;
    public static int DEFAULT_MIN_ZOOM = 0;
    public static int DEFAULT_MAX_ZOOM = 0;
    public static int DEFAULT_OFFSET_X = 0;
    public static int DEFAULT_OFFSET_Y = 0;
    public static boolean DEFAULT_FONT_SHADOW = true;
    protected Float scale;
    protected Integer color;
    protected Integer backgroundColor;
    protected Float opacity;
    protected Float backgroundOpacity;
    protected Boolean fontShadow;
    protected Integer minZoom;
    protected Integer maxZoom;
    protected Integer offsetX;
    protected Integer offsetY;

    public MapText() {
    }

    public MapText(MapText other) {
        this.scale = other.scale;
        this.color = other.color;
        this.backgroundColor = other.backgroundColor;
        this.opacity = other.opacity;
        this.backgroundOpacity = other.backgroundOpacity;
        this.fontShadow = other.fontShadow;
        this.minZoom = other.minZoom;
        this.maxZoom = other.maxZoom;
        this.offsetX = other.offsetX;
        this.offsetY = other.offsetY;
    }

    public float getScale() {
        return this.scale == null ? DEFAULT_SCALE : this.scale.floatValue();
    }

    public T setScale(float scale) {
        this.scale = Float.valueOf(Math.max(1.0f, Math.min(scale, 8.0f)));
        return (T)this;
    }

    public int getColor() {
        return this.color == null ? DEFAULT_COLOR : this.color;
    }

    public T setColor(int color) {
        this.color = Displayable.clampRGB(color);
        return (T)this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor == null ? DEFAULT_BACKGROUND_COLOR : this.backgroundColor;
    }

    public T setBackgroundColor(int backgroundColor) {
        this.backgroundColor = Displayable.clampRGB(backgroundColor);
        return (T)this;
    }

    public float getOpacity() {
        return this.opacity == null ? DEFAULT_OPACITY : this.opacity.floatValue();
    }

    public T setOpacity(float opacity) {
        this.opacity = Float.valueOf(Displayable.clampOpacity(opacity));
        return (T)this;
    }

    public float getBackgroundOpacity() {
        return this.backgroundOpacity == null ? DEFAULT_BACKGROUND_OPACITY : this.backgroundOpacity.floatValue();
    }

    public T setBackgroundOpacity(float backgroundOpacity) {
        this.backgroundOpacity = Float.valueOf(Displayable.clampOpacity(backgroundOpacity));
        return (T)this;
    }

    public boolean hasFontShadow() {
        return this.fontShadow == null ? DEFAULT_FONT_SHADOW : this.fontShadow;
    }

    public T setFontShadow(boolean fontShadow) {
        this.fontShadow = fontShadow;
        return (T)this;
    }

    public int getMinZoom() {
        return this.minZoom == null ? DEFAULT_MIN_ZOOM : this.minZoom;
    }

    public T setMinZoom(int minZoom) {
        this.minZoom = Math.max(0, minZoom);
        return (T)this;
    }

    public int getMaxZoom() {
        return this.maxZoom == null ? DEFAULT_MAX_ZOOM : this.maxZoom;
    }

    public T setMaxZoom(int maxZoom) {
        this.maxZoom = Math.min(8, maxZoom);
        return (T)this;
    }

    public int getOffsetX() {
        return this.offsetX == null ? DEFAULT_OFFSET_X : this.offsetX;
    }

    public T setOffsetX(int offsetX) {
        this.offsetX = offsetX;
        return (T)this;
    }

    public int getOffsetY() {
        return this.offsetY == null ? DEFAULT_OFFSET_Y : this.offsetY;
    }

    public T setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return (T)this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("backgroundColor", (Object)this.backgroundColor).add("backgroundOpacity", (Object)this.backgroundOpacity).add("color", (Object)this.color).add("opacity", (Object)this.opacity).add("fontShadow", (Object)this.fontShadow).add("maxZoom", (Object)this.maxZoom).add("minZoom", (Object)this.minZoom).add("offsetX", (Object)this.offsetX).add("offsetY", (Object)this.offsetY).add("scale", (Object)this.scale).toString();
    }
}

