/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.api.display.Waypoint;
import journeymap.client.data.DataCache;
import journeymap.client.feature.ClientFeatures;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.map.GridRenderer;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.Vec3d;

public class WaypointDrawStepFactory {
    final List<DrawWayPointStep> drawStepList = new ArrayList<DrawWayPointStep>();

    public List<DrawWayPointStep> prepareSteps(Collection<Waypoint> waypoints, GridRenderer grid, boolean checkDistance, boolean showLabel) {
        this.drawStepList.clear();
        int dimension = grid.getMapView().dimension;
        if (!ClientFeatures.instance().isAllowed(Feature.Radar.Waypoint, dimension)) {
            return this.drawStepList;
        }
        EntityPlayerSP player = Journeymap.clientPlayer();
        int maxDistance = Journeymap.getClient().getWaypointProperties().maxDistance.get();
        checkDistance = checkDistance && maxDistance > 0;
        Vec3d playerVec = checkDistance ? player.func_174791_d() : null;
        try {
            for (Waypoint waypoint : waypoints) {
                DrawWayPointStep wayPointStep;
                double actualDistance;
                if (!waypoint.isDisplayed(dimension) || checkDistance && (actualDistance = playerVec.func_72438_d(waypoint.getVec(dimension))) > (double)maxDistance || (wayPointStep = DataCache.INSTANCE.getDrawWayPointStep(waypoint)) == null) continue;
                this.drawStepList.add(wayPointStep);
                wayPointStep.setShowLabel(showLabel);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during prepareSteps: " + LogFormatter.toString(t));
        }
        return this.drawStepList;
    }
}

