/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.multi;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.ChunkRenderController;
import journeymap.client.data.DataCache;
import journeymap.client.feature.ClientFeatures;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.MapView;
import journeymap.client.properties.CoreProperties;
import journeymap.client.task.multi.BaseMapTask;
import journeymap.client.task.multi.ITask;
import journeymap.client.task.multi.ITaskManager;
import journeymap.client.task.multi.RenderSpec;
import journeymap.client.task.multi.TaskBatch;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class MapPlayerTask
extends BaseMapTask {
    private static DecimalFormat decFormat = new DecimalFormat("##.#");
    private static volatile long lastTaskCompleted;
    private static long lastTaskTime;
    private static double lastTaskAvgChunkTime;
    private static Cache<String, String> tempDebugLines;
    private final int maxRuntime;
    private int scheduledChunks;
    private long startNs;
    private long elapsedNs;

    private MapPlayerTask(ChunkRenderController chunkRenderController, World world, MapView mapView, Collection<ChunkPos> chunkCoords) {
        super(chunkRenderController, world, mapView, chunkCoords, false, true, 10000);
        this.maxRuntime = Journeymap.getClient().getCoreProperties().renderDelay.get() * 3000;
        this.scheduledChunks = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceNearbyRemap() {
        Class<MapPlayerTask> clazz = MapPlayerTask.class;
        synchronized (MapPlayerTask.class) {
            DataCache.INSTANCE.invalidateChunkMDCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static MapPlayerTaskBatch create(ChunkRenderController chunkRenderController, EntityDTO player) {
        Entity playerEntity = (Entity)player.entityRef.get();
        if (playerEntity == null) {
            return null;
        }
        int dimension = player.dimension;
        boolean underground = player.underground;
        boolean undergroundAllowed = ClientFeatures.instance().isAllowed(Feature.MapType.Underground, dimension);
        boolean surfaceAllowed = ClientFeatures.instance().isAllowed(Feature.MapType.Day, dimension) || ClientFeatures.instance().isAllowed(Feature.MapType.Night, dimension);
        boolean topoAllowed = Journeymap.getClient().getCoreProperties().mapTopography.get() != false && ClientFeatures.instance().isAllowed(Feature.MapType.Topo, dimension);
        ArrayList<ITask> tasks = new ArrayList<ITask>(2);
        if (underground && undergroundAllowed) {
            tasks.add(new MapPlayerTask(chunkRenderController, playerEntity.field_70170_p, MapView.underground(player), new ArrayList<ChunkPos>()));
            if (surfaceAllowed && Journeymap.getClient().getCoreProperties().alwaysMapSurface.get().booleanValue()) {
                tasks.add(new MapPlayerTask(chunkRenderController, playerEntity.field_70170_p, MapView.day(player), new ArrayList<ChunkPos>()));
            }
        } else if (surfaceAllowed) {
            tasks.add(new MapPlayerTask(chunkRenderController, playerEntity.field_70170_p, MapView.day(player), new ArrayList<ChunkPos>()));
            if (undergroundAllowed && Journeymap.getClient().getCoreProperties().alwaysMapCaves.get().booleanValue()) {
                tasks.add(new MapPlayerTask(chunkRenderController, playerEntity.field_70170_p, MapView.underground(player), new ArrayList<ChunkPos>()));
            }
        }
        if (topoAllowed && Journeymap.getClient().getCoreProperties().mapTopography.get().booleanValue()) {
            tasks.add(new MapPlayerTask(chunkRenderController, playerEntity.field_70170_p, MapView.topo(player), new ArrayList<ChunkPos>()));
        }
        if (tasks.isEmpty()) {
            return null;
        }
        return new MapPlayerTaskBatch(tasks);
    }

    public static String[] getDebugStats() {
        try {
            CoreProperties coreProperties = Journeymap.getClient().getCoreProperties();
            boolean underground = DataCache.getPlayer().underground;
            ArrayList lines = new ArrayList(tempDebugLines.asMap().values());
            if (underground || coreProperties.alwaysMapCaves.get().booleanValue()) {
                lines.add(RenderSpec.getUndergroundSpec().getDebugStats());
            }
            if (!underground || coreProperties.alwaysMapSurface.get().booleanValue()) {
                lines.add(RenderSpec.getSurfaceSpec().getDebugStats());
            }
            if (!underground && coreProperties.mapTopography.get().booleanValue()) {
                lines.add(RenderSpec.getTopoSpec().getDebugStats());
            }
            return lines.toArray(new String[lines.size()]);
        }
        catch (Throwable t) {
            logger.error((Object)t);
            return new String[0];
        }
    }

    public static void addTempDebugMessage(String key, String message) {
        if (Minecraft.func_71410_x().field_71474_y.field_181657_aC) {
            tempDebugLines.put((Object)key, (Object)message);
        }
    }

    public static void removeTempDebugMessage(String key) {
        tempDebugLines.invalidate((Object)key);
    }

    public static String getSimpleStats() {
        RenderSpec spec;
        int primaryRenderSize = 0;
        int secondaryRenderSize = 0;
        int totalChunks = 0;
        if ((DataCache.getPlayer().underground.booleanValue() || Journeymap.getClient().getCoreProperties().alwaysMapCaves.get().booleanValue()) && (spec = RenderSpec.getUndergroundSpec()) != null) {
            primaryRenderSize += spec.getPrimaryRenderSize();
            secondaryRenderSize += spec.getLastSecondaryRenderSize();
            totalChunks += spec.getLastTaskChunks();
        }
        if ((!DataCache.getPlayer().underground.booleanValue() || Journeymap.getClient().getCoreProperties().alwaysMapSurface.get().booleanValue()) && (spec = RenderSpec.getSurfaceSpec()) != null) {
            primaryRenderSize += spec.getPrimaryRenderSize();
            secondaryRenderSize += spec.getLastSecondaryRenderSize();
            totalChunks += spec.getLastTaskChunks();
        }
        return Constants.getString("jm.common.renderstats", totalChunks, primaryRenderSize, secondaryRenderSize, lastTaskTime, decFormat.format(lastTaskAvgChunkTime));
    }

    public static long getlastTaskCompleted() {
        return lastTaskCompleted;
    }

    @Override
    public void initTask(Minecraft minecraft, JourneymapClient jm, File jmWorldDir, boolean threadLogging) throws InterruptedException {
        this.startNs = System.nanoTime();
        RenderSpec renderSpec = null;
        renderSpec = this.mapView.isUnderground() ? RenderSpec.getUndergroundSpec() : (this.mapView.isTopo() ? RenderSpec.getTopoSpec() : RenderSpec.getSurfaceSpec());
        long now = System.currentTimeMillis();
        List<ChunkPos> renderArea = renderSpec.getRenderAreaCoords();
        int maxBatchSize = renderArea.size() / 4;
        renderArea.removeIf(ChunkPos2 -> {
            ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD((ChunkPos)ChunkPos2);
            if (chunkMD == null || !chunkMD.hasChunk() || now - chunkMD.getLastRendered(this.mapView) < 30000L) {
                return true;
            }
            if (chunkMD.getDimension() != this.mapView.dimension) {
                return true;
            }
            chunkMD.resetBlockData(this.mapView);
            return false;
        });
        if (renderArea.size() <= maxBatchSize) {
            this.chunkCoords.addAll(renderArea);
        } else {
            List<ChunkPos> list = Arrays.asList(renderArea.toArray(new ChunkPos[renderArea.size()]));
            this.chunkCoords.addAll(list.subList(0, maxBatchSize));
        }
        this.scheduledChunks = this.chunkCoords.size();
    }

    @Override
    protected void complete(int mappedChunks, boolean cancelled, boolean hadError) {
        this.elapsedNs = System.nanoTime() - this.startNs;
    }

    @Override
    public int getMaxRuntime() {
        return this.maxRuntime;
    }

    static {
        tempDebugLines = CacheBuilder.newBuilder().maximumSize(20L).expireAfterWrite(1500L, TimeUnit.MILLISECONDS).build();
    }

    public static class MapPlayerTaskBatch
    extends TaskBatch {
        public MapPlayerTaskBatch(List<ITask> tasks) {
            super(tasks);
        }

        @Override
        public void performTask(Minecraft mc, JourneymapClient jm, File jmWorldDir, boolean threadLogging) throws InterruptedException {
            if (Journeymap.clientPlayer() == null) {
                return;
            }
            this.startNs = System.nanoTime();
            ArrayList tasks = new ArrayList(this.taskList);
            super.performTask(mc, jm, jmWorldDir, threadLogging);
            this.elapsedNs = System.nanoTime() - this.startNs;
            lastTaskTime = TimeUnit.NANOSECONDS.toMillis(this.elapsedNs);
            lastTaskCompleted = System.currentTimeMillis();
            int chunkCount = 0;
            for (ITask task : tasks) {
                if (task instanceof MapPlayerTask) {
                    MapPlayerTask mapPlayerTask = (MapPlayerTask)task;
                    chunkCount += mapPlayerTask.scheduledChunks;
                    if (mapPlayerTask.mapView.isUnderground()) {
                        RenderSpec.getUndergroundSpec().setLastTaskInfo(mapPlayerTask.scheduledChunks, mapPlayerTask.elapsedNs);
                        continue;
                    }
                    if (mapPlayerTask.mapView.isTopo()) {
                        RenderSpec.getTopoSpec().setLastTaskInfo(mapPlayerTask.scheduledChunks, mapPlayerTask.elapsedNs);
                        continue;
                    }
                    RenderSpec.getSurfaceSpec().setLastTaskInfo(mapPlayerTask.scheduledChunks, mapPlayerTask.elapsedNs);
                    continue;
                }
                Journeymap.getLogger().warn("Unexpected task in batch: " + task);
            }
            lastTaskAvgChunkTime = (double)(this.elapsedNs / (long)Math.max(1, chunkCount)) / 1000000.0;
        }
    }

    public static class Manager
    implements ITaskManager {
        final int mapTaskDelay;
        boolean enabled;

        public Manager() {
            this.mapTaskDelay = Journeymap.getClient().getCoreProperties().renderDelay.get() * 1000;
        }

        public Class<? extends BaseMapTask> getTaskClass() {
            return MapPlayerTask.class;
        }

        @Override
        public boolean enableTask(Minecraft minecraft, Object params) {
            this.enabled = true;
            return this.enabled;
        }

        @Override
        public boolean isEnabled(Minecraft minecraft) {
            return this.enabled;
        }

        @Override
        public void disableTask(Minecraft minecraft) {
            this.enabled = false;
        }

        @Override
        public ITask getTask(Minecraft minecraft) {
            EntityPlayerSP player = Journeymap.clientPlayer();
            if (player != null && this.enabled && player.field_70175_ag && System.currentTimeMillis() - lastTaskCompleted >= (long)this.mapTaskDelay) {
                ChunkRenderController chunkRenderController = Journeymap.getClient().getChunkRenderController();
                return MapPlayerTask.create(chunkRenderController, DataCache.getPlayer());
            }
            return null;
        }

        @Override
        public void taskAccepted(ITask task, boolean accepted) {
        }
    }
}

