/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import journeymap.client.api.display.Waypoint;
import journeymap.client.io.FileHandler;
import journeymap.client.waypoint.IWaypointLoader;
import journeymap.client.waypoint.WaypointLoaderLegacy;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;

public class WaypointLoader
implements IWaypointLoader {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    final File waypointDir;
    final IWaypointLoader legacyLoader;

    WaypointLoader(File waypointDir) {
        this.waypointDir = waypointDir;
        this.legacyLoader = new WaypointLoaderLegacy(waypointDir);
    }

    @Override
    public Collection<Waypoint> loadAll() {
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        File[] files = this.waypointDir.listFiles((dir, name) -> name.endsWith(".json") && !name.equals("waypoint_groups.json"));
        if (files == null || files.length == 0) {
            return waypoints;
        }
        for (File waypointFile : files) {
            Waypoint wp = null;
            if (waypointFile.getName().contains("_waypoint_") && (wp = this.load(waypointFile)) != null) {
                waypoints.add(wp);
                continue;
            }
            wp = this.legacyLoader.load(waypointFile);
            if (wp == null) continue;
            waypoints.add(wp);
            wp.setDirty(true);
        }
        return waypoints;
    }

    @Override
    public boolean save(Waypoint waypoint) {
        if (waypoint.isPersistent()) {
            File waypointFile = null;
            try {
                waypointFile = new File(FileHandler.getWaypointDir(), WaypointStore.getFileName(waypoint));
                Files.write((CharSequence)GSON.toJson((Object)waypoint), (File)waypointFile, (Charset)Charset.forName("UTF-8"));
                this.legacyLoader.save(waypoint);
                return true;
            }
            catch (Exception e) {
                Journeymap.getLogger().error(String.format("Can't save waypoint file %s: %s", waypointFile, LogFormatter.toString(e)));
            }
        }
        return false;
    }

    @Override
    public Waypoint load(File waypointFile) {
        String waypointString = null;
        Waypoint waypoint = null;
        try {
            waypointString = Files.toString((File)waypointFile, (Charset)Charset.forName("UTF-8"));
            waypoint = (Waypoint)GSON.fromJson(waypointString, Waypoint.class);
            this.legacyLoader.save(waypoint);
        }
        catch (Throwable e) {
            Journeymap.getLogger().error(String.format("Can't load waypoint file %s with contents: %s because %s", waypointFile, waypointString, e.getMessage()));
        }
        return waypoint;
    }
}

