/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.api.feature;

import net.minecraft.world.GameType;

public interface Feature {
    public String name();

    default public boolean getDefaultAllowed(boolean isOp, GameType gameType) {
        return true;
    }

    default public String getFeatureType() {
        return this.getClass().getSimpleName();
    }

    default public String getFeatureCategoryKey() {
        return String.format("jm.common.feature.%s", this.getFeatureType().toLowerCase());
    }

    default public String getFeatureKey() {
        return String.format("%s.%s", this.getFeatureCategoryKey(), this.name().toLowerCase());
    }

    default public String getFeatureTooltipKey() {
        return String.format("%s.tooltip", this.getFeatureKey());
    }

    public static enum Radar implements Feature
    {
        HostileMob,
        NPC,
        PassiveMob,
        Player,
        Vehicle,
        Waypoint;

    }

    public static enum MapType implements Feature
    {
        Day,
        Night,
        Underground,
        Topo,
        Biome;

    }

    public static enum Display implements Feature
    {
        Compass(false, true),
        Fullscreen(true, false),
        Minimap(true, false),
        WaypointBeacon(false, true),
        WaypointManager(false, false),
        Webmap(true, false);

        private boolean map;
        private boolean inGame;

        private Display(boolean isMap, boolean isInGame) {
            this.map = isMap;
            this.inGame = isInGame;
        }

        public boolean isMap() {
            return this.map;
        }

        public boolean isInGame() {
            return this.inGame;
        }
    }

    public static enum Action implements Feature
    {
        Teleport;


        @Override
        public boolean getDefaultAllowed(boolean isOp, GameType gameType) {
            switch (this) {
                case Teleport: {
                    return isOp || gameType.func_77145_d();
                }
            }
            return false;
        }
    }
}

