/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.feature;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.annotations.Since;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.DimensionPolicies;
import journeymap.common.feature.Policy;
import net.minecraft.world.GameType;

@ParametersAreNonnullByDefault
public class PlayerFeatures {
    public static List<Feature> ALL_FEATURES = Stream.of(Arrays.stream(Feature.Action.values()), Arrays.stream(Feature.Display.values()), Arrays.stream(Feature.MapType.values()), Arrays.stream(Feature.Radar.values())).flatMap(v -> v).collect(Collectors.toList());
    public static Set<GameType> VALID_GAME_TYPES = Sets.immutableEnumSet((Enum)GameType.SURVIVAL, (Enum[])new GameType[]{GameType.CREATIVE, GameType.ADVENTURE, GameType.SPECTATOR});
    @Since(value=2.0)
    protected final UUID id;
    @Since(value=2.0)
    protected final Map<Integer, DimensionPolicies> dimensionPolicies = Maps.synchronizedNavigableMap(new TreeMap());

    public PlayerFeatures(UUID playerID) {
        this.id = playerID;
    }

    public UUID getID() {
        return this.id;
    }

    public String getJson(int dimension) {
        return this.get(dimension).toJson();
    }

    public boolean isAllowed(GameType gameType, Feature feature, int dimension) {
        return this.get(dimension).isAllowed(gameType, feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DimensionPolicies get(int dimension) {
        Map<Integer, DimensionPolicies> map = this.dimensionPolicies;
        synchronized (map) {
            return this.dimensionPolicies.computeIfAbsent(dimension, this::initializePolicies);
        }
    }

    public void updatePolicies(DimensionPolicies newPolicies) {
        this.get(newPolicies.getDimension()).update(newPolicies);
    }

    public Policy setAllowed(int dimension, GameType gameType, Feature feature, boolean allowed, String origin) {
        return this.get(dimension).setAllowed(gameType, feature, allowed, origin);
    }

    public void reset(int dimension, boolean isOp) {
        this.get(dimension).reset(isOp);
    }

    public void resetAll(boolean isOp) {
        for (int dim : this.dimensionPolicies.keySet()) {
            this.reset(dim, isOp);
        }
    }

    protected DimensionPolicies initializePolicies(int dimension) {
        return new DimensionPolicies(dimension);
    }
}

