/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.feature;

import java.util.UUID;
import journeymap.common.feature.DimensionPolicies;
import journeymap.common.feature.PlayerFeatures;
import journeymap.common.feature.PolicyTable;
import journeymap.server.JourneymapServer;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.PermissionProperties;
import journeymap.server.properties.PropertiesManager;

public class ServerFeatures
extends PlayerFeatures {
    public ServerFeatures(UUID playerID) {
        super(playerID);
    }

    @Override
    protected DimensionPolicies initializePolicies(int dimension) {
        boolean isOp = JourneymapServer.isOp(this.id);
        return ServerFeatures.createDimensionPolicies(dimension, isOp);
    }

    public static DimensionPolicies createDimensionPolicies(int dimension, boolean isOp) {
        DimensionPolicies dimPolicies = new DimensionPolicies(dimension);
        DimensionProperties dimProps = PropertiesManager.getInstance().getDimProperties(dimension, isOp);
        PermissionProperties permProps = dimProps.enabled.get() != false ? dimProps : PropertiesManager.getInstance().getGlobalProperties(isOp);
        PolicyTable otherPolicies = permProps.policies;
        if (otherPolicies != null) {
            dimPolicies.update(otherPolicies);
        }
        return dimPolicies;
    }
}

