/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.properties;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.Map;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.GlobalProperties;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PropertiesManager {
    private static final Supplier<PropertiesManager> LAZYINIT = Suppliers.memoize(PropertiesManager::new);
    private final Map<Integer, DimensionProperties> dimensionProperties = new HashMap<Integer, DimensionProperties>();
    private final Map<Integer, DimensionProperties> dimensionOpProperties = new HashMap<Integer, DimensionProperties>();
    private final GlobalProperties globalProperties;
    private final GlobalProperties globalOpProperties = new GlobalProperties(true);

    public static PropertiesManager getInstance() {
        return (PropertiesManager)LAZYINIT.get();
    }

    private PropertiesManager() {
        this.globalProperties = new GlobalProperties(false);
        this.globalProperties.load();
        for (Integer dim : DimensionManager.getIDs()) {
            this.loadConfig(dim, false);
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server.func_71262_S()) {
            this.globalOpProperties.load();
            for (Integer dim : DimensionManager.getIDs()) {
                this.loadConfig(dim, true);
            }
        }
    }

    public DimensionProperties getDimProperties(int dim, boolean isOp) {
        DimensionProperties dimProps = this.getDimPropertiesMap(isOp).get(dim);
        if (dimProps == null) {
            return this.loadConfig(dim, isOp);
        }
        return dimProps;
    }

    public GlobalProperties getGlobalProperties(boolean isOp) {
        return isOp ? this.globalOpProperties : this.globalProperties;
    }

    private Map<Integer, DimensionProperties> getDimPropertiesMap(boolean isOp) {
        return isOp ? this.dimensionOpProperties : this.dimensionProperties;
    }

    private DimensionProperties loadConfig(int dim, boolean isOp) {
        DimensionProperties prop = new DimensionProperties(dim, isOp);
        this.getDimPropertiesMap(isOp).put(dim, prop);
        if (!prop.getFile().exists()) {
            prop.build(this.getGlobalProperties(isOp));
        }
        prop.load();
        return prop;
    }
}

