/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.command;

import journeymap.client.Constants;
import journeymap.client.api.display.Waypoint;
import journeymap.client.command.ClientCommandInvoker;
import journeymap.client.feature.ClientFeatures;
import journeymap.client.log.ChatLog;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.client.FMLClientHandler;

public class CmdTeleportWaypoint
implements Runnable {
    private final Waypoint waypoint;
    private final int targetDimension;

    public CmdTeleportWaypoint(Waypoint waypoint, int targetDimension) {
        this.waypoint = waypoint;
        this.targetDimension = targetDimension;
    }

    public static boolean isPermitted() {
        EntityPlayerSP player = Journeymap.clientPlayer();
        if (player != null && Journeymap.getClient().isServerEnabled()) {
            return ClientFeatures.instance().isAllowed(Feature.Action.Teleport, player.field_71093_bK);
        }
        return ClientCommandInvoker.commandsAllowed(FMLClientHandler.instance().getClient());
    }

    public static boolean isPermitted(int fromDim, int toDim) {
        if (Journeymap.getClient().isServerEnabled()) {
            ClientFeatures features = ClientFeatures.instance();
            boolean allowed = features.isAllowed(Feature.Action.Teleport, fromDim);
            if (allowed && fromDim != toDim) {
                allowed = features.isAllowed(Feature.Action.Teleport, toDim);
            }
            return allowed;
        }
        return fromDim == toDim && ClientCommandInvoker.commandsAllowed(FMLClientHandler.instance().getClient());
    }

    @Override
    public void run() {
        try {
            EntityPlayerSP player = Journeymap.clientPlayer();
            if (player == null) {
                return;
            }
            int dim = this.targetDimension;
            if (Journeymap.getClient().isServerEnabled()) {
                Vec3d pos = this.waypoint.getCenteredVec(dim);
                player.func_71165_d(String.format("/jtp %s %s %s %s", pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, dim));
            } else if (player.field_71093_bK == dim) {
                BlockPos pos = this.waypoint.getPosition(dim);
                player.func_71165_d(String.format("/tp %s %s %s %s", player.func_70005_c_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            } else {
                ChatLog.announceError(Constants.getString("jm.waypoint.teleport.dim_error"));
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error teleporting: " + LogFormatter.toPartialString(e));
        }
    }
}

