/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import java.util.Objects;
import journeymap.client.data.DataCache;
import journeymap.client.feature.ClientFeatures;
import journeymap.client.model.EntityDTO;
import journeymap.common.api.feature.Feature;

public class MapView {
    public static final MapView NONE = new MapView();
    public final Integer vSlice;
    public final int dimension;
    public final Feature.MapType mapType;
    private final int theHashCode;
    private final String theCacheKey;

    private MapView() {
        this.vSlice = null;
        this.dimension = 0;
        this.mapType = null;
        this.theCacheKey = "NONE";
        this.theHashCode = 0;
    }

    public MapView(Feature.MapType mapType, Integer vSlice, int dimension) {
        this.vSlice = vSlice = mapType != Feature.MapType.Underground ? null : vSlice;
        this.dimension = dimension;
        this.mapType = mapType;
        this.theCacheKey = MapView.toCacheKey(mapType, vSlice, dimension);
        this.theHashCode = this.theCacheKey.hashCode();
    }

    public static MapView from(Feature.MapType mapType, Integer vSlice, int dimension) {
        return DataCache.INSTANCE.getMapView(mapType, vSlice, dimension);
    }

    public static MapView from(Integer vSlice, int dimension) {
        return MapView.from(vSlice == null ? Feature.MapType.Day : Feature.MapType.Underground, vSlice, dimension);
    }

    public static MapView from(Feature.MapType mapType, EntityDTO player) {
        return MapView.from(mapType, player.chunkCoordY, player.dimension);
    }

    public static MapView day(int dimension) {
        return MapView.from(Feature.MapType.Day, null, dimension);
    }

    public static MapView day(EntityDTO player) {
        return MapView.from(Feature.MapType.Day, null, player.dimension);
    }

    public static MapView night(int dimension) {
        return MapView.from(Feature.MapType.Night, null, dimension);
    }

    public static MapView night(EntityDTO player) {
        return MapView.from(Feature.MapType.Night, null, player.dimension);
    }

    public static MapView topo(int dimension) {
        return MapView.from(Feature.MapType.Topo, null, dimension);
    }

    public static MapView topo(EntityDTO player) {
        return MapView.from(Feature.MapType.Topo, null, player.dimension);
    }

    public static MapView underground(EntityDTO player) {
        return MapView.from(Feature.MapType.Underground, player.chunkCoordY, player.dimension);
    }

    public static MapView underground(Integer vSlice, int dimension) {
        return MapView.from(Feature.MapType.Underground, vSlice, dimension);
    }

    public static MapView none() {
        return NONE;
    }

    public static String toCacheKey(Feature.MapType mapType, Integer vSlice, int dimension) {
        String mapTypeName = mapType == null ? "NONE" : mapType.name().toLowerCase();
        return String.format("%s|%s|%s", dimension, mapTypeName, vSlice == null ? "_" : vSlice);
    }

    public String toCacheKey() {
        return this.theCacheKey;
    }

    public String toString() {
        return this.theCacheKey;
    }

    public String name() {
        return this.mapType.name().toLowerCase();
    }

    public boolean isUnderground() {
        return this.mapType == Feature.MapType.Underground;
    }

    public boolean isSurface() {
        return this.isDayOrNight();
    }

    public boolean isDay() {
        return this.mapType == Feature.MapType.Day;
    }

    public boolean isNight() {
        return this.mapType == Feature.MapType.Night;
    }

    public boolean isTopo() {
        return this.mapType == Feature.MapType.Topo;
    }

    public boolean isBiome() {
        return this.mapType == Feature.MapType.Biome;
    }

    public boolean isDayOrNight() {
        return this.isDay() || this.isNight();
    }

    public boolean isNone() {
        return this == NONE;
    }

    public boolean isAllowed() {
        return this.isNone() || ClientFeatures.instance().isAllowed(this.mapType, this.dimension);
    }

    public int hashCode() {
        return this.theHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapView otherView = (MapView)o;
        if (this.dimension != otherView.dimension) {
            return false;
        }
        if (this.mapType != otherView.mapType) {
            return false;
        }
        return Objects.equals(this.vSlice, otherView.vSlice);
    }
}

