/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import journeymap.client.api.display.Waypoint;
import journeymap.client.waypoint.IWaypointLoader;
import journeymap.client.waypoint.WaypointLegacy;
import journeymap.common.Journeymap;

public class WaypointLoaderLegacy
implements IWaypointLoader {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    final File backup55Dir;

    public WaypointLoaderLegacy(File waypointDir) {
        this.backup55Dir = new File(waypointDir, "backup_5.5");
        this.backup55Dir.mkdirs();
    }

    @Override
    public Collection<Waypoint> loadAll() {
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        File[] files = this.backup55Dir.listFiles((dir, name) -> name.endsWith(".json") && !name.equals("waypoint_groups.json"));
        if (files == null || files.length == 0) {
            return waypoints;
        }
        for (File waypointFile : files) {
            Waypoint wp = this.load(waypointFile);
            if (wp == null) continue;
            waypoints.add(wp);
        }
        return waypoints;
    }

    @Override
    public boolean save(Waypoint waypoint) {
        if (waypoint.isPersistent()) {
            File legacyFile = null;
            try {
                WaypointLegacy legacy = WaypointLegacy.toLegacy(waypoint);
                String legacyId = String.format("%s_%s,%s,%s", legacy.name, legacy.x, legacy.y, legacy.z);
                String fileName = legacyId.toLowerCase().replaceAll("[\\\\/:\"*?<>|]", "_").concat(".json");
                legacyFile = new File(this.backup55Dir, fileName);
                Files.write((CharSequence)GSON.toJson((Object)legacy), (File)legacyFile, (Charset)Charset.forName("UTF-8"));
                return true;
            }
            catch (Exception e) {
                Journeymap.getLogger().warn(String.format("Can't write legacy waypoint file to %s: %s", legacyFile, e.getMessage()));
            }
        }
        return false;
    }

    @Override
    public Waypoint load(File waypointFile) {
        String waypointString = null;
        Waypoint waypoint = null;
        try {
            waypointString = Files.toString((File)waypointFile, (Charset)Charset.forName("UTF-8"));
            waypoint = WaypointLegacy.fromString(waypointString).toWaypoint();
        }
        catch (Throwable e) {
            Journeymap.getLogger().error(String.format("Can't load legacy waypoint file %s with contents: %s because %s", waypointFile, waypointString, e.getMessage()));
        }
        if (!waypointFile.getParentFile().equals(this.backup55Dir)) {
            File backupLocation = new File(this.backup55Dir, waypointFile.getName());
            try {
                Files.move((File)waypointFile, (File)backupLocation);
            }
            catch (IOException e) {
                Journeymap.getLogger().warn(String.format("Can't move legacy waypoint file to %s: %s", backupLocation, e.getMessage()));
            }
        }
        return waypoint;
    }
}

