/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.display.WaypointGroup;
import journeymap.client.api.model.MapImage;
import journeymap.client.api.model.MapText;
import journeymap.client.cartography.color.RGB;
import journeymap.client.io.FileHandler;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.waypoint.IWaypointLoader;
import journeymap.client.waypoint.WaypointLoader;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.util.math.BlockPos;

@ParametersAreNonnullByDefault
public enum WaypointStore {
    INSTANCE;

    public static final MapImage DEFAULT_WAYPOINT_ICON;
    public static final MapText DEFAULT_WAYPOINT_LABEL;
    private final Cache<String, Waypoint> cache = CacheBuilder.newBuilder().build();
    private final Set<Integer> dimensions = new HashSet<Integer>();
    private boolean loaded = false;
    private IWaypointLoader waypointLoader;

    public static MapImage getWaypointIcon(Waypoint waypoint) {
        MapImage icon = waypoint.getIcon();
        if (icon == null || icon.getImageLocation() == null) {
            icon = DEFAULT_WAYPOINT_ICON;
        }
        return icon;
    }

    public static MapText getWaypointLabel(Waypoint waypoint) {
        MapText label = waypoint.getLabel();
        return label == null ? DEFAULT_WAYPOINT_LABEL : label;
    }

    public static Waypoint create(int dimension, BlockPos position) {
        int color = RGB.randomColor();
        String name = String.format("%s, %s", position.func_177958_n(), position.func_177952_p());
        return (Waypoint)((Waypoint)new Waypoint("journeymap", name, dimension, position).setIconColor(color)).setLabelColor(RGB.labelSafe(color));
    }

    static String getFileName(Waypoint waypoint) {
        String fileName = waypoint.getGuid().toLowerCase().replaceAll("[\\\\/:\"*?<>|]", "_").concat(".json");
        if (fileName.equals("waypoint_groups.json")) {
            fileName = "bad" + fileName;
            Journeymap.getLogger().error("Waypoint file can't be waypoint_groups.json");
        }
        return fileName;
    }

    private IWaypointLoader getWaypointLoader() {
        if (this.waypointLoader == null) {
            this.waypointLoader = new WaypointLoader(FileHandler.getWaypointDir());
        }
        return this.waypointLoader;
    }

    public void setWaypointLoader(WaypointLoader loader) {
        this.waypointLoader = loader;
    }

    public List<Waypoint> getAll() {
        return new ArrayList<Waypoint>(this.cache.asMap().values());
    }

    public List<Waypoint> getAll(int dimension) {
        return this.cache.asMap().values().stream().filter(wp -> wp.isDisplayed(dimension)).collect(Collectors.toList());
    }

    public List<Waypoint> getAll(WaypointGroup group) {
        return this.cache.asMap().values().stream().filter(waypoint -> Objects.equals(group, waypoint.getGroup())).collect(Collectors.toList());
    }

    public void add(Waypoint waypoint) {
        if (this.cache.getIfPresent((Object)waypoint.getId()) == null) {
            this.cache.put((Object)waypoint.getId(), (Object)waypoint);
        }
    }

    public void save(Waypoint waypoint) {
        this.cache.put((Object)waypoint.getId(), (Object)waypoint);
        boolean saved = this.getWaypointLoader().save(waypoint);
        if (saved) {
            waypoint.setDirty(false);
        }
    }

    public void bulkSave() {
        for (Waypoint waypoint : this.cache.asMap().values()) {
            boolean saved;
            if (!waypoint.isDirty() || !(saved = this.getWaypointLoader().save(waypoint))) continue;
            waypoint.setDirty(false);
        }
    }

    public void remove(Waypoint waypoint) {
        File waypointFile;
        this.cache.invalidate((Object)waypoint.getId());
        if (waypoint.isPersistent() && (waypointFile = new File(FileHandler.getWaypointDir(), WaypointStore.getFileName(waypoint))).exists()) {
            this.remove(waypointFile);
        }
    }

    private void remove(File waypointFile) {
        try {
            waypointFile.delete();
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(String.format("Can't delete waypoint file %s: %s", waypointFile, e.getMessage()));
            waypointFile.deleteOnExit();
        }
    }

    public void reset() {
        this.cache.invalidateAll();
        this.dimensions.clear();
        this.loaded = false;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Cache<String, Waypoint> cache = this.cache;
        synchronized (cache) {
            File waypointDir = FileHandler.getWaypointDir();
            try {
                this.cache.invalidateAll();
                this.waypointLoader = null;
                this.loadCache(this.getWaypointLoader().loadAll());
                Journeymap.getLogger().info(String.format("Loaded %s waypoints from %s", this.cache.size(), waypointDir));
            }
            catch (Exception e) {
                Journeymap.getLogger().error(String.format("Error loading waypoints from %s: %s", waypointDir, LogFormatter.toString(e)));
            }
        }
    }

    protected void loadCache(Collection<Waypoint> waypoints) {
        for (Waypoint waypoint : waypoints) {
            if (waypoint.isPersistent() && waypoint.isDirty()) {
                this.save(waypoint);
            } else {
                this.cache.put((Object)waypoint.getId(), (Object)waypoint);
            }
            this.dimensions.addAll(waypoint.getDisplayDimensions());
        }
        this.loaded = true;
    }

    public boolean hasLoaded() {
        return this.loaded;
    }

    public List<Integer> getLoadedDimensions() {
        return new ArrayList<Integer>(this.dimensions);
    }

    static {
        DEFAULT_WAYPOINT_ICON = new MapImage(TextureCache.Waypoint, 16, 16);
        DEFAULT_WAYPOINT_LABEL = new MapText();
    }
}

