/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.api.util;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.common.api.IJmAPI;
import journeymap.common.api.IJmPlugin;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public abstract class PluginHelper<A, I extends IJmPlugin> {
    public static final Logger LOGGER = LogManager.getLogger((String)"journeymap");
    private final Class<A> pluginAnnotationClass;
    private final Class<I> pluginInterfaceClass;
    protected Map<String, I> plugins = null;
    protected boolean initialized;

    protected PluginHelper(Class<A> pluginAnnotationClass, Class<I> pluginInterfaceClass) {
        this.pluginAnnotationClass = pluginAnnotationClass;
        this.pluginInterfaceClass = pluginInterfaceClass;
    }

    public Map<String, I> preInitPlugins(ASMDataTable asmDataTable) {
        if (this.plugins == null) {
            HashMap<String, IJmPlugin> discovered = new HashMap<String, IJmPlugin>();
            Set asmDataSet = asmDataTable.getAll(this.pluginAnnotationClass.getCanonicalName());
            String pluginAnnotationName = this.pluginAnnotationClass.getCanonicalName();
            String pluginInterfaceName = this.pluginInterfaceClass.getSimpleName();
            for (ASMDataTable.ASMData asmData : asmDataSet) {
                String className = asmData.getClassName();
                try {
                    Class<?> pluginClass = Class.forName(className);
                    if (this.pluginInterfaceClass.isAssignableFrom(pluginClass)) {
                        Class<I> interfaceImplClass = pluginClass.asSubclass(this.pluginInterfaceClass);
                        IJmPlugin instance = (IJmPlugin)interfaceImplClass.newInstance();
                        String modId = instance.getModId();
                        if (Strings.isNullOrEmpty((String)modId)) {
                            throw new Exception("IPlugin.getModId() must return a non-empty, non-null value");
                        }
                        if (discovered.containsKey(modId)) {
                            Class<?> otherPluginClass = ((IJmPlugin)discovered.get(modId)).getClass();
                            throw new Exception(String.format("Multiple plugins trying to use the same modId: %s and %s", interfaceImplClass, otherPluginClass));
                        }
                        discovered.put(modId, instance);
                        LOGGER.info(String.format("Found @%s: %s", pluginAnnotationName, className));
                        continue;
                    }
                    LOGGER.error(String.format("Found @%s: %s, but it doesn't implement %s", pluginAnnotationName, className, pluginInterfaceName));
                }
                catch (Exception e) {
                    LOGGER.error(String.format("Found @%s: %s, but failed to instantiate it: %s", pluginAnnotationName, className, e.getMessage()), (Throwable)e);
                }
            }
            if (discovered.isEmpty()) {
                LOGGER.info("No plugins for JourneyMap API discovered.");
            }
            this.plugins = Collections.unmodifiableMap(discovered);
        }
        return this.plugins;
    }

    public Map<String, I> initPlugins(IJmAPI jmApi) {
        if (this.plugins == null) {
            LOGGER.warn("Plugin discovery never occurred.", (Throwable)new IllegalStateException());
        } else if (!this.initialized) {
            LOGGER.info(String.format("Initializing plugins with %s", jmApi.getClass().getName()));
            HashMap<String, I> discovered = new HashMap<String, I>(this.plugins);
            Iterator<I> iter = discovered.values().iterator();
            while (iter.hasNext()) {
                IJmPlugin plugin = (IJmPlugin)iter.next();
                try {
                    plugin.initialize(jmApi);
                    LOGGER.info(String.format("Initialized %s: %s", this.pluginInterfaceClass.getSimpleName(), plugin.getClass().getName()));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to initialize I: " + plugin.getClass().getName(), (Throwable)e);
                    iter.remove();
                }
            }
            this.plugins = Collections.unmodifiableMap(discovered);
            this.initialized = true;
        } else {
            LOGGER.info("Plugins already initialized.");
        }
        return this.plugins;
    }

    public Map<String, I> getPlugins() {
        return this.plugins;
    }
}

