/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import journeymap.common.Journeymap;
import journeymap.common.feature.DimensionPolicies;
import journeymap.common.network.DimensionPoliciesPacket;
import journeymap.common.network.TeleportPacket;
import journeymap.common.network.WorldIDPacket;
import journeymap.common.network.model.Location;
import journeymap.server.nbt.WorldNbtIDSaveHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHandler {
    public static final SimpleNetworkWrapper WORLD_INFO_CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("world_info");
    public static final SimpleNetworkWrapper DIMENSION_POLICIES_CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("jm_dim_policy");
    public static final SimpleNetworkWrapper TELEPORT_CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("jtp");

    public static void init(Side side) {
        WORLD_INFO_CHANNEL.registerMessage(WorldIDPacket.WorldIdListener.class, WorldIDPacket.class, 0, side);
        TELEPORT_CHANNEL.registerMessage(TeleportPacket.Listener.class, TeleportPacket.class, 0, Side.SERVER);
        if (Side.SERVER == side) {
            // empty if block
        }
        if (Side.CLIENT == side) {
            DIMENSION_POLICIES_CHANNEL.registerMessage(DimensionPoliciesPacket.Listener.class, DimensionPoliciesPacket.class, 0, side);
        }
    }

    public static void teleportPlayer(Location location) {
        TELEPORT_CHANNEL.sendToServer((IMessage)new TeleportPacket(location));
    }

    public static void sendDimensionPolicyPacketToPlayer(EntityPlayerMP player, DimensionPolicies dimPolicies, boolean compact) {
        if (player != null) {
            DIMENSION_POLICIES_CHANNEL.sendTo((IMessage)new DimensionPoliciesPacket(dimPolicies, compact), player);
        }
    }

    public static void sendAllPlayersWorldID(String worldID) {
        WORLD_INFO_CHANNEL.sendToAll((IMessage)new WorldIDPacket(worldID));
    }

    public static void sendPlayerWorldID(EntityPlayerMP player) {
        if (player instanceof EntityPlayerMP && player != null) {
            WorldNbtIDSaveHandler worldSaveHandler = new WorldNbtIDSaveHandler();
            String worldID = worldSaveHandler.getWorldID();
            String playerName = player.func_70005_c_();
            try {
                WORLD_INFO_CHANNEL.sendTo((IMessage)new WorldIDPacket(worldID), player);
            }
            catch (RuntimeException rte) {
                Journeymap.getLogger().error(playerName + " is not a real player. WorldID:" + worldID + " Error: " + rte);
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Unknown Exception - PlayerName:" + playerName + " WorldID:" + worldID + " Exception " + e);
            }
        }
    }
}

