/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server;

import java.util.Map;
import java.util.UUID;
import journeymap.common.CommonProxy;
import journeymap.common.Journeymap;
import journeymap.common.command.CommandJTP;
import journeymap.common.migrate.Migration;
import journeymap.common.network.PacketHandler;
import journeymap.common.version.Version;
import journeymap.server.api.impl.ServerAPI;
import journeymap.server.api.util.ServerPluginHelper;
import journeymap.server.events.ForgeEvents;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

public class JourneymapServer
implements CommonProxy {
    private Logger logger = Journeymap.getLogger();
    public static boolean DEV_MODE = false;
    private static final Version MINIMUM_ACCEPTABLE_VERSION = Journeymap.JM_VERSION;

    @Override
    @SideOnly(value=Side.SERVER)
    @Mod.EventHandler
    public void preInitialize(FMLPreInitializationEvent event) {
        JourneymapServer.preInitialize(event.getAsmData());
    }

    public static void preInitialize(ASMDataTable asmDataTable) {
        try {
            PropertiesManager.getInstance();
            ServerPluginHelper.instance().preInitPlugins(asmDataTable);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void initialize(FMLInitializationEvent event) {
        JourneymapServer.initialize();
    }

    public static void initialize() {
        MinecraftForge.EVENT_BUS.register((Object)ForgeEvents.INSTANCE);
        PacketHandler.init(Side.SERVER);
        boolean migrationOk = new Migration("journeymap.server.task.migrate").performTasks();
        PropertiesManager.getInstance();
        ServerPluginHelper.instance().initPlugins(ServerAPI.INSTANCE);
    }

    @Override
    @SideOnly(value=Side.SERVER)
    public void postInitialize(FMLPostInitializationEvent event) {
    }

    @Override
    public void serverStartingEvent(FMLServerStartingEvent event) throws Throwable {
        event.registerServerCommand((ICommand)new CommandJTP());
    }

    @Override
    public boolean checkModLists(Map<String, String> modList, Side side) {
        for (String s : modList.keySet()) {
            if (!s.toLowerCase().startsWith("journeymap")) continue;
            if (modList.get(s).contains("@")) {
                this.logger.info("Mod check = dev environment");
                DEV_MODE = true;
                return true;
            }
            String version = modList.get(s).split("-")[1];
            Version userLoggedInVersion = Version.from(version, null);
            if (MINIMUM_ACCEPTABLE_VERSION.isNewerThan(userLoggedInVersion)) {
                this.logger.info("Version Mismatch need " + MINIMUM_ACCEPTABLE_VERSION.toString() + " or higher. Current version attempt -> " + modList.get(s));
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean isUpdateCheckEnabled() {
        return false;
    }

    @Override
    public void handleWorldIdMessage(String message, EntityPlayerMP playerEntity) {
        boolean isOp = JourneymapServer.isOp(playerEntity.func_110124_au());
        if (PropertiesManager.getInstance().getGlobalProperties((boolean)isOp).useWorldId.get().booleanValue()) {
            PacketHandler.sendPlayerWorldID(playerEntity);
        }
    }

    public static boolean isOp(UUID playerID) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server.func_71262_S()) {
            PlayerList playerList = server.func_184103_al();
            EntityPlayerMP player = playerList.func_177451_a(playerID);
            return player != null && playerList.func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null;
        }
        return false;
    }
}

