/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.properties;

import journeymap.common.feature.PolicyTable;
import journeymap.common.properties.PropertiesBase;
import journeymap.server.properties.ServerPropertiesBase;

public abstract class PermissionProperties
extends ServerPropertiesBase {
    final transient boolean isOp;
    public final PolicyTable policies;

    protected PermissionProperties(String displayName, String description, boolean isOp) {
        super(displayName, description);
        this.isOp = isOp;
        this.policies = new PolicyTable();
    }

    public boolean isOp() {
        return this.isOp;
    }

    @Override
    public <T extends PropertiesBase> void updateFrom(T otherInstance) {
        PolicyTable otherTable;
        super.updateFrom(otherInstance);
        if (otherInstance instanceof PermissionProperties && (otherTable = ((PermissionProperties)otherInstance).policies) != null) {
            this.policies.update(otherTable);
        }
    }

    public void copyFrom(PermissionProperties other) {
        PolicyTable otherTable = other.policies;
        if (otherTable != null) {
            otherTable.inflate();
            this.policies.update(otherTable);
        }
    }

    @Override
    protected void postLoad(boolean isNew) {
        super.postLoad(isNew);
        this.policies.inflate();
    }

    public abstract String getOriginKey();
}

