/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.asm;

import com.pg85.otg.forge.asm.OTGHooks;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import scala.tools.asm.Type;

public class OTGClassTransformer
implements IClassTransformer {
    static String[] classesBeingTransformed = new String[]{"net.minecraftforge.registries.GameData", "net.minecraft.world.biome.Biome", "net.minecraft.entity.EntityLivingBase", "net.minecraft.entity.item.EntityMinecart", "net.minecraft.entity.projectile.EntityArrow", "net.minecraft.entity.item.EntityBoat", "net.minecraft.entity.item.EntityFallingBlock", "net.minecraft.entity.item.EntityItem", "net.minecraft.entity.projectile.EntityLlamaSpit", "net.minecraft.entity.projectile.EntityShulkerBullet", "net.minecraft.entity.projectile.EntityThrowable", "net.minecraft.entity.item.EntityTntPrimed", "net.minecraft.entity.item.EntityXPOrb", "net.minecraft.entity.Entity"};

    public byte[] transform(String name, String transformedName, byte[] classBeingTransformed) {
        if (name != null && transformedName != null) {
            boolean isObfuscated = !name.equals(transformedName);
            int index = -1;
            for (int i = 0; i < classesBeingTransformed.length; ++i) {
                if (!classesBeingTransformed[i].equals(transformedName)) continue;
                index = i;
                break;
            }
            return index != -1 ? this.transform(index, classBeingTransformed, isObfuscated) : classBeingTransformed;
        }
        return classBeingTransformed;
    }

    public byte[] transform(int index, byte[] classBeingTransformed, boolean isObfuscated) {
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(classBeingTransformed);
            classReader.accept((ClassVisitor)classNode, 0);
            switch (index) {
                case 0: {
                    this.transformInjectSnapshot(classNode, isObfuscated);
                    break;
                }
                case 1: {
                    this.transformGetIdForBiome(classNode, isObfuscated);
                    break;
                }
                case 2: {
                    this.transformTravel(classNode, isObfuscated);
                    break;
                }
                case 3: {
                    this.transformOnUpdateMineCart(classNode, isObfuscated);
                    break;
                }
                case 4: {
                    this.transformOnUpdateArrow(classNode, isObfuscated);
                    break;
                }
                case 5: {
                    this.transformOnUpdateBoat(classNode, isObfuscated);
                    break;
                }
                case 6: {
                    this.transformOnUpdateFallingBlock(classNode, isObfuscated);
                    break;
                }
                case 7: {
                    this.transformOnUpdateItem(classNode, isObfuscated);
                    break;
                }
                case 8: {
                    this.transformOnUpdateLlamaSpit(classNode, isObfuscated);
                    break;
                }
                case 9: {
                    this.transformOnUpdateShulkerBullet(classNode, isObfuscated);
                    break;
                }
                case 10: {
                    this.transformOnUpdateThrowable(classNode, isObfuscated);
                    break;
                }
                case 11: {
                    this.transformOnUpdateTntPrimed(classNode, isObfuscated);
                    break;
                }
                case 12: {
                    this.transformOnUpdateXPOrb(classNode, isObfuscated);
                    break;
                }
                case 13: {
                    this.transformUpdateFallState(classNode, isObfuscated);
                    break;
                }
                case 14: {
                    this.transformInitDimension(classNode, isObfuscated);
                    break;
                }
                case 15: {
                    this.transformLoadAllWorldsMinecraftServer(classNode, isObfuscated);
                    break;
                }
                case 16: {
                    this.transformLoadAllWorldsIntegratedServer(classNode, isObfuscated);
                }
            }
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return classBeingTransformed;
        }
    }

    private void transformGetIdForBiome(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "a" : "getIdForBiome";
        String injectSnapShotDescriptor = isObfuscated ? "(Lanh;)I" : "(Lnet/minecraft/world/biome/Biome;)I";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode targetNode = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (!(instruction instanceof FieldInsnNode)) continue;
                targetNode = instruction;
                break;
            }
            if (targetNode == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new TypeInsnNode(193, "com/pg85/otg/forge/asm/IOTGASMBiome"));
            LabelNode l1 = new LabelNode();
            toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l1));
            LabelNode l2 = new LabelNode();
            toInsert.add((AbstractInsnNode)l2);
            toInsert.add((AbstractInsnNode)new LineNumberNode(113, l2));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getIDForObject", injectSnapShotDescriptor, false));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            toInsert.add((AbstractInsnNode)l1);
            toInsert.add((AbstractInsnNode)new LineNumberNode(115, l1));
            toInsert.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
            method.instructions.insertBefore(targetNode, toInsert);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformInjectSnapshot(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "injectSnapshot" : "injectSnapshot";
        String injectSnapShotDescriptor = isObfuscated ? "(Ljava/util/Map;ZZ)Lcom/google/common/collect/Multimap;" : "(Ljava/util/Map;ZZ)Lcom/google/common/collect/Multimap;";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode targetNode = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                AbstractInsnNode instruction7;
                AbstractInsnNode instruction6;
                AbstractInsnNode instruction5;
                AbstractInsnNode instruction4;
                AbstractInsnNode instruction3;
                AbstractInsnNode instruction2;
                if (instruction.getOpcode() != 25 || !((instruction2 = instruction.getNext()) instanceof MethodInsnNode) || !((MethodInsnNode)instruction2).desc.equals("()Ljava/util/Collection;") || !((instruction3 = instruction2.getNext()) instanceof MethodInsnNode) || !((MethodInsnNode)instruction3).desc.equals("()Ljava/util/stream/Stream;") || !((instruction4 = instruction3.getNext()) instanceof InvokeDynamicInsnNode) || !((InvokeDynamicInsnNode)instruction4).desc.equals("()Ljava/util/function/ToIntFunction;") || !((instruction5 = instruction4.getNext()) instanceof MethodInsnNode) || !((MethodInsnNode)instruction5).desc.equals("(Ljava/util/function/ToIntFunction;)Ljava/util/stream/IntStream;") || !((instruction6 = instruction5.getNext()) instanceof MethodInsnNode) || !((MethodInsnNode)instruction6).desc.equals("()I") || (instruction7 = instruction6.getNext()).getOpcode() != 54) continue;
                targetNode = instruction;
                break;
            }
            if (targetNode == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            AbstractInsnNode removeNode = targetNode.getNext();
            for (int i = 0; i < 5; ++i) {
                removeNode = removeNode.getNext();
                method.instructions.remove(removeNode.getPrevious());
            }
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "countMissingRegistryEntries", "(Ljava/util/LinkedHashMap;)I", false));
            method.instructions.insertBefore(removeNode, toInsert);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformTravel(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "a" : "travel";
        String injectSnapShotDescriptor = isObfuscated ? "(FFF)V" : "(FFF)V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != 0.08) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getGravityFactor", "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            method.instructions.remove(instructionToRemove);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformOnUpdateMineCart(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.04f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getGravityFactorMineCart", "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            method.instructions.remove(instructionToRemove);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformOnUpdateArrow(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.05f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getGravityFactorArrow", "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            method.instructions.remove(instructionToRemove);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformOnUpdateBoat(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "x" : "updateMotion";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)-0.04f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getGravityFactorBoat", "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            method.instructions.remove(instructionToRemove);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformOnUpdateFallingBlock(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.04f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getGravityFactorFallingBlock", "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            method.instructions.remove(instructionToRemove);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformOnUpdateItem(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.04f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getGravityFactorItem", "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            method.instructions.remove(instructionToRemove);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformOnUpdateLlamaSpit(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.06f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getGravityFactorLlamaSpit", "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            method.instructions.remove(instructionToRemove);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformOnUpdateShulkerBullet(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != 0.04) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getGravityFactorShulkerBullet", "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            method.instructions.remove(instructionToRemove);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformOnUpdateThrowable(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "j" : "getGravityVelocity";
        String injectSnapShotDescriptor = isObfuscated ? "()F" : "()F";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Float) || ((Float)((LdcInsnNode)instruction).cst).floatValue() != 0.03f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getGravityFactorThrowable", "(Lnet/minecraft/entity/Entity;)F", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            method.instructions.remove(instructionToRemove);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformOnUpdateTntPrimed(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.04f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getGravityFactorTNTPrimed", "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            method.instructions.remove(instructionToRemove);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformOnUpdateXPOrb(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.03f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getGravityFactorXPOrb", "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            method.instructions.remove(instructionToRemove);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformUpdateFallState(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "a" : "updateFallState";
        String injectSnapShotDescriptor = isObfuscated ? "(DZLawt;Let;)V" : "(DZLnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;)V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            boolean bFound = false;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 24) continue;
                if (bFound) {
                    InsnList toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(OTGHooks.class), "getFallDamageFactor", "(DLnet/minecraft/entity/Entity;)D", false));
                    method.instructions.insertBefore(instruction.getNext(), toInsert);
                    return;
                }
                bFound = true;
            }
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformInitDimension(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "initDimension" : "initDimension";
        String injectSnapShotDescriptor = isObfuscated ? "(I)V" : "(I)V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            boolean bFound1 = false;
            boolean bFound2 = false;
            boolean bFound3 = false;
            boolean bFound4 = false;
            boolean bFound6 = false;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() == 192 && ((TypeInsnNode)instruction).desc.equals("net/minecraft/world/WorldServer")) {
                    ((TypeInsnNode)instruction).desc = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound1 = true;
                    continue;
                }
                if (instruction.getOpcode() == 187 && ((TypeInsnNode)instruction).desc.equals("net/minecraft/world/WorldServer")) {
                    ((TypeInsnNode)instruction).desc = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound2 = true;
                    continue;
                }
                if (instruction.getOpcode() == 187 && ((TypeInsnNode)instruction).desc.equals("net/minecraft/world/WorldServerMulti")) {
                    ((TypeInsnNode)instruction).desc = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound3 = true;
                    continue;
                }
                if (instruction.getOpcode() == 183 && ((MethodInsnNode)instruction).owner.equals("net/minecraft/world/WorldServer")) {
                    ((MethodInsnNode)instruction).owner = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound4 = true;
                    continue;
                }
                if (instruction.getOpcode() == 183 && ((MethodInsnNode)instruction).owner.equals("net/minecraft/world/WorldServerMulti")) {
                    ((MethodInsnNode)instruction).owner = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound4 = true;
                    continue;
                }
                if (instruction.getOpcode() == 182 && ((MethodInsnNode)instruction).owner.equals("net/minecraft/world/WorldServer") || instruction.getOpcode() != 182 || !((MethodInsnNode)instruction).owner.equals("net/minecraft/world/WorldServerMulti")) continue;
                ((MethodInsnNode)instruction).owner = "com/pg85/otg/forge/OTGWorldServerMulti";
                bFound6 = true;
            }
            if (!(bFound1 && bFound2 && bFound3 && bFound4 && bFound6)) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformLoadAllWorldsMinecraftServer(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "loadAllWorlds" : "loadAllWorlds";
        String injectSnapShotDescriptor = isObfuscated ? "(Ljava/lang/String;Ljava/lang/String;JLnet/minecraft/world/WorldType;Ljava/lang/String;)V" : "(Ljava/lang/String;Ljava/lang/String;JLnet/minecraft/world/WorldType;Ljava/lang/String;)V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            boolean bFound1 = false;
            boolean bFound2 = false;
            boolean bFound3 = false;
            boolean bFound4 = false;
            boolean bFound5 = false;
            boolean bFound6 = false;
            boolean bFound7 = false;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() == 192 && ((TypeInsnNode)instruction).desc.equals("net/minecraft/world/WorldServer")) {
                    ((TypeInsnNode)instruction).desc = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound1 = true;
                    continue;
                }
                if (instruction.getOpcode() == 187 && ((TypeInsnNode)instruction).desc.equals("net/minecraft/world/WorldServer")) {
                    ((TypeInsnNode)instruction).desc = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound2 = true;
                    continue;
                }
                if (instruction.getOpcode() == 187 && ((TypeInsnNode)instruction).desc.equals("net/minecraft/world/WorldServerMulti")) {
                    ((TypeInsnNode)instruction).desc = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound3 = true;
                    continue;
                }
                if (instruction.getOpcode() == 183 && ((MethodInsnNode)instruction).owner.equals("net/minecraft/world/WorldServer")) {
                    ((MethodInsnNode)instruction).owner = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound4 = true;
                    continue;
                }
                if (instruction.getOpcode() == 183 && ((MethodInsnNode)instruction).owner.equals("net/minecraft/world/WorldServerMulti")) {
                    ((MethodInsnNode)instruction).owner = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound5 = true;
                    continue;
                }
                if (instruction.getOpcode() == 182 && ((MethodInsnNode)instruction).owner.equals("net/minecraft/world/WorldServer")) {
                    ((MethodInsnNode)instruction).owner = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound6 = true;
                    continue;
                }
                if (instruction.getOpcode() != 182 || !((MethodInsnNode)instruction).owner.equals("net/minecraft/world/WorldServerMulti")) continue;
                ((MethodInsnNode)instruction).owner = "com/pg85/otg/forge/OTGWorldServerMulti";
                bFound7 = true;
                break;
            }
            if (!(bFound1 && bFound2 && bFound3 && bFound4 && bFound5 && bFound6 && bFound7)) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformLoadAllWorldsIntegratedServer(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "loadAllWorlds" : "loadAllWorlds";
        String injectSnapShotDescriptor = isObfuscated ? "(Ljava/lang/String;Ljava/lang/String;JLnet/minecraft/world/WorldType;Ljava/lang/String;)V" : "(Ljava/lang/String;Ljava/lang/String;JLnet/minecraft/world/WorldType;Ljava/lang/String;)V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            boolean bFound1 = false;
            boolean bFound2 = false;
            boolean bFound3 = false;
            boolean bFound4 = false;
            boolean bFound5 = false;
            boolean bFound6 = false;
            boolean bFound7 = false;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() == 192 && ((TypeInsnNode)instruction).desc.equals("net/minecraft/world/WorldServer")) {
                    ((TypeInsnNode)instruction).desc = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound1 = true;
                    continue;
                }
                if (instruction.getOpcode() == 187 && ((TypeInsnNode)instruction).desc.equals("net/minecraft/world/WorldServer")) {
                    ((TypeInsnNode)instruction).desc = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound2 = true;
                    continue;
                }
                if (instruction.getOpcode() == 187 && ((TypeInsnNode)instruction).desc.equals("net/minecraft/world/WorldServerMulti")) {
                    ((TypeInsnNode)instruction).desc = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound3 = true;
                    continue;
                }
                if (instruction.getOpcode() == 183 && ((MethodInsnNode)instruction).owner.equals("net/minecraft/world/WorldServer")) {
                    ((MethodInsnNode)instruction).owner = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound4 = true;
                    continue;
                }
                if (instruction.getOpcode() == 183 && ((MethodInsnNode)instruction).owner.equals("net/minecraft/world/WorldServerMulti")) {
                    ((MethodInsnNode)instruction).owner = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound5 = true;
                    continue;
                }
                if (instruction.getOpcode() == 182 && ((MethodInsnNode)instruction).owner.equals("net/minecraft/world/WorldServer")) {
                    ((MethodInsnNode)instruction).owner = "com/pg85/otg/forge/OTGWorldServerMulti";
                    bFound6 = true;
                    continue;
                }
                if (instruction.getOpcode() != 182 || !((MethodInsnNode)instruction).owner.equals("net/minecraft/world/WorldServerMulti")) continue;
                ((MethodInsnNode)instruction).owner = "com/pg85/otg/forge/OTGWorldServerMulti";
                bFound7 = true;
                break;
            }
            if (!(bFound1 && bFound2 && bFound3 && bFound4 && bFound5 && bFound6 && bFound7)) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }
}

