/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.api.core.BCLog;
import buildcraft.core.BCRegistry;
import buildcraft.core.CompatHooks;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.builders.schematics.SchematicFree;
import buildcraft.core.config.ConfigManager;
import buildcraft.core.lib.network.base.ChannelHandler;
import buildcraft.core.lib.network.base.PacketHandler;
import buildcraft.factory.BlockAutoWorkbench;
import buildcraft.factory.BlockChute;
import buildcraft.factory.BlockFloodGate;
import buildcraft.factory.BlockMiningWell;
import buildcraft.factory.BlockPlainPipe;
import buildcraft.factory.BlockPump;
import buildcraft.factory.BlockRefinery;
import buildcraft.factory.BlockTank;
import buildcraft.factory.FactoryGuiHandler;
import buildcraft.factory.FactoryProxy;
import buildcraft.factory.FactoryProxyClient;
import buildcraft.factory.PumpDimensionList;
import buildcraft.factory.TileAutoWorkbench;
import buildcraft.factory.TileChute;
import buildcraft.factory.TileFloodGate;
import buildcraft.factory.TileMiningWell;
import buildcraft.factory.TilePump;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.TileTank;
import buildcraft.factory.render.ChuteRenderModel;
import buildcraft.factory.schematics.SchematicAutoWorkbench;
import buildcraft.factory.schematics.SchematicPump;
import buildcraft.factory.schematics.SchematicRefinery;
import buildcraft.factory.schematics.SchematicTileIgnoreState;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.RegistrySimple;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(name="BuildCraft Factory", version="7.2.0-pre6", useMetadata=false, modid="BuildCraft|Factory", dependencies="required-after:BuildCraft|Core@7.2.0-pre6", acceptedMinecraftVersions="[1.8.9]")
public class BuildCraftFactory
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Factory")
    public static BuildCraftFactory instance;
    public static BlockMiningWell miningWellBlock;
    public static BlockAutoWorkbench autoWorkbenchBlock;
    public static BlockPlainPipe plainPipeBlock;
    public static BlockPump pumpBlock;
    public static BlockFloodGate floodGateBlock;
    public static BlockTank tankBlock;
    public static BlockRefinery refineryBlock;
    public static BlockChute chuteBlock;
    public static Achievement aLotOfCraftingAchievement;
    public static Achievement straightDownAchievement;
    public static Achievement refineAndRedefineAchievement;
    public static int miningDepth;
    public static boolean pumpsNeedRealPower;
    public static PumpDimensionList pumpDimensionList;

    @Mod.EventHandler
    public void fmlPreInit(FMLPreInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-FACTORY", new io.netty.channel.ChannelHandler[]{new ChannelHandler(), new PacketHandler()});
        String plc = "Allows admins to whitelist or blacklist pumping of specific fluids in specific dimensions.\nEg. \"-/-1/Lava\" will disable lava in the nether. \"-/*/Lava\" will disable lava in any dimension. \"+/0/*\" will enable any fluid in the overworld.\nEntries are comma seperated, banned fluids have precedence over allowed ones.Default is \"+/*/*,+/-1/Lava\" - the second redundant entry (\"+/-1/lava\") is there to show the format.";
        BuildCraftCore.mainConfigManager.register("general.miningDepth", 256, "Should the mining well only be usable once after placing?", ConfigManager.RestartRequirement.NONE);
        BuildCraftCore.mainConfigManager.get("general.miningDepth").setMinValue(2).setMaxValue(256);
        BuildCraftCore.mainConfigManager.register("general.pumpDimensionControl", DefaultProps.PUMP_DIMENSION_LIST, plc, ConfigManager.RestartRequirement.NONE);
        BuildCraftCore.mainConfigManager.register("general.pumpsNeedRealPower", false, "Do pumps need real (non-redstone) power?", ConfigManager.RestartRequirement.WORLD);
        this.reloadConfig(ConfigManager.RestartRequirement.GAME);
        miningWellBlock = (BlockMiningWell)CompatHooks.INSTANCE.getBlock(BlockMiningWell.class);
        if (BCRegistry.INSTANCE.registerBlock(miningWellBlock.func_149663_c("miningWellBlock"), false)) {
            plainPipeBlock = new BlockPlainPipe();
            BCRegistry.INSTANCE.registerBlock(plainPipeBlock.func_149663_c("plainPipeBlock"), true);
        }
        autoWorkbenchBlock = (BlockAutoWorkbench)CompatHooks.INSTANCE.getBlock(BlockAutoWorkbench.class);
        BCRegistry.INSTANCE.registerBlock(autoWorkbenchBlock.func_149663_c("autoWorkbenchBlock"), false);
        tankBlock = (BlockTank)CompatHooks.INSTANCE.getBlock(BlockTank.class);
        BCRegistry.INSTANCE.registerBlock(tankBlock.func_149663_c("tankBlock"), false);
        pumpBlock = (BlockPump)CompatHooks.INSTANCE.getBlock(BlockPump.class);
        BCRegistry.INSTANCE.registerBlock(pumpBlock.func_149663_c("pumpBlock"), false);
        floodGateBlock = (BlockFloodGate)CompatHooks.INSTANCE.getBlock(BlockFloodGate.class);
        BCRegistry.INSTANCE.registerBlock(floodGateBlock.func_149663_c("floodGateBlock"), false);
        refineryBlock = (BlockRefinery)CompatHooks.INSTANCE.getBlock(BlockRefinery.class);
        BCRegistry.INSTANCE.registerBlock(refineryBlock.func_149663_c("refineryBlock"), false);
        chuteBlock = (BlockChute)CompatHooks.INSTANCE.getBlock(BlockChute.class);
        BCRegistry.INSTANCE.registerBlock(chuteBlock.func_149663_c("blockChute"), false);
        FactoryProxy.proxy.initializeEntityRenders();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void loadRecipes() {
        if (miningWellBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)miningWellBlock, 1), "ipi", "igi", "iPi", Character.valueOf('p'), "dustRedstone", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), "gearIron", Character.valueOf('P'), Items.field_151035_b);
        }
        if (pumpBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)pumpBlock), "ipi", "igi", "TBT", Character.valueOf('p'), "dustRedstone", Character.valueOf('i'), "ingotIron", Character.valueOf('T'), tankBlock, Character.valueOf('g'), "gearIron", Character.valueOf('B'), Items.field_151133_ar);
        }
        if (autoWorkbenchBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)autoWorkbenchBlock), "gwg", Character.valueOf('w'), "craftingTableWood", Character.valueOf('g'), "gearStone");
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)autoWorkbenchBlock), "g", "w", "g", Character.valueOf('w'), "craftingTableWood", Character.valueOf('g'), "gearStone");
        }
        if (tankBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)tankBlock), "ggg", "g g", "ggg", Character.valueOf('g'), "blockGlass");
        }
        if (refineryBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)refineryBlock), "RTR", "TGT", Character.valueOf('T'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('G'), "gearDiamond", Character.valueOf('R'), Blocks.field_150429_aA);
        }
        if (chuteBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)chuteBlock), "ICI", " G ", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "chestWood", Character.valueOf('G'), "gearStone");
            BCRegistry.INSTANCE.addShapelessRecipe(new ItemStack((Block)chuteBlock), Blocks.field_150438_bZ, "gearStone");
        }
        if (floodGateBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)floodGateBlock), "IGI", "FTF", "IFI", Character.valueOf('I'), "ingotIron", Character.valueOf('T'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('G'), "gearIron", Character.valueOf('F'), new ItemStack(Blocks.field_150411_aY));
        }
    }

    @Mod.EventHandler
    public void fmlInit(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new FactoryGuiHandler());
        BCRegistry.INSTANCE.registerTileEntity(TileMiningWell.class, "buildcraft.factory.MiningWell", "MiningWell");
        BCRegistry.INSTANCE.registerTileEntity(TileAutoWorkbench.class, "buildcraft.factory.AutoWorkbench", "AutoWorkbench");
        BCRegistry.INSTANCE.registerTileEntity(TilePump.class, "buildcraft.factory.Pump", "net.minecraft.src.buildcraft.factory.TilePump");
        BCRegistry.INSTANCE.registerTileEntity(TileFloodGate.class, "buildcraft.factory.FloodGate", "net.minecraft.src.buildcraft.factory.TileFloodGate");
        BCRegistry.INSTANCE.registerTileEntity(TileTank.class, "buildcraft.factory.Tank", "net.minecraft.src.buildcraft.factory.TileTank");
        BCRegistry.INSTANCE.registerTileEntity(TileRefinery.class, "buildcraft.factory.Refinery", "net.minecraft.src.buildcraft.factory.Refinery");
        BCRegistry.INSTANCE.registerTileEntity(TileChute.class, "buildcraft.factory.Chute", "net.minecraft.src.buildcraft.factory.TileHopper");
        FactoryProxy.proxy.fmlInit();
        BuilderAPI.schematicRegistry.registerSchematicBlock(refineryBlock, SchematicRefinery.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(tankBlock, SchematicTileIgnoreState.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(pumpBlock, SchematicPump.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(floodGateBlock, SchematicTileIgnoreState.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(autoWorkbenchBlock, SchematicAutoWorkbench.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(chuteBlock, SchematicTile.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(plainPipeBlock, SchematicFree.class, new Object[0]);
        aLotOfCraftingAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("achievement.aLotOfCrafting", "aLotOfCraftingAchievement", 1, 2, (Block)autoWorkbenchBlock, BuildCraftCore.woodenGearAchievement));
        straightDownAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("achievement.straightDown", "straightDownAchievement", 5, 2, (Block)miningWellBlock, BuildCraftCore.ironGearAchievement));
        refineAndRedefineAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("achievement.refineAndRedefine", "refineAndRedefineAchievement", 10, 0, (Block)refineryBlock, BuildCraftCore.diamondGearAchievement));
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftFactory.loadRecipes();
        }
    }

    public void reloadConfig(ConfigManager.RestartRequirement restartType) {
        if (restartType == ConfigManager.RestartRequirement.GAME) {
            this.reloadConfig(ConfigManager.RestartRequirement.WORLD);
        } else if (restartType == ConfigManager.RestartRequirement.WORLD) {
            this.reloadConfig(ConfigManager.RestartRequirement.NONE);
        } else {
            miningDepth = BuildCraftCore.mainConfigManager.get("general.miningDepth").getInt();
            pumpsNeedRealPower = BuildCraftCore.mainConfigManager.get("general.pumpsNeedRealPower").getBoolean();
            pumpDimensionList = new PumpDimensionList(BuildCraftCore.mainConfigManager.get("general.pumpDimensionControl").getString());
            if (BuildCraftCore.mainConfiguration.hasChanged()) {
                BuildCraftCore.mainConfiguration.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("BuildCraft|Core".equals(event.modID)) {
            this.reloadConfig(event.isWorldRunning ? ConfigManager.RestartRequirement.NONE : ConfigManager.RestartRequirement.WORLD);
        }
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileAutoWorkbench.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileFloodGate.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileTank.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileRefinery.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileChute.class.getCanonicalName());
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (mapping.name.equalsIgnoreCase("BuildCraft|Factory:machineBlock") || mapping.name.equalsIgnoreCase("BuildCraft|Factory:quarryBlock")) {
                if (Loader.isModLoaded((String)"BuildCraft|Builders")) {
                    if (mapping.type == GameRegistry.Type.BLOCK) {
                        mapping.remap(Block.func_149684_b((String)"BuildCraft|Builders:quarryBlock"));
                        continue;
                    }
                    if (mapping.type != GameRegistry.Type.ITEM) continue;
                    mapping.remap(Item.func_150898_a((Block)Block.func_149684_b((String)"BuildCraft|Builders:quarryBlock")));
                    continue;
                }
                mapping.warn();
                continue;
            }
            if (mapping.name.equalsIgnoreCase("BuildCraft|Factory:frameBlock")) {
                if (Loader.isModLoaded((String)"BuildCraft|Builders")) {
                    if (mapping.type == GameRegistry.Type.BLOCK) {
                        mapping.remap(Block.func_149684_b((String)"BuildCraft|Builders:frameBlock"));
                        continue;
                    }
                    if (mapping.type != GameRegistry.Type.ITEM) continue;
                    mapping.remap(Item.func_150898_a((Block)Block.func_149684_b((String)"BuildCraft|Builders:frameBlock")));
                    continue;
                }
                mapping.ignore();
                continue;
            }
            if (!mapping.name.equalsIgnoreCase("BuildCraft|Factory:hopperBlock")) continue;
            mapping.remap(Block.func_149684_b((String)"BuildCraft|Factory:chuteBlock"));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre evt) {
        TextureMap terrainTextures = evt.map;
        FactoryProxyClient.pumpTexture = terrainTextures.func_174942_a(new ResourceLocation("buildcraftfactory:blocks/pump/tube"));
        ChuteRenderModel.sideTexture = terrainTextures.func_174942_a(new ResourceLocation("buildcraftfactory:blocks/chute/side"));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelBakeEvent event) {
        ModelResourceLocation mrl = new ModelResourceLocation("buildcraftfactory:chuteBlock");
        for (ModelResourceLocation entry : ((RegistrySimple)event.modelRegistry).func_148742_b()) {
            String str = entry.toString();
            if (!str.contains("buildcraftfactory")) continue;
            BCLog.logger.info(str);
        }
        IBakedModel model = (IBakedModel)event.modelRegistry.func_82594_a((Object)mrl);
        if (model != null) {
            event.modelRegistry.func_82595_a((Object)mrl, (Object)ChuteRenderModel.create(model));
        }
    }

    static {
        miningDepth = 256;
        pumpsNeedRealPower = false;
    }
}

