/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.core.BCLog;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Level;

public class MappingRegistry {
    public HashMap<Block, Integer> blockToId = new HashMap();
    public ArrayList<Block> idToBlock = new ArrayList();
    public HashMap<Item, Integer> itemToId = new HashMap();
    public ArrayList<Item> idToItem = new ArrayList();
    public HashMap<Class<? extends Entity>, Integer> entityToId = new HashMap();
    public ArrayList<Class<? extends Entity>> idToEntity = new ArrayList();

    private void registerItem(Item item) {
        if (item == null) {
            throw new IllegalArgumentException("Cannot register a null item!");
        }
        if (!this.itemToId.containsKey(item)) {
            this.idToItem.add(item);
            this.itemToId.put(item, this.idToItem.size() - 1);
        }
    }

    private void registerBlock(Block block) {
        if (block == null) {
            throw new IllegalArgumentException("Cannot register a null block!");
        }
        if (!this.blockToId.containsKey(block)) {
            this.idToBlock.add(block);
            this.blockToId.put(block, this.idToBlock.size() - 1);
        }
    }

    private void registerEntity(Class<? extends Entity> entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("Cannot register a null entityClass!");
        }
        if (!this.entityToId.containsKey(entityClass)) {
            this.idToEntity.add(entityClass);
            this.entityToId.put(entityClass, this.idToEntity.size() - 1);
        }
    }

    public Item getItemForId(int id) throws MappingNotFoundException {
        if (id >= this.idToItem.size()) {
            throw new MappingNotFoundException("no item mapping at position " + id);
        }
        Item result = this.idToItem.get(id);
        if (result == null) {
            throw new MappingNotFoundException("no item mapping at position " + id);
        }
        return result;
    }

    public int getIdForItem(Item item) {
        if (item == null) {
            throw new NullPointerException("item");
        }
        if (!this.itemToId.containsKey(item)) {
            this.registerItem(item);
        }
        return this.itemToId.get(item);
    }

    public int itemIdToRegistry(int id) {
        Item item = Item.func_150899_d((int)id);
        return this.getIdForItem(item);
    }

    public ResourceLocation itemIdToWorld(int id) throws MappingNotFoundException {
        Item item = this.getItemForId(id);
        return (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
    }

    public Block getBlockForId(int id) throws MappingNotFoundException {
        if (id >= this.idToBlock.size()) {
            throw new MappingNotFoundException("no block mapping at position " + id);
        }
        Block result = this.idToBlock.get(id);
        if (result == null) {
            throw new MappingNotFoundException("no block mapping at position " + id);
        }
        return result;
    }

    public int getIdForBlock(Block block) {
        if (!this.blockToId.containsKey(block)) {
            this.registerBlock(block);
        }
        return this.blockToId.get(block);
    }

    public int blockIdToRegistry(int id) {
        Block block = Block.func_149729_e((int)id);
        return this.getIdForBlock(block);
    }

    public ResourceLocation blockIdToWorld(int id) throws MappingNotFoundException {
        Block block = this.getBlockForId(id);
        return (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
    }

    public Class<? extends Entity> getEntityForId(int id) throws MappingNotFoundException {
        if (id >= this.idToEntity.size()) {
            throw new MappingNotFoundException("no entity mapping at position " + id);
        }
        Class<? extends Entity> result = this.idToEntity.get(id);
        if (result == null) {
            throw new MappingNotFoundException("no entity mapping at position " + id);
        }
        return result;
    }

    public int getIdForEntity(Class<? extends Entity> entity) {
        if (!this.entityToId.containsKey(entity)) {
            this.registerEntity(entity);
        }
        return this.entityToId.get(entity);
    }

    public void stackToWorld(NBTTagCompound nbt) throws MappingNotFoundException {
        if (nbt.func_150297_b("id", 2)) {
            Item item = this.getItemForId(nbt.func_74765_d("id"));
            nbt.func_74778_a("id", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString());
        }
    }

    private boolean isOldStackLayout(NBTTagCompound nbt) {
        return nbt.func_74764_b("id") && nbt.func_74764_b("Count") && nbt.func_74764_b("Damage") && nbt.func_74781_a("id") instanceof NBTTagShort && nbt.func_74781_a("Count") instanceof NBTTagByte && nbt.func_74781_a("Damage") instanceof NBTTagShort;
    }

    public void scanAndTranslateStacksToWorld(NBTTagCompound nbt) throws MappingNotFoundException {
        if (this.isOldStackLayout(nbt)) {
            this.stackToWorld(nbt);
        }
        for (String key : nbt.func_150296_c()) {
            NBTTagList list;
            if (nbt.func_74781_a(key) instanceof NBTTagCompound) {
                try {
                    this.scanAndTranslateStacksToWorld(nbt.func_74775_l(key));
                }
                catch (MappingNotFoundException e) {
                    nbt.func_82580_o(key);
                }
            }
            if (!(nbt.func_74781_a(key) instanceof NBTTagList) || (list = (NBTTagList)nbt.func_74781_a(key)).func_150303_d() != 10) continue;
            for (int i = list.func_74745_c() - 1; i >= 0; --i) {
                try {
                    this.scanAndTranslateStacksToWorld(list.func_150305_b(i));
                    continue;
                }
                catch (MappingNotFoundException e) {
                    list.func_74744_a(i);
                }
            }
        }
    }

    public void write(NBTTagCompound nbt) {
        NBTTagList blocksMapping = new NBTTagList();
        for (Block block : this.idToBlock) {
            NBTTagCompound sub = new NBTTagCompound();
            if (block != null) {
                Object obj = Block.field_149771_c.func_177774_c((Object)block);
                if (obj == null) {
                    BCLog.logger.error("Block " + block.func_149739_a() + " (" + block.getClass().getName() + ") does not have a registry name! This is a bug!");
                } else {
                    String name = obj.toString();
                    if (name == null || name.length() == 0) {
                        BCLog.logger.error("Block " + block.func_149739_a() + " (" + block.getClass().getName() + ") has an empty registry name! This is a bug!");
                    } else {
                        sub.func_74778_a("name", name);
                    }
                }
            } else {
                throw new IllegalArgumentException("Found a null block!");
            }
            blocksMapping.func_74742_a((NBTBase)sub);
        }
        nbt.func_74782_a("blocksMapping", (NBTBase)blocksMapping);
        NBTTagList itemsMapping = new NBTTagList();
        for (Item i : this.idToItem) {
            NBTTagCompound sub = new NBTTagCompound();
            if (i != null) {
                ResourceLocation obj = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)i);
                if (obj == null) {
                    BCLog.logger.error("Item " + i.func_77658_a() + " (" + i.getClass().getName() + ") does not have a registry name! This is a bug!");
                } else {
                    String name = obj.toString();
                    if (name == null || name.length() == 0) {
                        BCLog.logger.error("Item " + i.func_77658_a() + " (" + i.getClass().getName() + ") has an empty registry name! This is a bug!");
                    } else {
                        sub.func_74778_a("name", name);
                    }
                }
            } else {
                throw new IllegalArgumentException("Found a null item!");
            }
            itemsMapping.func_74742_a((NBTBase)sub);
        }
        nbt.func_74782_a("itemsMapping", (NBTBase)itemsMapping);
        NBTTagList nBTTagList = new NBTTagList();
        for (Class<? extends Entity> e : this.idToEntity) {
            NBTTagCompound sub = new NBTTagCompound();
            sub.func_74778_a("name", e.getCanonicalName());
            nBTTagList.func_74742_a((NBTBase)sub);
        }
        nbt.func_74782_a("entitiesMapping", (NBTBase)nBTTagList);
    }

    private Object getMissingMappingFromFML(boolean isBlock, String name, int i) {
        ResourceLocation location = new ResourceLocation(name);
        String modName = name.split(":")[0];
        if (Loader.isModLoaded((String)modName)) {
            try {
                FMLMissingMappingsEvent.MissingMapping mapping = new FMLMissingMappingsEvent.MissingMapping(isBlock ? GameRegistry.Type.BLOCK : GameRegistry.Type.ITEM, location, i);
                ArrayListMultimap missingMapping = ArrayListMultimap.create();
                missingMapping.put((Object)modName, (Object)mapping);
                FMLMissingMappingsEvent event = new FMLMissingMappingsEvent((ListMultimap)missingMapping);
                for (ModContainer container : Loader.instance().getModList()) {
                    if (!(container instanceof FMLModContainer)) continue;
                    event.applyModContainer(container);
                    ((FMLModContainer)container).handleModStateEvent((FMLEvent)event);
                    if (mapping.getAction() == FMLMissingMappingsEvent.Action.DEFAULT) continue;
                    break;
                }
                if (mapping.getAction() == FMLMissingMappingsEvent.Action.REMAP) {
                    return mapping.getTarget();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void read(NBTTagCompound nbt) {
        NBTTagList blocksMapping = nbt.func_150295_c("blocksMapping", 10);
        for (int i = 0; i < blocksMapping.func_74745_c(); ++i) {
            NBTTagCompound sub = blocksMapping.func_150305_b(i);
            if (!sub.func_74764_b("name")) {
                this.idToBlock.add(null);
                BCLog.logger.log(Level.WARN, "Can't load a block - corrupt blueprint!");
                continue;
            }
            String name = sub.func_74779_i("name");
            ResourceLocation location = new ResourceLocation(name);
            Block b = null;
            if (!Block.field_149771_c.func_148741_d((Object)location) && name.contains(":") && (b = (Block)this.getMissingMappingFromFML(true, name, i)) != null) {
                BCLog.logger.info("Remapped " + name + " to " + Block.field_149771_c.func_177774_c((Object)b));
            }
            if (b == null && Block.field_149771_c.func_148741_d((Object)location)) {
                b = (Block)Block.field_149771_c.func_82594_a((Object)location);
            }
            if (b != null) {
                this.registerBlock(b);
                continue;
            }
            this.idToBlock.add(null);
            BCLog.logger.log(Level.WARN, "Can't load block " + name);
        }
        NBTTagList itemsMapping = nbt.func_150295_c("itemsMapping", 10);
        for (int i = 0; i < itemsMapping.func_74745_c(); ++i) {
            NBTTagCompound sub = itemsMapping.func_150305_b(i);
            if (!sub.func_74764_b("name")) {
                this.idToItem.add(null);
                BCLog.logger.log(Level.WARN, "Can't load an item - corrupt blueprint!");
                continue;
            }
            String name = sub.func_74779_i("name");
            ResourceLocation location = new ResourceLocation(name);
            Item item = null;
            if (!Item.field_150901_e.func_148741_d((Object)location) && name.contains(":") && (item = (Item)this.getMissingMappingFromFML(false, name, i)) != null) {
                BCLog.logger.info("Remapped " + name + " to " + Item.field_150901_e.func_177774_c((Object)item));
            }
            if (item == null && Item.field_150901_e.func_148741_d((Object)location)) {
                item = (Item)Item.field_150901_e.func_82594_a((Object)location);
            }
            if (item != null) {
                this.registerItem(item);
                continue;
            }
            this.idToItem.add(null);
            BCLog.logger.log(Level.WARN, "Can't load item " + name);
        }
        NBTTagList entitiesMapping = nbt.func_150295_c("entitiesMapping", 10);
        for (int i = 0; i < entitiesMapping.func_74745_c(); ++i) {
            NBTTagCompound sub = entitiesMapping.func_150305_b(i);
            String name = sub.func_74779_i("name");
            Class<?> e = null;
            try {
                e = Class.forName(name);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            if (e != null) {
                this.registerEntity(e);
                continue;
            }
            this.idToEntity.add(null);
            BCLog.logger.log(Level.WARN, "Can't load entity " + name);
        }
    }

    public void addToCrashReport(CrashReportCategory cat) {
        Comparator comparator = (e1, e2) -> (Integer)e1.getValue() - (Integer)e2.getValue();
        cat.func_71507_a("Item Map Count", (Object)this.itemToId.size());
        this.itemToId.entrySet().stream().sorted(comparator).forEach(e -> cat.func_71507_a("  - ID " + e.getValue(), Item.field_150901_e.func_177774_c(e.getKey())));
        cat.func_71507_a("Block Map Count", (Object)this.blockToId.size());
        this.blockToId.entrySet().stream().sorted(comparator).forEach(e -> cat.func_71507_a("  - ID " + e.getValue(), e.getKey()));
        cat.func_71507_a("Entity Map Count", (Object)this.entityToId.size());
        this.entityToId.entrySet().stream().sorted(comparator).forEach(e -> cat.func_71507_a("  - ID " + e.getValue(), e.getKey()));
    }
}

