/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.core.JavaTools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;

public class SchematicTile
extends SchematicBlock {
    public NBTTagCompound tileNBT = new NBTTagCompound();

    @Override
    public void idsToBlueprint(MappingRegistry registry) {
    }

    @Override
    public void idsToWorld(MappingRegistry registry) {
        try {
            registry.scanAndTranslateStacksToWorld(this.tileNBT);
        }
        catch (MappingNotFoundException e) {
            this.tileNBT = new NBTTagCompound();
        }
    }

    public void onNBTLoaded() {
    }

    @Override
    public void placeInWorld(IBuilderContext context, BlockPos pos, List<ItemStack> stacks) {
        super.placeInWorld(context, pos, stacks);
        if (this.state.func_177230_c().hasTileEntity(this.state)) {
            this.tileNBT.func_74768_a("x", pos.func_177958_n());
            this.tileNBT.func_74768_a("y", pos.func_177956_o());
            this.tileNBT.func_74768_a("z", pos.func_177952_p());
            TileEntity tile = TileEntity.func_145827_c((NBTTagCompound)this.tileNBT);
            tile.func_145834_a(context.world());
            context.world().func_175690_a(pos, tile);
        }
    }

    @Override
    public void initializeFromObjectAt(IBuilderContext context, BlockPos pos) {
        super.initializeFromObjectAt(context, pos);
        if (this.state.func_177230_c().hasTileEntity(this.state)) {
            TileEntity tile = context.world().func_175625_s(pos);
            if (tile != null) {
                tile.func_145841_b(this.tileNBT);
            }
            this.tileNBT = (NBTTagCompound)this.tileNBT.func_74737_b();
            this.onNBTLoaded();
        }
    }

    @Override
    public void storeRequirements(IBuilderContext context, BlockPos pos) {
        TileEntity tile;
        super.storeRequirements(context, pos);
        if (this.state.func_177230_c().hasTileEntity(this.state) && (tile = context.world().func_175625_s(pos)) instanceof IInventory) {
            IInventory inv = (IInventory)tile;
            ArrayList<ItemStack> rqs = new ArrayList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) == null) continue;
                rqs.add(inv.func_70301_a(i));
            }
            this.storedRequirements = JavaTools.concat(this.storedRequirements, rqs.toArray(new ItemStack[rqs.size()]));
        }
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.writeSchematicToNBT(nbt, registry);
        nbt.func_74782_a("blockCpt", (NBTBase)this.tileNBT);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.readSchematicFromNBT(nbt, registry);
        this.tileNBT = nbt.func_74775_l("blockCpt");
        this.onNBTLoaded();
    }

    @Override
    public int buildTime() {
        return 5;
    }
}

