/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import buildcraft.api.core.INetworkLoadable_BC8;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;

public enum EnumPipePart implements IStringSerializable,
INetworkLoadable_BC8<EnumPipePart>
{
    DOWN(EnumFacing.DOWN),
    UP(EnumFacing.UP),
    NORTH(EnumFacing.NORTH),
    SOUTH(EnumFacing.SOUTH),
    WEST(EnumFacing.WEST),
    EAST(EnumFacing.EAST),
    CENTER(null);

    private static final Map<EnumFacing, EnumPipePart> facingMap;
    private static final Map<String, EnumPipePart> nameMap;
    private static final int MAX_VALUES;
    public final EnumFacing face;

    public static EnumPipePart fromFacing(EnumFacing face) {
        if (face == null) {
            return CENTER;
        }
        return facingMap.get(face);
    }

    public static EnumPipePart[] validFaces() {
        return new EnumPipePart[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    }

    public static EnumPipePart fromMeta(int meta) {
        if (meta < 0 || meta >= MAX_VALUES) {
            return CENTER;
        }
        return EnumPipePart.values()[meta];
    }

    private EnumPipePart(EnumFacing face) {
        this.face = face;
    }

    public int getIndex() {
        if (this.face == null) {
            return 6;
        }
        return this.face.func_176745_a();
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public EnumPipePart next() {
        switch (this) {
            case DOWN: {
                return EAST;
            }
            case EAST: {
                return NORTH;
            }
            case NORTH: {
                return SOUTH;
            }
            case SOUTH: {
                return UP;
            }
            case UP: {
                return WEST;
            }
            case WEST: {
                return DOWN;
            }
        }
        return DOWN;
    }

    public EnumPipePart opposite() {
        if (this == CENTER) {
            return CENTER;
        }
        return EnumPipePart.fromFacing(this.face.func_176734_d());
    }

    public static EnumPipePart readFromNBT(NBTBase base) {
        if (base == null) {
            return CENTER;
        }
        if (base instanceof NBTTagString) {
            NBTTagString nbtString = (NBTTagString)base;
            String string = nbtString.func_150285_a_();
            return nameMap.containsKey(string) ? nameMap.get(string) : CENTER;
        }
        byte ord = ((NBTBase.NBTPrimitive)base).func_150290_f();
        if (ord < 0 || ord > 6) {
            return CENTER;
        }
        return EnumPipePart.values()[ord];
    }

    public NBTBase writeToNBT() {
        return new NBTTagString(this.name());
    }

    @Override
    public EnumPipePart readFromByteBuf(ByteBuf buf) {
        byte ord = buf.readByte();
        return EnumPipePart.fromMeta(ord);
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        buf.writeByte(this.ordinal());
    }

    static {
        facingMap = Maps.newEnumMap(EnumFacing.class);
        nameMap = Maps.newHashMap();
        MAX_VALUES = EnumPipePart.values().length;
        for (EnumPipePart part : EnumPipePart.values()) {
            nameMap.put(part.name(), part);
            if (part.face == null) continue;
            facingMap.put(part.face, part);
        }
    }
}

