/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.builders.BuilderProxy;
import buildcraft.builders.TileQuarry;
import buildcraft.core.lib.EntityResizableCuboid;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityMechanicalArm
extends Entity {
    protected TileQuarry parent;
    private double armSizeX;
    private double armSizeZ;
    private Vec3 root;
    private Vec3 head;
    public EntityResizableCuboid xArm;
    public EntityResizableCuboid yArm;
    public EntityResizableCuboid zArm;
    public EntityResizableCuboid headEntity;

    public EntityMechanicalArm(World world) {
        super(world);
        this.makeParts(world);
        this.field_70145_X = true;
    }

    public EntityMechanicalArm(World world, Vec3 root, double width, double height, TileQuarry parent) {
        this(world);
        this.func_70080_a(parent.func_174877_v().func_177958_n(), parent.func_174877_v().func_177956_o(), parent.func_174877_v().func_177952_p(), 0.0f, 0.0f);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.root = root;
        this.setHead(root.func_72441_c(0.0, -2.0, 0.0));
        this.setArmSize(width, height);
        this.parent = parent;
        parent.setArm(this);
        this.updatePosition();
    }

    public void setHead(Vec3 vec) {
        this.head = vec;
    }

    private void setArmSize(double x, double z) {
        this.armSizeX = x;
        this.xArm.xSize = x;
        this.armSizeZ = z;
        this.zArm.zSize = z;
        this.updatePosition();
    }

    private void makeParts(World world) {
        this.xArm = BuilderProxy.proxy.newDrill(world, 0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
        this.yArm = BuilderProxy.proxy.newDrill(world, 0.0, 0.0, 0.0, 0.5, 1.0, 0.5);
        this.zArm = BuilderProxy.proxy.newDrill(world, 0.0, 0.0, 0.0, 0.5, 0.5, 1.0);
        this.headEntity = BuilderProxy.proxy.newDrillHead(world, 0.0, 0.0, 0.0, 0.2, 1.0, 0.2);
        this.headEntity.shadowSize = 1.0f;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        double xRoot = nbttagcompound.func_74769_h("xRoot");
        double yRoot = nbttagcompound.func_74769_h("yRoot");
        double zRoot = nbttagcompound.func_74769_h("zRoot");
        this.root = new Vec3(xRoot, yRoot, zRoot);
        this.armSizeX = nbttagcompound.func_74769_h("armSizeX");
        this.armSizeZ = nbttagcompound.func_74769_h("armSizeZ");
        this.setArmSize(this.armSizeX, this.armSizeZ);
        this.updatePosition();
    }

    private void findAndJoinQuarry() {
        TileEntity te = this.field_70170_p.func_175625_s(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v));
        if (te instanceof TileQuarry) {
            this.parent = (TileQuarry)te;
            this.parent.setArm(this);
        } else {
            this.func_70106_y();
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74780_a("xRoot", this.root.field_72450_a);
        nbttagcompound.func_74780_a("yRoot", this.root.field_72448_b);
        nbttagcompound.func_74780_a("zRoot", this.root.field_72449_c);
        nbttagcompound.func_74780_a("armSizeX", this.armSizeX);
        nbttagcompound.func_74780_a("armSizeZ", this.armSizeZ);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updatePosition();
        if (this.parent == null) {
            this.findAndJoinQuarry();
        }
        if (this.parent == null) {
            this.func_70106_y();
            return;
        }
        this.xArm.func_70071_h_();
        this.yArm.func_70071_h_();
        this.zArm.func_70071_h_();
        this.headEntity.func_70071_h_();
    }

    public void updatePosition() {
        this.xArm.func_70107_b(this.root.field_72450_a, this.root.field_72448_b, this.head.field_72449_c + 0.25);
        this.yArm.ySize = this.root.field_72448_b - this.head.field_72448_b - 1.0;
        this.yArm.func_70107_b(this.head.field_72450_a + 0.25, this.head.field_72448_b + 1.0, this.head.field_72449_c + 0.25);
        this.zArm.func_70107_b(this.head.field_72450_a + 0.25, this.root.field_72448_b, this.root.field_72449_c);
        this.headEntity.func_70107_b(this.head.field_72450_a + 0.4, this.head.field_72448_b - 0.01, this.head.field_72449_c + 0.4);
    }

    public void func_70106_y() {
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            this.xArm.func_70106_y();
            this.yArm.func_70106_y();
            this.zArm.func_70106_y();
            this.headEntity.func_70106_y();
        }
        super.func_70106_y();
    }
}

