/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.IPathProvider;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.enums.EnumBlueprintType;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.builders.ItemBlueprint;
import buildcraft.builders.ItemBlueprintStandard;
import buildcraft.builders.ItemBlueprintTemplate;
import buildcraft.builders.blueprints.RecursiveBlueprintBuilder;
import buildcraft.core.Box;
import buildcraft.core.LaserData;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.blueprints.RequirementItemStack;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.fluids.TankManager;
import buildcraft.core.lib.inventory.IInventoryListener;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.inventory.Transactor;
import buildcraft.core.lib.network.base.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileBuilder
extends TileAbstractBuilder
implements IHasWork,
IFluidHandler,
IRequestProvider,
IControllable,
IInventoryListener {
    private static int POWER_ACTIVATION = 500;
    public Box box = new Box();
    public PathIterator currentPathIterator;
    public Tank[] fluidTanks = new Tank[]{new Tank("fluid1", 8000, this), new Tank("fluid2", 8000, this), new Tank("fluid3", 8000, this), new Tank("fluid4", 8000, this)};
    public TankManager<Tank> fluidTank = new TankManager(this.fluidTanks);
    private SafeTimeTracker networkUpdateTracker = new SafeTimeTracker(BuildCraftCore.updateFactor / 2);
    private boolean shouldUpdateRequirements;
    private SimpleInventory inv = new SimpleInventory(28, "Builder", 64);
    private BptBuilderBase currentBuilder;
    private RecursiveBlueprintBuilder recursiveBuilder;
    private List<BlockPos> path;
    private List<RequirementItemStack> requiredToBuild;
    private NBTTagCompound initNBT = null;
    private boolean done = true;
    private boolean isBuilding = false;
    private EnumBlueprintType type = EnumBlueprintType.NONE;

    public TileBuilder() {
        this.box.kind = Box.Kind.STRIPES;
        this.inv.addInvListener(this);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.initNBT != null) {
            this.iterateBpt(true);
            if (this.initNBT.func_74764_b("iterator")) {
                BlockPos bi;
                BlockPos expectedTo = NBTUtils.readBlockPos(this.initNBT.func_74781_a("iterator"));
                while (!this.done && this.currentBuilder != null && this.currentPathIterator != null && !(bi = new BlockPos((int)this.currentPathIterator.ix, (int)this.currentPathIterator.iy, (int)this.currentPathIterator.iz)).equals((Object)expectedTo)) {
                    this.iterateBpt(true);
                }
            }
            if (this.currentBuilder != null) {
                this.currentBuilder.loadBuildStateToNBT(this.initNBT.func_74775_l("builderState"), this);
            }
            this.initNBT = null;
        }
        this.box.kind = Box.Kind.STRIPES;
        for (EnumFacing face : EnumFacing.values()) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
            if (!(tile instanceof IPathProvider)) continue;
            this.path = ((IPathProvider)tile).getPath();
            ((IPathProvider)tile).removeFromWorld();
            break;
        }
        if (this.path != null && this.pathLasers.size() == 0) {
            this.createLasersForPath();
            this.sendNetworkUpdate();
        }
        this.iterateBpt(false);
    }

    public void createLasersForPath() {
        this.pathLasers = new LinkedList();
        BlockPos previous = null;
        for (BlockPos b : this.path) {
            if (previous != null) {
                Vec3 point5 = new Vec3(0.5, 0.5, 0.5);
                LaserData laser = new LaserData(Utils.convert((Vec3i)previous).func_178787_e(point5), Utils.convert((Vec3i)b).func_178787_e(point5));
                this.pathLasers.add(laser);
            }
            previous = b;
        }
    }

    public BlueprintBase instanciateBlueprint() {
        BlueprintBase bpt;
        try {
            bpt = ItemBlueprint.loadBlueprint(this.func_70301_a(0));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
        return bpt;
    }

    @Deprecated
    public BptBuilderBase instanciateBluePrintBuilder(BlockPos pos, EnumFacing o) {
        BlueprintBase bpt = this.instanciateBlueprint();
        if (bpt == null) {
            return null;
        }
        if ((bpt = bpt.adjustToWorld(this.field_145850_b, pos, o)) != null) {
            if (this.func_70301_a(0).func_77973_b() instanceof ItemBlueprintStandard) {
                return new BptBuilderBlueprint((Blueprint)bpt, this.field_145850_b, pos);
            }
            if (this.func_70301_a(0).func_77973_b() instanceof ItemBlueprintTemplate) {
                return new BptBuilderTemplate(bpt, this.field_145850_b, pos);
            }
        }
        return null;
    }

    public void iterateBpt(boolean forceIterate) {
        if ((this.func_70301_a(0) == null || !(this.func_70301_a(0).func_77973_b() instanceof ItemBlueprint)) && this.box.isInitialized()) {
            if (this.currentBuilder != null) {
                this.currentBuilder = null;
            }
            if (this.box.isInitialized()) {
                this.box.reset();
            }
            if (this.currentPathIterator != null) {
                this.currentPathIterator = null;
            }
            this.scheduleRequirementUpdate();
            this.sendNetworkUpdate();
            return;
        }
        if (this.currentBuilder == null || this.currentBuilder.isDone(this) || forceIterate) {
            if (this.path != null && this.path.size() > 1) {
                if (this.currentPathIterator == null) {
                    Iterator<BlockPos> it = this.path.iterator();
                    BlockPos start = it.next();
                    EnumFacing face = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BuildCraftProperties.BLOCK_FACING);
                    this.currentPathIterator = new PathIterator(start, it, face);
                }
                if (this.currentBuilder != null && this.currentBuilder.isDone(this)) {
                    this.currentBuilder.postProcessing(this.field_145850_b);
                }
                this.currentBuilder = this.currentPathIterator.next();
                if (this.currentBuilder != null) {
                    this.box.reset();
                    this.box.initialize(this.currentBuilder);
                    this.sendNetworkUpdate();
                }
                if (this.currentBuilder == null) {
                    this.currentPathIterator = this.currentPathIterator.iterate();
                }
                this.done = this.currentPathIterator == null;
                this.scheduleRequirementUpdate();
            } else {
                if (this.currentBuilder != null && this.currentBuilder.isDone(this)) {
                    this.currentBuilder.postProcessing(this.field_145850_b);
                    this.currentBuilder = this.recursiveBuilder.nextBuilder();
                    this.scheduleRequirementUpdate();
                } else {
                    BlueprintBase bpt = this.instanciateBlueprint();
                    if (bpt != null) {
                        EnumFacing face = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BuildCraftProperties.BLOCK_FACING);
                        this.recursiveBuilder = new RecursiveBlueprintBuilder(bpt, this.field_145850_b, this.field_174879_c, face.func_176734_d());
                        this.currentBuilder = this.recursiveBuilder.nextBuilder();
                        this.scheduleRequirementUpdate();
                    }
                }
                if (this.currentBuilder == null) {
                    this.done = true;
                } else {
                    this.box.initialize(this.currentBuilder);
                    this.sendNetworkUpdate();
                    this.done = false;
                }
            }
        }
        if (this.done && this.func_70301_a(0) != null) {
            boolean dropBlueprint = true;
            for (int i = 1; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) != null) continue;
                this.func_70299_a(i, this.func_70301_a(0));
                dropBlueprint = false;
                break;
            }
            if (dropBlueprint) {
                InvUtils.dropItems(this.func_145831_w(), this.func_70301_a(0), this.field_174879_c);
            }
            this.func_70299_a(0, null);
            this.box.reset();
        }
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack result = this.inv.func_70298_a(i, j);
        if (!this.field_145850_b.field_72995_K && i == 0) {
            BuildCraftCore.instance.sendToWorld(new PacketCommand(this, "clearItemRequirements", null), this.field_145850_b);
            this.iterateBpt(false);
        }
        return result;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
        if (!this.field_145850_b.field_72995_K && i == 0) {
            this.iterateBpt(false);
            this.done = false;
        }
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    @Override
    public String getInventoryName() {
        return "Builder";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("box")) {
            this.box.initialize(nbttagcompound.func_74775_l("box"));
        }
        if (nbttagcompound.func_74764_b("path")) {
            this.path = new LinkedList<BlockPos>();
            NBTTagList list = nbttagcompound.func_150295_c("path", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.path.add(NBTUtils.readBlockPos(list.func_179238_g(i)));
            }
        }
        this.done = nbttagcompound.func_74767_n("done");
        this.fluidTank.readFromNBT(nbttagcompound);
        this.initNBT = (NBTTagCompound)nbttagcompound.func_74775_l("bptBuilder").func_74737_b();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound);
        if (this.box.isInitialized()) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbttagcompound.func_74782_a("box", (NBTBase)boxStore);
        }
        if (this.path != null) {
            NBTTagList list = new NBTTagList();
            for (BlockPos i : this.path) {
                list.func_74742_a(NBTUtils.writeBlockPos(i));
            }
            nbttagcompound.func_74782_a("path", (NBTBase)list);
        }
        nbttagcompound.func_74757_a("done", this.done);
        this.fluidTank.writeToNBT(nbttagcompound);
        NBTTagCompound bptNBT = new NBTTagCompound();
        if (this.currentBuilder != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.currentBuilder.saveBuildStateToNBT(builderCpt, this);
            bptNBT.func_74782_a("builderState", (NBTBase)builderCpt);
        }
        if (this.currentPathIterator != null) {
            BlockPos nPos = new BlockPos((int)this.currentPathIterator.ix, (int)this.currentPathIterator.iy, (int)this.currentPathIterator.iz);
            bptNBT.func_74782_a("iterator", NBTUtils.writeBlockPos(nPos));
        }
        nbttagcompound.func_74782_a("bptBuilder", (NBTBase)bptNBT);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.shouldUpdateRequirements && this.networkUpdateTracker.markTimeIfDelay(this.field_145850_b)) {
            this.updateRequirements();
            this.shouldUpdateRequirements = false;
        }
        if ((this.currentBuilder == null || this.currentBuilder.isDone(this)) && this.box.isInitialized()) {
            this.box.reset();
            this.sendNetworkUpdate();
            return;
        }
        this.iterateBpt(false);
        if (this.mode != IControllable.Mode.Off && (this.func_145831_w().func_72912_H().func_76077_q() == WorldSettings.GameType.CREATIVE || this.getBattery().getEnergyStored() > POWER_ACTIVATION)) {
            this.build();
        }
        if (!this.isBuilding && this.isBuildingBlueprint()) {
            this.scheduleRequirementUpdate();
        }
        this.isBuilding = this.isBuildingBlueprint();
        if (this.done) {
            return;
        }
        if (this.getBattery().getEnergyStored() < 25) {
            return;
        }
    }

    @Override
    public boolean hasWork() {
        return !this.done;
    }

    public boolean isBuildingBlueprint() {
        return this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemBlueprint;
    }

    public List<RequirementItemStack> getNeededItems() {
        return this.field_145850_b.field_72995_K ? this.requiredToBuild : (this.currentBuilder instanceof BptBuilderBlueprint ? ((BptBuilderBlueprint)this.currentBuilder).getNeededItems() : null);
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        super.receiveCommand(command, side, sender, stream);
        if (side.isClient()) {
            if ("clearItemRequirements".equals(command)) {
                this.requiredToBuild = null;
            } else if ("setItemRequirements".equals(command)) {
                int size = stream.readUnsignedMedium();
                this.requiredToBuild = new ArrayList<RequirementItemStack>();
                for (int i = 0; i < size; ++i) {
                    int itemId = stream.readUnsignedShort();
                    short itemDamage = stream.readShort();
                    int stackSize = stream.readUnsignedMedium();
                    boolean hasCompound = stackSize >= 0x800000;
                    ItemStack stack = new ItemStack(Item.func_150899_d((int)itemId), 1, (int)itemDamage);
                    if (hasCompound) {
                        stack.func_77982_d(NetworkUtils.readNBT(stream));
                    }
                    if (stack.func_77973_b() != null) {
                        this.requiredToBuild.add(new RequirementItemStack(stack, stackSize & 0x7FFFFF));
                        continue;
                    }
                    BCLog.logger.error("Corrupt ItemStack in TileBuilder.receiveCommand! This should not happen! (ID " + itemId + ", damage " + itemDamage + ")");
                }
            }
        } else if (side.isServer()) {
            EntityPlayer player = (EntityPlayer)sender;
            if ("eraseFluidTank".equals(command)) {
                int id = stream.readInt();
                if (id < 0 || id >= this.fluidTanks.length) {
                    return;
                }
                if (this.func_70300_a(player) && player.func_174818_b(this.field_174879_c) <= 64.0) {
                    this.fluidTanks[id].setFluid(null);
                    this.sendNetworkUpdate();
                }
            }
        }
    }

    private Packet getItemRequirementsPacket(List<RequirementItemStack> itemsIn) {
        if (itemsIn != null) {
            final ArrayList<RequirementItemStack> items = new ArrayList<RequirementItemStack>();
            items.addAll(itemsIn);
            return new PacketCommand(this, "setItemRequirements", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeMedium(items.size());
                    for (RequirementItemStack rb : items) {
                        data.writeShort(Item.func_150891_b((Item)rb.stack.func_77973_b()));
                        data.writeShort(rb.stack.func_77952_i());
                        data.writeMedium((rb.stack.func_77942_o() ? 0x800000 : 0) | Math.min(0x7FFFFF, rb.size));
                        if (!rb.stack.func_77942_o()) continue;
                        NetworkUtils.writeNBT(data, rb.stack.func_77978_p());
                    }
                }
            });
        }
        return new PacketCommand(this, "clearItemRequirements", null);
    }

    @Override
    public boolean isBuildingMaterialSlot(int i) {
        return i != 0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.func_77973_b() instanceof ItemBlueprint;
        }
        return true;
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box renderBox = new Box(this).extendToEncompass(this.box);
        for (LaserData l : this.pathLasers) {
            renderBox = renderBox.extendToEncompass(l.head);
            renderBox = renderBox.extendToEncompass(l.tail);
        }
        return renderBox.expand(50).getBoundingBox();
    }

    public void build() {
        if (this.currentBuilder != null && this.currentBuilder.buildNextSlot(this.field_145850_b, this)) {
            this.scheduleRequirementUpdate();
        }
    }

    private void updateRequirements() {
        List<RequirementItemStack> reqCopy = null;
        if (this.currentBuilder instanceof BptBuilderBlueprint) {
            this.currentBuilder.initialize();
            reqCopy = ((BptBuilderBlueprint)this.currentBuilder).getNeededItems();
        }
        for (EntityPlayer p : this.guiWatchers) {
            BuildCraftCore.instance.sendToPlayer(p, this.getItemRequirementsPacket(reqCopy));
        }
    }

    public void scheduleRequirementUpdate() {
        this.shouldUpdateRequirements = true;
    }

    public void updateRequirementsOnGuiOpen(EntityPlayer caller) {
        List<RequirementItemStack> reqCopy = null;
        if (this.currentBuilder instanceof BptBuilderBlueprint) {
            this.currentBuilder.initialize();
            reqCopy = ((BptBuilderBlueprint)this.currentBuilder).getNeededItems();
        }
        BuildCraftCore.instance.sendToPlayer(caller, this.getItemRequirementsPacket(reqCopy));
    }

    public BptBuilderBase getBlueprint() {
        if (this.currentBuilder != null) {
            return this.currentBuilder;
        }
        return null;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean drainBuild(FluidStack fluidStack, boolean realDrain) {
        for (Tank tank : this.fluidTanks) {
            if (tank.getFluidType() != fluidStack.getFluid()) continue;
            return tank.getFluidAmount() >= fluidStack.amount && tank.drain((int)fluidStack.amount, (boolean)realDrain).amount > 0;
        }
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        Fluid fluid = resource.getFluid();
        Tank emptyTank = null;
        for (Tank tank : this.fluidTanks) {
            Fluid type = tank.getFluidType();
            if (type == fluid) {
                int used = tank.fill(resource, doFill);
                if (used > 0 && doFill) {
                    this.sendNetworkUpdate();
                }
                return used;
            }
            if (emptyTank != null || !tank.isEmpty()) continue;
            emptyTank = tank;
        }
        if (emptyTank != null) {
            int used = emptyTank.fill(resource, doFill);
            if (used > 0 && doFill) {
                this.sendNetworkUpdate();
            }
            return used;
        }
        return 0;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        boolean emptyAvailable = false;
        for (Tank tank : this.fluidTanks) {
            Fluid type = tank.getFluidType();
            if (type == fluid) {
                return !tank.isFull();
            }
            if (emptyAvailable) continue;
            emptyAvailable = tank.isEmpty();
        }
        return emptyAvailable;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return this.fluidTank.getTankInfo(from);
    }

    @Override
    public int getRequestsCount() {
        if (this.currentBuilder == null) {
            return 0;
        }
        if (!(this.currentBuilder instanceof BptBuilderBlueprint)) {
            return 0;
        }
        BptBuilderBlueprint bpt = (BptBuilderBlueprint)this.currentBuilder;
        return bpt.getNeededItems().size();
    }

    @Override
    public ItemStack getRequest(int slot) {
        if (this.currentBuilder == null) {
            return null;
        }
        if (!(this.currentBuilder instanceof BptBuilderBlueprint)) {
            return null;
        }
        BptBuilderBlueprint bpt = (BptBuilderBlueprint)this.currentBuilder;
        List<RequirementItemStack> neededItems = bpt.getNeededItems();
        if (neededItems.size() <= slot) {
            return null;
        }
        RequirementItemStack requirement = neededItems.get(slot);
        int qty = this.quantityMissing(requirement.stack, requirement.size);
        if (qty <= 0) {
            return null;
        }
        ItemStack requestStack = requirement.stack.func_77946_l();
        requestStack.field_77994_a = qty;
        return requestStack;
    }

    @Override
    public ItemStack offerItem(int slot, ItemStack stack) {
        if (this.currentBuilder == null) {
            return stack;
        }
        if (!(this.currentBuilder instanceof BptBuilderBlueprint)) {
            return stack;
        }
        BptBuilderBlueprint bpt = (BptBuilderBlueprint)this.currentBuilder;
        List<RequirementItemStack> neededItems = bpt.getNeededItems();
        if (neededItems.size() <= slot) {
            return stack;
        }
        RequirementItemStack requirement = neededItems.get(slot);
        int qty = this.quantityMissing(requirement.stack, requirement.size);
        if (qty <= 0) {
            return stack;
        }
        ItemStack toAdd = stack.func_77946_l();
        if (qty < toAdd.field_77994_a) {
            toAdd.field_77994_a = qty;
        }
        ITransactor t = Transactor.getTransactorFor(this);
        ItemStack added = t.add(toAdd, null, true);
        if (added.field_77994_a >= stack.field_77994_a) {
            return null;
        }
        stack.field_77994_a -= added.field_77994_a;
        return stack;
    }

    private int quantityMissing(ItemStack requirement, int amount) {
        int left = amount <= 0 ? requirement.field_77994_a : amount;
        for (IInvSlot slot : InventoryIterator.getIterable(this)) {
            if (slot.getStackInSlot() == null || !StackHelper.isEqualItem(requirement, slot.getStackInSlot())) continue;
            if (slot.getStackInSlot().field_77994_a >= left) {
                return 0;
            }
            left -= slot.getStackInSlot().field_77994_a;
        }
        return left;
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.Off || mode == IControllable.Mode.On;
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        this.box.writeData(stream);
        this.fluidTank.writeData(stream);
        stream.writeByte(this.getType().ordinal());
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.box.readData(stream);
        this.fluidTank.readData(stream);
        byte type = stream.readByte();
        EnumBlueprintType old = this.type;
        this.type = EnumBlueprintType.valueOf(type);
        if (old != this.type) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public EnumBlueprintType getType() {
        return this.type;
    }

    @Override
    public void onChange(int slot, ItemStack before, ItemStack after) {
        EnumBlueprintType afterType;
        EnumBlueprintType beforeType;
        if (slot == 0 && this.field_145850_b != null && !this.field_145850_b.field_72995_K && (beforeType = EnumBlueprintType.getType(before)) != (afterType = EnumBlueprintType.getType(after))) {
            this.type = afterType;
            this.sendNetworkUpdate();
        }
    }

    @Override
    public Tank[] getFluidTanks() {
        return this.fluidTanks;
    }

    private class PathIterator {
        public Iterator<BlockPos> currentIterator;
        public double cx;
        public double cy;
        public double cz;
        public float ix;
        public float iy;
        public float iz;
        public BlockPos to;
        public double lastDistance;
        AxisAlignedBB oldBoundingBox = null;
        EnumFacing o = null;

        public PathIterator(BlockPos from, Iterator<BlockPos> it, EnumFacing initialDir) {
            this.to = it.next();
            this.currentIterator = it;
            double dx = this.to.func_177958_n() - from.func_177958_n();
            double dy = this.to.func_177956_o() - from.func_177956_o();
            double dz = this.to.func_177952_p() - from.func_177952_p();
            double size = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.cx = dx / size / 10.0;
            this.cy = dy / size / 10.0;
            this.cz = dz / size / 10.0;
            this.ix = from.func_177958_n();
            this.iy = from.func_177956_o();
            this.iz = from.func_177952_p();
            this.lastDistance = (this.ix - (float)this.to.func_177958_n()) * (this.ix - (float)this.to.func_177958_n()) + (this.iy - (float)this.to.func_177956_o()) * (this.iy - (float)this.to.func_177956_o()) + (this.iz - (float)this.to.func_177952_p()) * (this.iz - (float)this.to.func_177952_p());
            this.o = dx == 0.0 && dz == 0.0 ? initialDir : (Math.abs(dx) > Math.abs(dz) ? (dx > 0.0 ? EnumFacing.EAST : EnumFacing.WEST) : (dz > 0.0 ? EnumFacing.SOUTH : EnumFacing.NORTH));
        }

        public BptBuilderBase next() {
            int newZ;
            int newY;
            int newX;
            BptBuilderBase bpt;
            while ((bpt = TileBuilder.this.instanciateBluePrintBuilder(new BlockPos(newX = Math.round(this.ix), newY = Math.round(this.iy), newZ = Math.round(this.iz)), this.o)) != null) {
                AxisAlignedBB boundingBox = bpt.getBoundingBox();
                if (this.oldBoundingBox == null || !this.collision(this.oldBoundingBox, boundingBox)) {
                    this.oldBoundingBox = boundingBox;
                    return bpt;
                }
                this.ix = (float)((double)this.ix + this.cx);
                this.iy = (float)((double)this.iy + this.cy);
                this.iz = (float)((double)this.iz + this.cz);
                double distance = (this.ix - (float)this.to.func_177958_n()) * (this.ix - (float)this.to.func_177958_n()) + (this.iy - (float)this.to.func_177956_o()) * (this.iy - (float)this.to.func_177956_o()) + (this.iz - (float)this.to.func_177952_p()) * (this.iz - (float)this.to.func_177952_p());
                if (distance > this.lastDistance) {
                    return null;
                }
                this.lastDistance = distance;
            }
            return null;
        }

        public PathIterator iterate() {
            if (this.currentIterator.hasNext()) {
                PathIterator next = new PathIterator(this.to, this.currentIterator, this.o);
                next.oldBoundingBox = this.oldBoundingBox;
                return next;
            }
            return null;
        }

        public boolean collision(AxisAlignedBB left, AxisAlignedBB right) {
            if (left.field_72336_d < right.field_72340_a || left.field_72340_a > right.field_72336_d) {
                return false;
            }
            if (left.field_72337_e < right.field_72338_b || left.field_72338_b > right.field_72337_e) {
                return false;
            }
            return !(left.field_72334_f < right.field_72339_c) && !(left.field_72339_c > right.field_72334_f);
        }
    }
}

