/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.builders.ItemBlueprint;
import buildcraft.core.Box;
import buildcraft.core.LaserData;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.internal.IBoxProvider;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.network.base.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraftforge.fml.relauncher.Side;

public class TileConstructionMarker
extends TileBuildCraft
implements IBuildingItemsProvider,
IBoxProvider,
ICommandReceiver {
    public static HashSet<TileConstructionMarker> currentMarkers = new HashSet();
    public EnumFacing direction = null;
    public LaserData laser;
    public ItemStack itemBlueprint;
    public Box box = new Box();
    public BptBuilderBase bluePrintBuilder;
    public BptContext bptContext;
    private ArrayList<BuildingItem> buildersInAction = new ArrayList();
    private NBTTagCompound initNBT;

    @Override
    public void initialize() {
        super.initialize();
        this.box.kind = Box.Kind.BLUE_STRIPES;
        if (this.field_145850_b.field_72995_K) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "uploadBuildersInAction", null));
        }
    }

    private Packet createLaunchItemPacket(final BuildingItem i) {
        return new PacketCommand(this, "launchItem", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                i.writeData(data);
            }
        });
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        BuildingItem toRemove = null;
        for (BuildingItem i : this.buildersInAction) {
            i.update();
            if (!i.isDone) continue;
            toRemove = i;
        }
        if (toRemove != null) {
            this.buildersInAction.remove(toRemove);
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.itemBlueprint != null && ItemBlueprint.getId(this.itemBlueprint) != null && this.bluePrintBuilder == null) {
            BlueprintBase bpt = ItemBlueprint.loadBlueprint(this.itemBlueprint);
            if (bpt != null && bpt instanceof Blueprint) {
                if ((bpt = bpt.adjustToWorld(this.field_145850_b, this.field_174879_c, this.direction)) != null) {
                    this.bluePrintBuilder = new BptBuilderBlueprint((Blueprint)bpt, this.field_145850_b, this.field_174879_c);
                    this.bptContext = this.bluePrintBuilder.getContext();
                    this.box.initialize(this.bluePrintBuilder);
                    this.sendNetworkUpdate();
                }
            } else {
                return;
            }
        }
        if (this.laser == null && this.direction != null) {
            Vec3 point5 = new Vec3(0.5, 0.5, 0.5);
            this.laser = new LaserData();
            this.laser.head = Utils.convert((Vec3i)this.field_174879_c).func_178787_e(point5);
            this.laser.tail = this.laser.head.func_178787_e(Utils.convert(this.direction, 0.5));
            this.laser.isVisible = true;
            this.sendNetworkUpdate();
        }
        if (this.initNBT != null) {
            if (this.bluePrintBuilder != null) {
                this.bluePrintBuilder.loadBuildStateToNBT(this.initNBT.func_74775_l("builderState"), this);
            }
            this.initNBT = null;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        NBTTagCompound bptNBT;
        super.func_145841_b(nbt);
        nbt.func_74774_a("direction", (byte)this.direction.ordinal());
        if (this.itemBlueprint != null) {
            bptNBT = new NBTTagCompound();
            this.itemBlueprint.func_77955_b(bptNBT);
            nbt.func_74782_a("itemBlueprint", (NBTBase)bptNBT);
        }
        bptNBT = new NBTTagCompound();
        if (this.bluePrintBuilder != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.bluePrintBuilder.saveBuildStateToNBT(builderCpt, this);
            bptNBT.func_74782_a("builderState", (NBTBase)builderCpt);
        }
        nbt.func_74782_a("bptBuilder", (NBTBase)bptNBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.direction = EnumFacing.field_82609_l[nbt.func_74771_c("direction")];
        if (nbt.func_74764_b("itemBlueprint")) {
            this.itemBlueprint = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("itemBlueprint"));
        }
        this.initNBT = (NBTTagCompound)nbt.func_74775_l("bptBuilder").func_74737_b();
    }

    public void setBlueprint(ItemStack currentItem) {
        this.itemBlueprint = currentItem;
        this.sendNetworkUpdate();
    }

    public ArrayList<BuildingItem> getBuilders() {
        return this.buildersInAction;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            currentMarkers.add(this);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            currentMarkers.remove(this);
        }
    }

    public boolean needsToBuild() {
        return !this.func_145837_r() && this.bluePrintBuilder != null && !this.bluePrintBuilder.isDone(this);
    }

    public BptContext getContext() {
        return this.bptContext;
    }

    @Override
    public void addAndLaunchBuildingItem(BuildingItem item) {
        this.buildersInAction.add(item);
        BuildCraftCore.instance.sendToPlayersNear(this.createLaunchItemPacket(item), this);
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isServer() && "uploadBuildersInAction".equals(command)) {
            for (BuildingItem i : this.buildersInAction) {
                BuildCraftCore.instance.sendToPlayer((EntityPlayer)sender, this.createLaunchItemPacket(i));
            }
        } else if (side.isClient() && "launchItem".equals(command)) {
            BuildingItem item = new BuildingItem();
            item.readData(stream);
            this.buildersInAction.add(item);
        }
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box renderBox = new Box(this).extendToEncompass(this.box);
        return renderBox.expand(50).getBoundingBox();
    }

    public double func_145833_n() {
        return Double.MAX_VALUE;
    }

    @Override
    public void writeData(ByteBuf stream) {
        this.box.writeData(stream);
        stream.writeByte((this.laser != null ? 1 : 0) | (this.itemBlueprint != null ? 2 : 0));
        if (this.laser != null) {
            this.laser.writeData(stream);
        }
        if (this.itemBlueprint != null) {
            NetworkUtils.writeStack(stream, this.itemBlueprint);
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        this.box.readData(stream);
        short flags = stream.readUnsignedByte();
        if ((flags & 1) != 0) {
            this.laser = new LaserData();
            this.laser.readData(stream);
        } else {
            this.laser = null;
        }
        this.itemBlueprint = (flags & 2) != 0 ? NetworkUtils.readStack(stream) : null;
    }
}

