/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.render;

import buildcraft.builders.TileQuarry;
import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.render.RenderResizableCuboid;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.render.RenderBuilder;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;

public class RenderQuarry
extends RenderBuilder<TileQuarry> {
    @Override
    public void renderTileEntityAt(TileQuarry quarry, double x, double y, double z, float partialTicks, int arg) {
        super.renderTileEntityAt(quarry, x, y, z, partialTicks, arg);
        if (quarry.arm != null) {
            if (quarry.arm.xArm != null) {
                this.renderCuboid(quarry, quarry.arm.xArm, x, y, z, partialTicks);
            }
            if (quarry.arm.yArm != null) {
                this.renderCuboid(quarry, quarry.arm.yArm, x, y, z, partialTicks);
            }
            if (quarry.arm.zArm != null) {
                this.renderCuboid(quarry, quarry.arm.zArm, x, y, z, partialTicks);
            }
            if (quarry.arm.headEntity != null) {
                this.renderCuboid(quarry, quarry.arm.headEntity, x, y, z, partialTicks);
            }
        }
    }

    private void renderCuboid(TileQuarry quarry, EntityResizableCuboid cuboid, double x, double y, double z, float partialTicks) {
        Vec3 interp = Utils.getInterpolatedVec(cuboid, partialTicks);
        interp = interp.func_178788_d(Utils.convert((Vec3i)quarry.func_174877_v()));
        interp = interp.func_72441_c(x, y, z);
        RenderResizableCuboid.INSTANCE.doRender(cuboid, interp.field_72450_a, interp.field_72448_b, interp.field_72449_c, 0.0f, partialTicks);
    }
}

