/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.schematics;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.core.lib.utils.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;

public class SchematicHanging
extends SchematicEntity {
    private Item baseItem;

    public SchematicHanging(Item baseItem) {
        this.baseItem = baseItem;
    }

    @Override
    public void translateToBlueprint(Vec3 transform) {
        super.translateToBlueprint(transform);
        Vec3 pos = new Vec3((double)this.entityNBT.func_74762_e("TileX"), (double)this.entityNBT.func_74762_e("TileY"), (double)this.entityNBT.func_74762_e("TileZ"));
        pos = pos.func_178787_e(transform);
        BlockPos floored = Utils.convertFloor(pos);
        this.entityNBT.func_74768_a("TileX", floored.func_177958_n());
        this.entityNBT.func_74768_a("TileY", floored.func_177956_o());
        this.entityNBT.func_74768_a("TileZ", floored.func_177952_p());
    }

    @Override
    public void translateToWorld(Vec3 transform) {
        super.translateToWorld(transform);
        Vec3 pos = new Vec3((double)this.entityNBT.func_74762_e("TileX"), (double)this.entityNBT.func_74762_e("TileY"), (double)this.entityNBT.func_74762_e("TileZ"));
        pos = pos.func_178787_e(transform);
        BlockPos floored = Utils.convertFloor(pos);
        this.entityNBT.func_74768_a("TileX", floored.func_177958_n());
        this.entityNBT.func_74768_a("TileY", floored.func_177956_o());
        this.entityNBT.func_74768_a("TileZ", floored.func_177952_p());
    }

    @Override
    public void rotateLeft(IBuilderContext context) {
        super.rotateLeft(context);
        Vec3 pos = new Vec3((double)this.entityNBT.func_74762_e("TileX"), (double)this.entityNBT.func_74762_e("TileY"), (double)this.entityNBT.func_74762_e("TileZ"));
        pos = context.rotatePositionLeft(pos);
        this.entityNBT.func_74768_a("TileX", (int)pos.field_72450_a);
        this.entityNBT.func_74768_a("TileY", (int)pos.field_72448_b);
        this.entityNBT.func_74768_a("TileZ", (int)pos.field_72449_c);
        int direction = this.entityNBT.func_74771_c("Direction");
        direction = direction < 3 ? direction + 1 : 0;
        this.entityNBT.func_74768_a("Direction", direction);
    }

    @Override
    public void readFromWorld(IBuilderContext context, Entity entity) {
        super.readFromWorld(context, entity);
        if (this.baseItem == Items.field_151160_bD) {
            NBTTagCompound tag = this.entityNBT.func_74775_l("Item");
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (stack != null) {
                this.storedRequirements = new ItemStack[2];
                this.storedRequirements[0] = new ItemStack(this.baseItem);
                this.storedRequirements[1] = stack;
            } else {
                this.storedRequirements = new ItemStack[1];
                this.storedRequirements[0] = new ItemStack(this.baseItem);
            }
        } else {
            this.storedRequirements = new ItemStack[1];
            this.storedRequirements[0] = new ItemStack(this.baseItem);
        }
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context) {
        Vec3 newPosition = new Vec3((double)this.entityNBT.func_74762_e("TileX"), (double)this.entityNBT.func_74762_e("TileY"), (double)this.entityNBT.func_74762_e("TileZ"));
        int dir = this.entityNBT.func_74762_e("Direction");
        for (Object o : context.world().field_72996_f) {
            Entity e = (Entity)o;
            if (!(e instanceof EntityHanging)) continue;
            EntityHanging h = (EntityHanging)e;
            Vec3 existingPositon = new Vec3((double)h.field_70176_ah, (double)h.field_70162_ai, (double)h.field_70164_aj);
            if (!(existingPositon.func_72438_d(newPosition) < (double)0.1f) || EnumFacing.func_82600_a((int)dir) != ((EntityHanging)e).field_174860_b) continue;
            return true;
        }
        return false;
    }
}

