/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.urbanism;

import buildcraft.BuildCraftCore;
import buildcraft.builders.urbanism.AnchoredBox;
import buildcraft.builders.urbanism.EntityUrbanist;
import buildcraft.core.Box;
import buildcraft.core.internal.IBoxesProvider;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.network.base.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.relauncher.Side;

public class TileUrbanist
extends TileBuildCraft
implements IInventory,
IBoxesProvider,
ICommandReceiver {
    public EntityUrbanist urbanist;
    public ArrayList<AnchoredBox> frames = new ArrayList();
    private Entity player;
    private int thirdPersonView = 0;
    private double posX;
    private double posY;
    private double posZ;
    private float yaw;
    private int p2x = 0;
    private int p2y = 0;
    private int p2z = 0;
    private boolean isCreatingFrame = false;

    public void createUrbanistEntity() {
        if (this.field_145850_b.field_72995_K && this.urbanist == null) {
            this.urbanist = new EntityUrbanist(this.field_145850_b);
            this.field_145850_b.func_72838_d((Entity)this.urbanist);
            this.player = Minecraft.func_71410_x().func_175606_aa();
            this.urbanist.func_82149_j(this.player);
            this.urbanist.tile = this;
            this.urbanist.player = this.player;
            this.urbanist.field_70177_z = 0.0f;
            this.urbanist.field_70125_A = 0.0f;
            Minecraft.func_71410_x().func_175607_a((Entity)this.urbanist);
            this.thirdPersonView = Minecraft.func_71410_x().field_71474_y.field_74320_O;
            Minecraft.func_71410_x().field_71474_y.field_74320_O = 8;
            this.posX = this.urbanist.field_70165_t;
            this.posY = this.urbanist.field_70163_u + 10.0;
            this.posZ = this.urbanist.field_70161_v;
            this.yaw = 0.0f;
            this.urbanist.func_70080_a(this.posX, this.posY, this.posZ, this.yaw, 50.0f);
            this.urbanist.func_70634_a(this.posX, this.posY, this.posZ);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    private Packet createXYZPacket(String name, final BlockPos pos) {
        return new PacketCommand(this, name, new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeInt(pos.func_177958_n());
                data.writeShort(pos.func_177956_o());
                data.writeInt(pos.func_177952_p());
            }
        });
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isClient() && "setFrameKind".equals(command)) {
            this.setFrameKind(stream.readInt(), stream.readInt());
        } else if (side.isServer() && "startFiller".equals(command)) {
            String fillerTag = NetworkUtils.readUTF(stream);
            Box box = new Box();
            box.readData(stream);
            this.startFiller(fillerTag, box);
        } else {
            int x = stream.readInt();
            int y = stream.readInt();
            int z = stream.readInt();
            BlockPos pos = new BlockPos(x, y, z);
            if (side.isServer() && "setBlock".equals(command)) {
                this.field_145850_b.func_175656_a(pos, Blocks.field_150336_V.func_176223_P());
            } else if (!side.isServer() || !"eraseBlock".equals(command)) {
                if ("createFrame".equals(command)) {
                    this.createFrame(pos);
                } else if ("moveFrame".equals(command)) {
                    this.moveFrame(pos);
                }
            }
        }
    }

    public void rpcEraseBlock(BlockPos pos) {
        BuildCraftCore.instance.sendToServer(this.createXYZPacket("eraseBlock", pos));
    }

    public void createFrame(BlockPos pos) {
        this.isCreatingFrame = true;
        AnchoredBox a = new AnchoredBox();
        a.box = new Box(pos, pos.func_177981_b(2));
        a.x1 = pos.func_177958_n();
        a.y1 = pos.func_177956_o();
        a.z1 = pos.func_177952_p();
        this.frames.add(a);
    }

    public void rpcCreateFrame(BlockPos pos) {
        this.p2x = pos.func_177958_n();
        this.p2y = pos.func_177956_o();
        this.p2z = pos.func_177952_p();
        this.createFrame(pos);
        BuildCraftCore.instance.sendToServer(this.createXYZPacket("createFrame", pos));
    }

    public void moveFrame(BlockPos pos) {
        if (this.isCreatingFrame && this.frames.size() > 0) {
            this.frames.get(this.frames.size() - 1).setP2(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public void rpcMoveFrame(BlockPos pos) {
        if (this.p2x != pos.func_177958_n() || this.p2y != pos.func_177956_o() || this.p2z != pos.func_177952_p()) {
            this.p2x = pos.func_177958_n();
            this.p2y = pos.func_177956_o();
            this.p2z = pos.func_177952_p();
            this.moveFrame(pos);
            BuildCraftCore.instance.sendToServer(this.createXYZPacket("moveFrame", pos));
        }
    }

    public void setFrameKind(int id, int kind) {
        AnchoredBox b;
        if (id < this.frames.size() && (b = this.frames.get(id)) != null) {
            b.box.kind = Box.Kind.values()[kind];
        }
    }

    public void startFiller(String fillerTag, Box box) {
    }

    public void rpcStartFiller(final String fillerTag, final Box box) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "startFiller", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                NetworkUtils.writeUTF(data, fillerTag);
                box.writeData(data);
            }
        }));
    }

    public void destroyUrbanistEntity() {
        Minecraft.func_71410_x().func_175607_a(this.player);
        Minecraft.func_71410_x().field_71474_y.field_74320_O = this.thirdPersonView;
        this.field_145850_b.func_72900_e((Entity)this.urbanist);
        this.urbanist.func_70106_y();
        this.urbanist = null;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int var1) {
        return null;
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
    }

    @Override
    public String getInventoryName() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box box = new Box(this);
        for (AnchoredBox b : this.frames) {
            box.extendToEncompass(b.box);
        }
        return box.getBoundingBox();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("nbFrames", this.frames.size());
        for (int i = 0; i < this.frames.size(); ++i) {
            NBTTagCompound cpt = new NBTTagCompound();
            this.frames.get(i).writeToNBT(cpt);
            nbt.func_74782_a("frame[" + i + "]", (NBTBase)cpt);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.frames.clear();
        int size = nbt.func_74762_e("nbFrames");
        for (int i = 0; i < size; ++i) {
            AnchoredBox b = new AnchoredBox();
            b.readFromNBT(nbt.func_74775_l("frame[" + i + "]"));
            this.frames.add(b);
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeShort(this.frames.size());
        for (AnchoredBox b : this.frames) {
            b.writeData(stream);
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        this.frames.clear();
        int size = stream.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            AnchoredBox b = new AnchoredBox();
            b.readData(stream);
            this.frames.add(b);
        }
    }

    public ArrayList<Box> getBoxes() {
        ArrayList<Box> result = new ArrayList<Box>();
        for (AnchoredBox b : this.frames) {
            result.add(b.box);
        }
        return result;
    }

    public class FrameTask {
        int nbOfTasks;
        AnchoredBox frame;

        public void taskDone() {
            --this.nbOfTasks;
            if (this.nbOfTasks <= 0) {
                TileUrbanist.this.frames.remove(this.frame);
            }
        }
    }
}

