/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.core.BCRegistry;
import buildcraft.core.lib.engines.BlockEngineBase;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.utils.IModelRegister;
import buildcraft.core.lib.utils.ModelHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockEngine
extends BlockEngineBase
implements IModelRegister {
    private final Class<? extends TileEngineBase>[] engineTiles;
    private final String[] names;

    public BlockEngine() {
        this.func_149663_c("engineBlock");
        this.engineTiles = new Class[16];
        this.names = new String[16];
    }

    @Override
    public String getUnlocalizedName(int metadata) {
        return this.names[metadata] != null ? this.names[metadata] : "unknown";
    }

    public void registerTile(Class<? extends TileEngineBase> engineTile, int meta, String name) {
        if (BCRegistry.INSTANCE.isEnabled("engines", name)) {
            this.engineTiles[meta] = engineTile;
            this.names[meta] = name;
        }
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        try {
            return this.engineTiles[metadata].newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        int i = 0;
        for (String name : this.names) {
            if (name != null) {
                itemList.add(new ItemStack((Block)this, 1, i));
            }
            ++i;
        }
    }

    public boolean hasEngine(int meta) {
        return this.engineTiles[meta] != null;
    }

    @Override
    public void registerModels() {
        Item item = ItemBlock.func_150898_a((Block)this);
        ModelHelper.registerItemModel(item, 0, "_wood");
        ModelHelper.registerItemModel(item, 1, "_stone");
        ModelHelper.registerItemModel(item, 2, "_iron");
        ModelHelper.registerItemModel(item, 3, "_creative");
    }

    @Override
    public double getBreathingCoefficent() {
        return 1.0;
    }
}

