/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.core.LaserData;
import buildcraft.core.LaserKind;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityLaser
extends Entity {
    public static final ResourceLocation LASER_RED = new ResourceLocation("buildcraftcore:textures/lasers/red.png");
    public static final ResourceLocation LASER_YELLOW = new ResourceLocation("buildcraftcore:textures/lasers/yellow.png");
    public static final ResourceLocation LASER_GREEN = new ResourceLocation("buildcraftcore:textures/lasers/green.png");
    public static final ResourceLocation LASER_BLUE = new ResourceLocation("buildcraftcore:textures/lasers/blue.png");
    public static final ResourceLocation LASER_STRIPES_BLUE = new ResourceLocation("buildcraftcore:textures/lasers/stripes_blue.png");
    public static final ResourceLocation LASER_STRIPES_YELLOW = new ResourceLocation("buildcraftcore:textures/lasers/stripes_yellow.png");
    private static final int NETWORK_HEAD_X = 8;
    private static final int NETWORK_HEAD_Y = 9;
    private static final int NETWORK_HEAD_Z = 10;
    private static final int NETWORK_TAIL_X = 11;
    private static final int NETWORK_TAIL_Y = 12;
    private static final int NETWORK_TAIL_Z = 13;
    private static final int NETWORK_VISIBLE = 14;
    public final LaserData data = new LaserData();
    protected boolean needsUpdate = true;
    private final ResourceLocation laserTexture;

    public static ResourceLocation getTextureFromLaserKind(LaserKind kind) {
        switch (kind) {
            case Blue: {
                return LASER_BLUE;
            }
            case Red: {
                return LASER_RED;
            }
            case Stripes: {
                return LASER_STRIPES_YELLOW;
            }
        }
        return LASER_STRIPES_BLUE;
    }

    public EntityLaser(World world) {
        this(world, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0));
    }

    public EntityLaser(World world, Vec3 head, Vec3 tail) {
        this(world, head, tail, LASER_RED);
    }

    public EntityLaser(World world, Vec3 head, Vec3 tail, LaserKind kind) {
        this(world, head, tail, EntityLaser.getTextureFromLaserKind(kind));
    }

    public EntityLaser(World world, Vec3 head, Vec3 tail, ResourceLocation laserTexture) {
        super(world);
        this.data.head = head;
        this.data.tail = tail;
        this.func_70080_a(head.field_72450_a, head.field_72448_b, head.field_72449_c, 0.0f, 0.0f);
        this.func_70105_a(10.0f, 10.0f);
        this.laserTexture = laserTexture;
        this.updateDataServer();
    }

    protected void func_70088_a() {
        this.field_70156_m = false;
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.field_70180_af.func_75682_a(8, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(9, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(10, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(11, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(12, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(13, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(14, (Object)0);
    }

    public void func_70071_h_() {
        if (this.data.head == null || this.data.tail == null) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.needsUpdate) {
            this.updateDataServer();
            this.needsUpdate = false;
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateDataClient();
        }
        this.func_174826_a(new AxisAlignedBB(Math.min(this.data.head.field_72450_a, this.data.tail.field_72450_a), Math.min(this.data.head.field_72448_b, this.data.tail.field_72448_b) - 1.0, Math.min(this.data.head.field_72449_c, this.data.tail.field_72449_c) - 1.0, Math.max(this.data.head.field_72450_a, this.data.tail.field_72450_a) + 1.0, Math.max(this.data.head.field_72448_b, this.data.tail.field_72448_b) + 1.0, Math.max(this.data.head.field_72449_c, this.data.tail.field_72449_c) + 1.0));
        this.data.update();
    }

    protected void updateDataClient() {
        this.data.isVisible = this.field_70180_af.func_75683_a(14) == 1;
    }

    protected void updateDataServer() {
        this.field_70180_af.func_75692_b(8, (Object)Float.valueOf((float)this.data.head.field_72450_a));
        this.field_70180_af.func_75692_b(9, (Object)Float.valueOf((float)this.data.head.field_72448_b));
        this.field_70180_af.func_75692_b(10, (Object)Float.valueOf((float)this.data.head.field_72449_c));
        this.field_70180_af.func_75692_b(11, (Object)Float.valueOf((float)this.data.tail.field_72450_a));
        this.field_70180_af.func_75692_b(12, (Object)Float.valueOf((float)this.data.tail.field_72448_b));
        this.field_70180_af.func_75692_b(13, (Object)Float.valueOf((float)this.data.tail.field_72449_c));
        this.field_70180_af.func_75692_b(14, (Object)((byte)(this.data.isVisible ? 1 : 0)));
    }

    public void setPositions(Vec3 head, Vec3 tail) {
        this.data.head = head;
        this.data.tail = tail;
        this.func_70080_a(head.field_72450_a, head.field_72448_b, head.field_72449_c, 0.0f, 0.0f);
        this.needsUpdate = true;
    }

    public void show() {
        this.data.isVisible = true;
        this.needsUpdate = true;
    }

    public void hide() {
        this.data.isVisible = false;
        this.needsUpdate = true;
    }

    public boolean isVisible() {
        return this.data.isVisible;
    }

    public ResourceLocation getTexture() {
        return this.laserTexture;
    }

    protected double decodeDouble(float i) {
        return i;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        double headX = nbt.func_74769_h("headX");
        double headY = nbt.func_74769_h("headZ");
        double headZ = nbt.func_74769_h("headY");
        this.data.head = new Vec3(headX, headY, headZ);
        double tailX = nbt.func_74769_h("tailX");
        double tailY = nbt.func_74769_h("tailZ");
        double tailZ = nbt.func_74769_h("tailY");
        this.data.tail = new Vec3(tailX, tailY, tailZ);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74780_a("headX", this.data.head.field_72450_a);
        nbt.func_74780_a("headY", this.data.head.field_72448_b);
        nbt.func_74780_a("headZ", this.data.head.field_72449_c);
        nbt.func_74780_a("tailX", this.data.tail.field_72450_a);
        nbt.func_74780_a("tailY", this.data.tail.field_72448_b);
        nbt.func_74780_a("tailZ", this.data.tail.field_72449_c);
    }

    public Vec3 renderOffset() {
        return new Vec3(0.5, 0.5, 0.5);
    }

    public int func_70070_b(float par1) {
        return 210;
    }
}

