/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.blocks.IColorRemovable;
import buildcraft.api.core.EnumColor;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.ModelHelper;
import buildcraft.core.lib.utils.NBTUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPaintbrush
extends ItemBuildCraft {
    private static final int MAX_DAMAGE = 63;

    public ItemPaintbrush() {
        this.func_77664_n();
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(63);
    }

    public ItemStack getItemStack(EnumDyeColor color) {
        ItemStack stack = new ItemStack((Item)this, 1, color == null ? 0 : color.ordinal() + 1);
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        nbt.func_74757_a("Unbreakable", true);
        nbt.func_74768_a("HideFlags", 4);
        return stack;
    }

    private int getColor(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta < 1 || meta > 16) {
            return -1;
        }
        return meta - 1;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage > 63) {
            stack.func_77982_d(null);
            super.setDamage(stack, 0);
        } else {
            NBTTagCompound tag = NBTUtils.getItemData(stack);
            tag.func_74774_a("damage", (byte)damage);
        }
    }

    public int getDamage(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return 0;
        }
        return nbt.func_74771_c("damage");
    }

    public int getMetadata(ItemStack stack) {
        return super.getDamage(stack);
    }

    public String func_77653_i(ItemStack stack) {
        String base = super.func_77653_i(stack);
        int dye = this.getColor(stack);
        if (dye >= 0) {
            return base + " (" + EnumColor.fromId(dye).getLocalizedName() + ")";
        }
        return base;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        int dye = this.getColor(stack);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == null) {
            return true;
        }
        if (dye >= 0) {
            if (block.recolorBlock(world, pos, side, EnumDyeColor.func_176764_b((int)(15 - dye)))) {
                player.func_71038_i();
                this.setDamage(stack, this.getDamage(stack) + 1);
                return true;
            }
        } else if (block instanceof IColorRemovable && ((IColorRemovable)block).removeColorFromBlock(world, pos, side)) {
            player.func_71038_i();
            return !world.field_72995_K;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> itemList) {
        for (int i = 0; i < 17; ++i) {
            EnumDyeColor color = i == 0 ? null : EnumDyeColor.values()[i - 1];
            itemList.add(this.getItemStack(color));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return false;
        }
        return nbt.func_74771_c("damage") > 0;
    }

    @Override
    public boolean doesSneakBypassUse(World world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public void registerModels() {
        ModelHelper.registerItemModel(this, 0, "/clean");
        for (EnumDyeColor colour : EnumDyeColor.values()) {
            ModelHelper.registerItemModel(this, colour.func_176767_b() + 1, "/" + colour.func_176610_l());
        }
    }
}

