/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.ISerializable;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public class LaserData
implements ISerializable {
    public Vec3 head = new Vec3(0.0, 0.0, 0.0);
    public Vec3 tail = new Vec3(0.0, 0.0, 0.0);
    public boolean isVisible = true;
    public boolean isGlowing = false;
    public double renderSize = 0.0625;
    public double angleY = 0.0;
    public double angleZ = 0.0;
    public double wavePosition = 0.0;
    public int laserTexAnimation = 0;
    public float waveSize = 1.0f;

    public LaserData() {
    }

    public LaserData(Vec3 tail, Vec3 head) {
        this.tail = tail;
        this.head = head;
    }

    public void update() {
        Vec3 delta = this.head.func_178788_d(this.tail);
        double dx = delta.field_72450_a;
        double dy = delta.field_72448_b;
        double dz = delta.field_72449_c;
        this.renderSize = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.angleZ = 360.0 - (Math.atan2(dz, dx) * 180.0 / Math.PI + 180.0);
        dx = Math.sqrt(this.renderSize * this.renderSize - dy * dy);
        this.angleY = -Math.atan2(dy, dx) * 180.0 / Math.PI;
    }

    public void iterateTexture() {
        this.laserTexAnimation = (this.laserTexAnimation + 1) % 40;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("head", (NBTBase)NBTUtils.writeVec3(this.head));
        nbt.func_74782_a("tail", (NBTBase)NBTUtils.writeVec3(this.tail));
        nbt.func_74757_a("isVisible", this.isVisible);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.head = NBTUtils.readVec3(nbt, "head");
        this.tail = NBTUtils.readVec3(nbt, "tail");
        this.isVisible = nbt.func_74767_n("isVisible");
    }

    @Override
    public void readData(ByteBuf stream) {
        this.head = NetworkUtils.readVec3(stream);
        this.tail = NetworkUtils.readVec3(stream);
        short flags = stream.readUnsignedByte();
        this.isVisible = (flags & 1) != 0;
        this.isGlowing = (flags & 2) != 0;
    }

    @Override
    public void writeData(ByteBuf stream) {
        NetworkUtils.writeVec3(stream, this.head);
        NetworkUtils.writeVec3(stream, this.tail);
        int flags = (this.isVisible ? 1 : 0) | (this.isGlowing ? 2 : 0);
        stream.writeByte(flags);
    }
}

