/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.enums.EnumSpring;
import buildcraft.core.lib.block.BlockBuildCraftBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SpringPopulate {
    @SubscribeEvent
    public void populate(PopulateChunkEvent.Post event) {
        boolean doGen = TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkZ, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        if (!doGen || !EnumSpring.WATER.canGen) {
            event.setResult(Event.Result.ALLOW);
            return;
        }
        int worldX = event.chunkX << 4;
        int worldZ = event.chunkZ << 4;
        this.doPopulate(event.world, event.rand, worldX, worldZ);
    }

    private void doPopulate(World world, Random random, int x, int z) {
        int dimId = world.field_73011_w.func_177502_q();
        if (dimId == -1 || dimId == 1) {
            return;
        }
        if (random.nextFloat() > 0.025f) {
            return;
        }
        int posX = x + random.nextInt(16);
        int posZ = z + random.nextInt(16);
        for (int i = 0; i < 5; ++i) {
            BlockPos pos = new BlockPos(posX, i, posZ);
            Block candidate = world.func_180495_p(pos).func_177230_c();
            if (candidate != Blocks.field_150357_h) continue;
            int y = i > 0 ? i : i - 1;
            IBlockState springState = BuildCraftCore.springBlock.func_176223_P();
            springState = springState.func_177226_a(BlockBuildCraftBase.SPRING_TYPE, (Comparable)((Object)EnumSpring.WATER));
            world.func_175656_a(new BlockPos(posX, y, posZ), springState);
            for (int j = y + 2; j < world.func_72940_L() && !world.func_175623_d(new BlockPos(posX, j, posZ)); ++j) {
                world.func_175656_a(new BlockPos(posX, j, posZ), Blocks.field_150355_j.func_176223_P());
            }
            break;
        }
    }
}

