/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.BCLog;
import buildcraft.core.lib.network.base.PacketHandler;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum TickHandlerCore {
    INSTANCE;

    private static final List<PacketHandler> packetHandlers;

    public static void addPacketHandler(PacketHandler handler) {
        if (handler != null) {
            packetHandlers.add(handler);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            for (PacketHandler packetHandler : packetHandlers) {
                packetHandler.tick((World)world);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        for (PacketHandler packetHandler : packetHandlers) {
            packetHandler.tick(event.world);
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload unload) {
        BCLog.logger.info("World Unload event");
        for (PacketHandler packetHandler : packetHandlers) {
            packetHandler.unload(unload.world);
        }
    }

    static {
        packetHandlers = Lists.newCopyOnWriteArrayList();
    }
}

