/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.ISerializable;
import buildcraft.api.tiles.ITileAreaProvider;
import buildcraft.core.Box;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityLaser;
import buildcraft.core.LaserKind;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public class TileMarker
extends TileBuildCraft
implements ITileAreaProvider {
    public Origin origin = new Origin();
    public boolean showSignals = false;
    private Vec3 initVectO;
    private Vec3[] initVect;
    private EntityLaser[] lasers;
    private EntityLaser[] signals;

    public void updateSignals() {
        if (!this.field_145850_b.field_72995_K) {
            this.showSignals = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
            this.sendNetworkUpdate();
        }
    }

    private void switchSignals() {
        if (this.signals != null) {
            for (EntityLaser b : this.signals) {
                if (b == null) continue;
                CoreProxy.proxy.removeEntity(b);
            }
            this.signals = null;
        }
        if (this.showSignals) {
            this.signals = new EntityLaser[6];
            Vec3 cPos = Utils.convert((Vec3i)this.field_174879_c);
            int rangePlus = DefaultProps.MARKER_RANGE + 1;
            int rangeMinus = DefaultProps.MARKER_RANGE - 1;
            if (!this.origin.isSet() || !this.origin.vect[0].isSet()) {
                this.signals[0] = Utils.createLaser(this.field_145850_b, cPos, cPos.func_72441_c((double)rangeMinus, 0.0, 0.0), LaserKind.Blue);
                this.signals[1] = Utils.createLaser(this.field_145850_b, cPos.func_72441_c((double)(-rangePlus), 0.0, 0.0), cPos, LaserKind.Blue);
            }
            if (!this.origin.isSet() || !this.origin.vect[1].isSet()) {
                this.signals[2] = Utils.createLaser(this.field_145850_b, cPos, cPos.func_72441_c(0.0, (double)rangeMinus, 0.0), LaserKind.Blue);
                this.signals[3] = Utils.createLaser(this.field_145850_b, cPos.func_72441_c(0.0, (double)(-rangePlus), 0.0), cPos, LaserKind.Blue);
            }
            if (!this.origin.isSet() || !this.origin.vect[2].isSet()) {
                this.signals[4] = Utils.createLaser(this.field_145850_b, cPos, cPos.func_72441_c(0.0, 0.0, (double)rangeMinus), LaserKind.Blue);
                this.signals[5] = Utils.createLaser(this.field_145850_b, cPos.func_72441_c(0.0, 0.0, (double)(-rangePlus)), cPos, LaserKind.Blue);
            }
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateSignals();
        if (this.initVectO != null) {
            this.origin = new Origin();
            this.origin.vectO = new TileWrapper(Utils.convertFloor(this.initVectO));
            for (int i = 0; i < 3; ++i) {
                if (this.initVect[i] == null) continue;
                this.linkTo((TileMarker)this.field_145850_b.func_175625_s(Utils.convertFloor(this.initVect[i])), i);
            }
        }
    }

    public void tryConnection() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (int j = 0; j < 3; ++j) {
            if (this.origin.isSet() && this.origin.vect[j].isSet()) continue;
            this.setVect(j);
        }
        this.sendNetworkUpdate();
    }

    void setVect(int n) {
        int[] coords = new int[]{this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()};
        BlockPos coord = this.field_174879_c;
        if (!this.origin.isSet() || !this.origin.vect[n].isSet()) {
            for (int j = 1; j < DefaultProps.MARKER_RANGE; ++j) {
                int n2 = n;
                coords[n2] = coords[n2] + j;
                coord = new BlockPos(coords[0], coords[1], coords[2]);
                TileEntity tile = this.field_145850_b.func_175625_s(coord);
                if (tile instanceof TileMarker && this.linkTo((TileMarker)tile, n)) break;
                int n3 = n;
                coords[n3] = coords[n3] - j;
                int n4 = n;
                coords[n4] = coords[n4] - j;
                coord = new BlockPos(coords[0], coords[1], coords[2]);
                tile = this.field_145850_b.func_175625_s(coord);
                if (tile instanceof TileMarker && this.linkTo((TileMarker)tile, n)) break;
                int n5 = n;
                coords[n5] = coords[n5] + j;
            }
        }
    }

    private boolean linkTo(TileMarker marker, int n) {
        if (marker == null) {
            return false;
        }
        if (this.origin.isSet() && marker.origin.isSet()) {
            return false;
        }
        if (!this.origin.isSet() && !marker.origin.isSet()) {
            marker.origin = this.origin = new Origin();
            this.origin.vectO = new TileWrapper(this.field_174879_c);
            this.origin.vect[n] = new TileWrapper(marker.field_174879_c);
        } else if (!this.origin.isSet()) {
            this.origin = marker.origin;
            this.origin.vect[n] = new TileWrapper(this.field_174879_c);
        } else {
            marker.origin = this.origin;
            this.origin.vect[n] = new TileWrapper(marker.field_174879_c);
        }
        this.origin.vectO.getMarker(this.field_145850_b).createLasers();
        this.updateSignals();
        marker.updateSignals();
        return true;
    }

    private void createLasers() {
        if (this.lasers != null) {
            for (EntityLaser entity : this.lasers) {
                if (entity == null) continue;
                CoreProxy.proxy.removeEntity(entity);
            }
        }
        this.lasers = new EntityLaser[12];
        Origin o = this.origin;
        if (!this.origin.vect[0].isSet()) {
            o.xMin = this.origin.vectO.x;
            o.xMax = this.origin.vectO.x;
        } else if (this.origin.vect[0].x < this.field_174879_c.func_177958_n()) {
            o.xMin = this.origin.vect[0].x;
            o.xMax = this.field_174879_c.func_177958_n();
        } else {
            o.xMin = this.field_174879_c.func_177958_n();
            o.xMax = this.origin.vect[0].x;
        }
        if (!this.origin.vect[1].isSet()) {
            o.yMin = this.origin.vectO.y;
            o.yMax = this.origin.vectO.y;
        } else if (this.origin.vect[1].y < this.field_174879_c.func_177956_o()) {
            o.yMin = this.origin.vect[1].y;
            o.yMax = this.field_174879_c.func_177956_o();
        } else {
            o.yMin = this.field_174879_c.func_177956_o();
            o.yMax = this.origin.vect[1].y;
        }
        if (!this.origin.vect[2].isSet()) {
            o.zMin = this.origin.vectO.z;
            o.zMax = this.origin.vectO.z;
        } else if (this.origin.vect[2].z < this.field_174879_c.func_177952_p()) {
            o.zMin = this.origin.vect[2].z;
            o.zMax = this.field_174879_c.func_177952_p();
        } else {
            o.zMin = this.field_174879_c.func_177952_p();
            o.zMax = this.origin.vect[2].z;
        }
        this.lasers = Utils.createLaserBox(this.field_145850_b, o.xMin, o.yMin, o.zMin, o.xMax, o.yMax, o.zMax, LaserKind.Red);
    }

    @Override
    public BlockPos min() {
        if (this.origin.isSet()) {
            return this.origin.min();
        }
        return this.field_174879_c;
    }

    @Override
    public BlockPos max() {
        if (this.origin.isSet()) {
            return this.origin.max();
        }
        return this.field_174879_c;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    @Override
    public void destroy() {
        TileMarker markerOrigin = null;
        if (this.origin.isSet()) {
            TileMarker mark;
            markerOrigin = this.origin.vectO.getMarker(this.field_145850_b);
            Origin o = this.origin;
            if (markerOrigin != null && markerOrigin.lasers != null) {
                for (EntityLaser entityLaser : markerOrigin.lasers) {
                    if (entityLaser == null) continue;
                    entityLaser.func_70106_y();
                }
                markerOrigin.lasers = null;
            }
            for (TileWrapper tileWrapper : o.vect) {
                mark = tileWrapper.getMarker(this.field_145850_b);
                if (mark == null) continue;
                if (mark.lasers != null) {
                    for (EntityLaser entity : mark.lasers) {
                        if (entity == null) continue;
                        entity.func_70106_y();
                    }
                    mark.lasers = null;
                }
                if (mark == this) continue;
                mark.origin = new Origin();
            }
            if (markerOrigin != this && markerOrigin != null) {
                markerOrigin.origin = new Origin();
            }
            TileWrapper[] tileWrapperArray = o.vect;
            int n = tileWrapperArray.length;
            for (int i = 0; i < n; ++i) {
                TileWrapper tileWrapper = tileWrapperArray[i];
                mark = tileWrapper.getMarker(this.field_145850_b);
                if (mark == null) continue;
                mark.updateSignals();
            }
            if (markerOrigin != null) {
                markerOrigin.updateSignals();
            }
        }
        if (this.signals != null) {
            for (EntityLaser block : this.signals) {
                if (block == null) continue;
                block.func_70106_y();
            }
        }
        this.signals = null;
        if (!this.field_145850_b.field_72995_K && markerOrigin != null && markerOrigin != this) {
            markerOrigin.sendNetworkUpdate();
        }
    }

    @Override
    public void removeFromWorld() {
        if (!this.origin.isSet()) {
            return;
        }
        Origin o = this.origin;
        for (TileWrapper m : (TileWrapper[])o.vect.clone()) {
            if (!m.isSet()) continue;
            IBlockState state = this.field_145850_b.func_180495_p(m.getPos());
            this.field_145850_b.func_175698_g(m.getPos());
            BuildCraftCore.markerBlock.func_176226_b(this.field_145850_b, m.getPos(), state, 0);
        }
        IBlockState state = this.field_145850_b.func_180495_p(o.vectO.getPos());
        this.field_145850_b.func_175698_g(o.vectO.getPos());
        BuildCraftCore.markerBlock.func_176226_b(this.field_145850_b, o.vectO.getPos(), state, 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("vectO")) {
            this.initVectO = NBTUtils.readVec3(nbttagcompound, "vectO");
            this.initVect = new Vec3[3];
            for (int i = 0; i < 3; ++i) {
                if (!nbttagcompound.func_74764_b("vect" + i)) continue;
                this.initVect[i] = NBTUtils.readVec3(nbttagcompound, "vect" + i);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.origin.isSet() && this.origin.vectO.getMarker(this.field_145850_b) == this) {
            nbt.func_74782_a("vectO", (NBTBase)NBTUtils.writeVec3(Utils.convert((Vec3i)this.origin.vectO.getMarker((World)this.field_145850_b).field_174879_c)));
            for (int i = 0; i < 3; ++i) {
                if (!this.origin.vect[i].isSet()) continue;
                nbt.func_74782_a("vect" + i, (NBTBase)NBTUtils.writeVec3(Utils.convert((Vec3i)this.origin.vect[i].getPos())));
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        this.origin.writeData(stream);
        stream.writeBoolean(this.showSignals);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.origin.readData(stream);
        this.showSignals = stream.readBoolean();
        this.switchSignals();
        if (this.origin.vectO.isSet() && this.origin.vectO.getMarker(this.field_145850_b) != null) {
            this.origin.vectO.getMarker(this.field_145850_b).updateSignals();
            for (TileWrapper w : this.origin.vect) {
                TileMarker m = w.getMarker(this.field_145850_b);
                if (m == null) continue;
                m.updateSignals();
            }
        }
        this.createLasers();
    }

    @Override
    public boolean isValidFromLocation(BlockPos pos) {
        int equal = (pos.func_177958_n() == this.field_174879_c.func_177958_n() ? 1 : 0) + (pos.func_177956_o() == this.field_174879_c.func_177956_o() ? 1 : 0) + (pos.func_177952_p() == this.field_174879_c.func_177952_p() ? 1 : 0);
        boolean touching = false;
        if (equal == 0 || equal == 3) {
            return false;
        }
        Box box = new Box(this.min(), this.max());
        if (box.contains(pos)) {
            return false;
        }
        return box.distanceToSquared(pos) == 1.0;
    }

    public static class Origin
    implements ISerializable {
        public TileWrapper vectO = new TileWrapper();
        public TileWrapper[] vect = new TileWrapper[]{new TileWrapper(), new TileWrapper(), new TileWrapper()};
        public int xMin;
        public int yMin;
        public int zMin;
        public int xMax;
        public int yMax;
        public int zMax;

        public boolean isSet() {
            return this.vectO.isSet();
        }

        @Override
        public void writeData(ByteBuf stream) {
            this.vectO.writeData(stream);
            for (TileWrapper tw : this.vect) {
                tw.writeData(stream);
            }
            stream.writeInt(this.xMin);
            stream.writeShort(this.yMin);
            stream.writeInt(this.zMin);
            stream.writeInt(this.xMax);
            stream.writeShort(this.yMax);
            stream.writeInt(this.zMax);
        }

        @Override
        public void readData(ByteBuf stream) {
            this.vectO.readData(stream);
            for (TileWrapper tw : this.vect) {
                tw.readData(stream);
            }
            this.xMin = stream.readInt();
            this.yMin = stream.readShort();
            this.zMin = stream.readInt();
            this.xMax = stream.readInt();
            this.yMax = stream.readShort();
            this.zMax = stream.readInt();
        }

        public BlockPos min() {
            return new BlockPos(this.xMin, this.yMin, this.zMin);
        }

        public BlockPos max() {
            return new BlockPos(this.xMax, this.yMax, this.zMax);
        }
    }

    public static class TileWrapper
    implements ISerializable {
        public int x;
        public int y;
        public int z;
        private TileMarker marker;

        public TileWrapper() {
            this.x = Integer.MAX_VALUE;
            this.y = Integer.MAX_VALUE;
            this.z = Integer.MAX_VALUE;
        }

        public TileWrapper(BlockPos pos) {
            this.x = pos.func_177958_n();
            this.y = pos.func_177956_o();
            this.z = pos.func_177952_p();
        }

        public boolean isSet() {
            return this.x != Integer.MAX_VALUE;
        }

        public TileMarker getMarker(World world) {
            TileEntity tile;
            if (!this.isSet()) {
                return null;
            }
            if (this.marker == null && (tile = world.func_175625_s(new BlockPos(this.x, this.y, this.z))) instanceof TileMarker) {
                this.marker = (TileMarker)tile;
            }
            return this.marker;
        }

        public void reset() {
            this.x = Integer.MAX_VALUE;
            this.y = Integer.MAX_VALUE;
            this.z = Integer.MAX_VALUE;
        }

        @Override
        public void readData(ByteBuf stream) {
            this.x = stream.readInt();
            if (this.isSet()) {
                this.y = stream.readShort();
                this.z = stream.readInt();
            }
        }

        @Override
        public void writeData(ByteBuf stream) {
            stream.writeInt(this.x);
            if (this.isSet()) {
                stream.writeShort(this.y);
                stream.writeInt(this.z);
            }
        }

        public BlockPos getPos() {
            return new BlockPos(this.x, this.y, this.z);
        }
    }
}

