/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.BuildCraftCore;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.IAreaProvider;
import buildcraft.core.Box;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.lib.utils.BitSetUtils;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import java.util.BitSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.Level;

public abstract class BptBuilderBase
implements IAreaProvider {
    public BlueprintBase blueprint;
    public BptContext context;
    protected BitSet usedLocations;
    protected boolean done;
    protected BlockPos pos;
    protected boolean initialized = false;
    private long nextBuildDate = 0L;
    private Utils.AxisOrder order;

    public BptBuilderBase(BlueprintBase bluePrint, World world, BlockPos pos) {
        this.order = Utils.EnumAxisOrder.XZY.defaultOrder;
        this.blueprint = bluePrint;
        this.pos = pos;
        this.usedLocations = new BitSet(bluePrint.size.func_177958_n() * bluePrint.size.func_177956_o() * bluePrint.size.func_177952_p());
        this.done = false;
        Box box = new Box();
        box.initialize(this);
        this.context = bluePrint.getContext(world, box);
    }

    public void setOrder(Utils.AxisOrder order) {
        if (order != null) {
            this.order = order;
        }
    }

    public Utils.AxisOrder getOrder() {
        return this.order;
    }

    @Deprecated
    protected boolean isLocationUsed(int x, int y, int z) {
        return this.isLocationUsed(new BlockPos(x, y, z));
    }

    private int locationIndex(BlockPos worldCoord) {
        BlockPos coord = worldCoord.func_177973_b((Vec3i)this.pos).func_177971_a((Vec3i)this.blueprint.anchor);
        return (coord.func_177952_p() * this.blueprint.size.func_177956_o() + coord.func_177956_o()) * this.blueprint.size.func_177958_n() + coord.func_177952_p();
    }

    protected boolean isLocationUsed(BlockPos toTest) {
        return this.usedLocations.get(this.locationIndex(toTest));
    }

    protected void markLocationUsed(BlockPos toMark) {
        this.usedLocations.set(this.locationIndex(toMark), true);
    }

    public void initialize() {
        if (!this.initialized) {
            this.internalInit();
            this.initialized = true;
        }
    }

    protected abstract void internalInit();

    protected abstract BuildingSlot reserveNextBlock(World var1);

    protected abstract BuildingSlot getNextBlock(World var1, TileAbstractBuilder var2);

    public boolean buildNextSlot(World world, TileAbstractBuilder builder) {
        return this.buildNextSlot(world, builder, Utils.convert((Vec3i)builder.func_174877_v()).func_178787_e(Utils.VEC_HALF));
    }

    public boolean buildNextSlot(World world, TileAbstractBuilder builder, Vec3 origin) {
        this.initialize();
        if (world.func_82737_E() < this.nextBuildDate) {
            return false;
        }
        BuildingSlot slot = this.getNextBlock(world, builder);
        if (this.buildSlot(world, builder, slot, origin)) {
            this.nextBuildDate = world.func_82737_E() + (long)slot.buildTime();
            return true;
        }
        return false;
    }

    public boolean buildSlot(World world, IBuildingItemsProvider builder, BuildingSlot slot, Vec3 from) {
        this.initialize();
        if (slot != null) {
            slot.built = true;
            BuildingItem i = new BuildingItem();
            i.origin = from;
            i.destination = slot.getDestination();
            i.slotToBuild = slot;
            i.context = this.getContext();
            i.setStacksToDisplay(slot.getStacksToDisplay());
            builder.addAndLaunchBuildingItem(i);
            return true;
        }
        return false;
    }

    public BuildingSlot reserveNextSlot(World world) {
        this.initialize();
        return this.reserveNextBlock(world);
    }

    @Override
    public BlockPos min() {
        return this.pos.func_177973_b((Vec3i)this.blueprint.anchor);
    }

    @Override
    public BlockPos max() {
        return this.pos.func_177971_a((Vec3i)this.blueprint.size).func_177973_b((Vec3i)this.blueprint.anchor).func_177973_b((Vec3i)Utils.POS_ONE);
    }

    @Override
    public void removeFromWorld() {
    }

    public AxisAlignedBB getBoundingBox() {
        return new AxisAlignedBB(this.min(), this.max());
    }

    public void postProcessing(World world) {
    }

    public BptContext getContext() {
        return this.context;
    }

    public boolean isDone(IBuildingItemsProvider builder) {
        return this.done && builder.getBuilders().size() == 0;
    }

    private int getBlockBreakEnergy(BuildingSlotBlock slot) {
        return BlockUtils.computeBlockBreakEnergy(this.context.world(), slot.pos);
    }

    protected final boolean canDestroy(TileAbstractBuilder builder, IBuilderContext context, BuildingSlotBlock slot) {
        return builder.energyAvailable() >= this.getBlockBreakEnergy(slot);
    }

    public void consumeEnergyToDestroy(TileAbstractBuilder builder, BuildingSlotBlock slot) {
        builder.consumeEnergy(this.getBlockBreakEnergy(slot));
    }

    public void createDestroyItems(BuildingSlotBlock slot) {
        int hardness = (int)Math.ceil((double)this.getBlockBreakEnergy(slot) / 160.0);
        for (int i = 0; i < hardness; ++i) {
            slot.addStackConsumed(new ItemStack((Block)BuildCraftCore.decoratedBlock));
        }
    }

    public void useRequirements(IInventory inv, BuildingSlot slot) {
    }

    public void saveBuildStateToNBT(NBTTagCompound nbt, IBuildingItemsProvider builder) {
        nbt.func_74773_a("usedLocationList", BitSetUtils.toByteArray(this.usedLocations));
        NBTTagList buildingList = new NBTTagList();
        for (BuildingItem item : builder.getBuilders()) {
            NBTTagCompound sub = new NBTTagCompound();
            item.writeToNBT(sub);
            buildingList.func_74742_a((NBTBase)sub);
        }
        nbt.func_74782_a("buildersInAction", (NBTBase)buildingList);
    }

    public void loadBuildStateToNBT(NBTTagCompound nbt, IBuildingItemsProvider builder) {
        BlockPos o;
        NBTBase cpt;
        if (nbt.func_74764_b("usedLocationList")) {
            this.usedLocations = BitSetUtils.fromByteArray(nbt.func_74770_j("usedLocationList"));
        }
        NBTTagList buildingList = nbt.func_150295_c("buildersInAction", 10);
        for (int i = 0; i < buildingList.func_74745_c(); ++i) {
            BuildingItem item = new BuildingItem();
            try {
                item.readFromNBT(buildingList.func_150305_b(i));
                item.context = this.getContext();
                builder.getBuilders().add(item);
                continue;
            }
            catch (MappingNotFoundException e) {
                BCLog.logger.log(Level.WARN, "can't load building item", (Throwable)e);
            }
        }
        if (nbt.func_74764_b("clearList")) {
            NBTTagList clearList = nbt.func_150295_c("clearList", 10);
            for (int i = 0; i < clearList.func_74745_c(); ++i) {
                cpt = clearList.func_179238_g(i);
                o = NBTUtils.readBlockPos(cpt);
                this.markLocationUsed(o);
            }
        }
        if (nbt.func_74764_b("builtList")) {
            NBTTagList builtList = nbt.func_150295_c("builtList", 10);
            for (int i = 0; i < builtList.func_74745_c(); ++i) {
                cpt = builtList.func_179238_g(i);
                o = NBTUtils.readBlockPos(cpt);
                this.markLocationUsed(o);
            }
        }
    }

    protected boolean isBlockBreakCanceled(World world, BlockPos pos) {
        if (!world.func_175623_d(pos)) {
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)world).get());
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            return breakEvent.isCanceled();
        }
        return false;
    }

    protected boolean isBlockPlaceCanceled(World world, BlockPos pos, SchematicBlockBase schematic) {
        IBlockState state = schematic instanceof SchematicBlock ? ((SchematicBlock)schematic).state : Blocks.field_150348_b.func_176223_P();
        EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)world, pos).get();
        BlockEvent.PlaceEvent placeEvent = new BlockEvent.PlaceEvent(new BlockSnapshot(world, pos, state), Blocks.field_150350_a.func_176223_P(), player);
        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
        return placeEvent.isCanceled();
    }

    public String toString() {
        return "BptBuilderBase [blueprint=" + this.blueprint + ", context=" + this.context + ", usedLocations=" + this.usedLocations + ", done=" + this.done + ", pos=" + this.pos + ", initialized=" + this.initialized + ", nextBuildDate=" + this.nextBuildDate + "]";
    }
}

