/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;

public class Template
extends BlueprintBase {
    public Template() {
        this.id.extension = "tpl";
    }

    public Template(BlockPos size) {
        super(size);
        this.id.extension = "tpl";
    }

    @Override
    public void readFromWorld(IBuilderContext context, TileEntity anchorTile, BlockPos pos) {
        Vec3 nPos = Utils.convert((Vec3i)pos).func_178788_d(Utils.convert((Vec3i)context.surroundingBox().min()));
        if (!BuildCraftAPI.isSoftBlock(anchorTile.func_145831_w(), pos)) {
            this.set(Utils.convertFloor(nPos), new SchematicMask(true));
        }
    }

    @Override
    public void saveContents(NBTTagCompound nbt) {
        byte[] data = new byte[this.size.func_177958_n() * this.size.func_177956_o() * this.size.func_177952_p()];
        int ind = 0;
        for (int x = 0; x < this.size.func_177958_n(); ++x) {
            for (int y = 0; y < this.size.func_177956_o(); ++y) {
                for (int z = 0; z < this.size.func_177952_p(); ++z) {
                    data[ind] = (byte)(this.get(new BlockPos(x, y, z)) != null ? 1 : 0);
                    ++ind;
                }
            }
        }
        nbt.func_74773_a("mask", data);
    }

    @Override
    public void loadContents(NBTTagCompound nbt) throws BptError {
        byte[] data = nbt.func_74770_j("mask");
        int ind = 0;
        BCLog.logger.info("size = " + this.size);
        for (int x = 0; x < this.size.func_177958_n(); ++x) {
            for (int y = 0; y < this.size.func_177956_o(); ++y) {
                for (int z = 0; z < this.size.func_177952_p(); ++z) {
                    if (data[ind] == 1) {
                        this.set(new BlockPos(x, y, z), new SchematicMask(true));
                    }
                    ++ind;
                }
            }
        }
    }

    @Override
    public ItemStack getStack() {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("BuildCraft|Builders:templateItem"));
        if (item == null) {
            throw new Error("Could not find the template item! Did you attempt to use this without buildcraft builders installed?");
        }
        ItemStack stack = new ItemStack(item, 1, 1);
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        this.id.write(nbt);
        nbt.func_74778_a("author", this.author);
        nbt.func_74778_a("name", this.id.name);
        return stack;
    }
}

