/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints.iterator;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.core.Box;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.iterator.BuildRequirement;
import buildcraft.core.blueprints.iterator.BuildingSlotPostProcess;
import buildcraft.core.blueprints.iterator.IBptBuilder;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.BuildingSlotEntity;
import buildcraft.core.lib.utils.Utils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;

public class BptBuilderRandomAccess
implements IBptBuilder {
    private final BlueprintBase blueprint;
    private final IBuilderContext context;
    private final BlockPos worldOffset;
    private final Box worldOperatingBox;
    private boolean hasInitBlocks = false;
    private boolean hasInitEntities = false;
    private BlockPos initPos;
    private Utils.BoxIterator iterator;
    private Map<BlockPos, BuildRequirement> neededRequirements = Maps.newHashMap();
    private Map<BlockPos, BuildRequirement> reservedRequirements = Maps.newHashMap();
    private Map<BlockPos, BuildingSlotPostProcess> postProcessing = Maps.newHashMap();
    private Multimap<BlockPos, BuildingSlotEntity> entities = HashMultimap.create();

    public BptBuilderRandomAccess(BlueprintBase blueprint, BlockPos worldOffset, IBuilderContext context) {
        this.blueprint = blueprint;
        this.worldOffset = worldOffset;
        this.context = context;
        this.worldOperatingBox = new Box(worldOffset, worldOffset.func_177971_a((Vec3i)blueprint.size.func_177973_b((Vec3i)Utils.POS_ONE)));
    }

    @Override
    public BptBuilderRandomAccess readFromNBT(NBTBase nbt) {
        BptBuilderRandomAccess builder = new BptBuilderRandomAccess(this.blueprint, this.worldOffset, this.context);
        return builder;
    }

    @Override
    public NBTTagCompound writeToNBT() {
        return null;
    }

    @Override
    public Box operatingBox() {
        return this.worldOperatingBox;
    }

    @Override
    public void recheckBlock(BlockPos pos) {
        if (!this.worldOperatingBox.contains(pos)) {
            return;
        }
        BlockPos blueprintPos = pos.func_177973_b((Vec3i)this.worldOffset);
        SchematicBlockBase schematic = this.blueprint.get(blueprintPos);
        if (schematic != null) {
            if (schematic.isAlreadyBuilt(this.context, blueprintPos)) {
                return;
            }
            if (this.reservedRequirements.containsKey(pos)) {
                return;
            }
            if (this.neededRequirements.containsKey(pos)) {
                BuildRequirement req = this.neededRequirements.get(pos);
                req.updateFor(schematic, this.context, pos);
            } else {
                BuildRequirement req = new BuildRequirement();
                req.updateFor(schematic, this.context, pos);
                this.neededRequirements.put(pos, req);
            }
        }
    }

    protected void internalInit() {
        if (!this.hasInitBlocks) {
            if (!this.iterator.hasNext()) {
                this.hasInitBlocks = true;
            } else {
                BlockPos next = (BlockPos)this.iterator.next();
                this.recheckBlock(next);
            }
        } else if (!this.hasInitEntities) {
            this.hasInitEntities = true;
        }
    }

    @Override
    public double iterateInit(long us) {
        if (this.hasInit()) {
            return -1.0;
        }
        if (this.initPos == null || this.iterator == null) {
            this.initPos = this.worldOffset;
            this.iterator = new Utils.BoxIterator(this.worldOffset, this.worldOffset.func_177971_a((Vec3i)this.blueprint.size.func_177973_b((Vec3i)Utils.POS_ONE)), Utils.EnumAxisOrder.XZY.defaultOrder);
        }
        long start = System.nanoTime() / 1000L;
        do {
            for (int i = 0; i < 64; ++i) {
                this.internalInit();
            }
        } while (System.nanoTime() / 1000L - start < us);
        return 1.0;
    }

    @Override
    public boolean hasInit() {
        return this.hasInitBlocks && this.hasInitEntities;
    }

    @Override
    public void tick() {
        BuildRequirement req;
        HashSet finished = Sets.newHashSet();
        for (Map.Entry<BlockPos, BuildRequirement> entry : this.reservedRequirements.entrySet()) {
            req = entry.getValue();
            req.tick();
            if (!req.hasBuilt()) continue;
            finished.add(entry.getKey());
        }
        for (BlockPos pos : finished) {
            req = this.reservedRequirements.remove(pos);
            this.postProcessing.put(pos, req.forPostProcess());
        }
    }

    @Override
    public BuildingSlot getNextSlot(BlockPos closestToHint) {
        if (!this.neededRequirements.isEmpty()) {
            BlockPos closest = Utils.findClosestTo(this.neededRequirements.keySet(), closestToHint);
            BuildRequirement req = this.neededRequirements.get(closest);
            return req.getSlot();
        }
        if (this.reservedRequirements.isEmpty()) {
            if (!this.postProcessing.isEmpty()) {
                BlockPos closest = Utils.findClosestTo(this.postProcessing.keySet(), closestToHint);
                BuildingSlotPostProcess post = this.postProcessing.remove(closest);
                post.writeToWorld(this.context);
                return post;
            }
            BlockPos closest = Utils.findClosestTo(this.entities.keySet(), closestToHint);
            Collection lst = this.entities.get((Object)closest);
            if (lst.size() != 0) {
                return (BuildingSlot)lst.iterator().next();
            }
        }
        return null;
    }

    @Override
    public void reserveSlot(BuildingSlot slot) {
        if (slot instanceof BuildingSlotBlock) {
            BlockPos pos = ((BuildingSlotBlock)slot).pos;
            if (this.reservedRequirements.containsValue(pos)) {
                return;
            }
            if (!this.neededRequirements.containsKey(pos)) {
                return;
            }
            BuildRequirement req = this.neededRequirements.remove(pos);
            this.reservedRequirements.put(pos, req);
        }
    }

    @Override
    public void unreserveSlot(BuildingSlot slot) {
        if (slot instanceof BuildingSlotBlock) {
            BlockPos used = ((BuildingSlotBlock)slot).pos;
            if (this.neededRequirements.containsKey(used)) {
                return;
            }
            if (!this.reservedRequirements.containsKey(used)) {
                return;
            }
            BuildRequirement req = this.reservedRequirements.remove(used);
            this.neededRequirements.put(used, req);
        }
    }

    @Override
    public int reservedSlotCount() {
        return this.reservedRequirements.size();
    }

    @Override
    public boolean hasFinishedBuilding() {
        return this.hasInit() && this.neededRequirements.isEmpty() && this.reservedRequirements.isEmpty() && this.postProcessing.isEmpty() && this.entities.isEmpty();
    }
}

