/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints.iterator;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.builders.schematics.SchematicAir;
import buildcraft.core.blueprints.iterator.BuildingSlotPostProcess;
import buildcraft.core.builders.BuildingSlotBlock;
import net.minecraft.util.BlockPos;

public class BuildRequirement {
    private BuildingSlotBlock slot;
    private boolean hasBuilt;
    private boolean hasPostProcessed;

    public void updateFor(SchematicBlockBase schematic, IBuilderContext context, BlockPos pos) {
        if (schematic.isAlreadyBuilt(context, pos)) {
            return;
        }
        if (schematic instanceof SchematicAir) {
            this.slot = new BuildingSlotBlock();
            this.slot.mode = BuildingSlotBlock.Mode.ClearIfInvalid;
            this.slot.pos = pos;
            this.slot.schematic = schematic;
        } else {
            this.slot = new BuildingSlotBlock();
            this.slot.mode = BuildingSlotBlock.Mode.Build;
            this.slot.pos = pos;
            this.slot.schematic = schematic;
        }
    }

    public boolean hasBuilt() {
        return this.hasBuilt;
    }

    public boolean hasCompletlyFinished() {
        return this.hasBuilt && this.hasPostProcessed;
    }

    public BuildingSlotBlock getSlot() {
        return this.slot;
    }

    public BuildingSlotPostProcess forPostProcess() {
        if (this.slot == null) {
            return null;
        }
        if (this.slot instanceof BuildingSlotPostProcess) {
            return (BuildingSlotPostProcess)this.slot;
        }
        BuildingSlotPostProcess post = new BuildingSlotPostProcess(this.slot.getSchematic(), this.slot.pos);
        this.slot = post;
        return post;
    }

    public void tick() {
        if (this.slot.built) {
            if (this.slot.mode == BuildingSlotBlock.Mode.Build) {
                if (!this.hasBuilt) {
                    this.hasBuilt = true;
                    this.slot = this.forPostProcess();
                } else {
                    this.hasPostProcessed = true;
                }
            } else {
                this.slot = null;
                this.hasPostProcessed = true;
            }
        }
    }
}

