/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.core.ISerializable;
import buildcraft.core.BlockDecoration;
import buildcraft.core.StackAtPosition;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.BuildingSlotEntity;
import buildcraft.core.builders.IBuildingItem;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class BuildingItem
implements IBuildingItem,
ISerializable {
    public static int ITEMS_SPACE = 2;
    public Vec3 origin;
    public Vec3 destination;
    public LinkedList<StackAtPosition> stacksToDisplay = new LinkedList();
    public boolean isDone = false;
    public BuildingSlot slotToBuild;
    public IBuilderContext context;
    private long previousUpdate;
    private float lifetimeDisplay = 0.0f;
    private float maxLifetime = 0.0f;
    private boolean initialized = false;
    private Vec3 velocity;
    @Deprecated
    private double vx;
    @Deprecated
    private double vy;
    @Deprecated
    private double vz;
    private double maxHeight;
    private float lifetime = 0.0f;

    public void initialize() {
        if (!this.initialized) {
            Vec3 vec = this.destination.func_178788_d(this.origin);
            double size = vec.func_72433_c();
            this.maxLifetime = (float)size * 4.0f;
            this.maxHeight = size / 2.0;
            this.velocity = Utils.multiply(vec, 1.0f / this.maxLifetime);
            if (this.stacksToDisplay.size() == 0) {
                StackAtPosition sPos = new StackAtPosition();
                sPos.stack = new ItemStack((Block)BuildCraftCore.decoratedBlock);
                this.stacksToDisplay.add(sPos);
            }
            this.initialized = true;
        }
    }

    public Vec3 getDisplayPosition(float time) {
        Vec3 pos = this.origin.func_178787_e(Utils.multiply(this.velocity, time));
        return pos.func_72441_c(0.0, (double)MathHelper.func_76126_a((float)(time / this.maxLifetime * (float)Math.PI)) * this.maxHeight, 0.0);
    }

    public void update() {
        if (this.isDone) {
            return;
        }
        this.initialize();
        this.lifetime += 1.0f;
        if (this.lifetime > this.maxLifetime + (float)(this.stacksToDisplay.size() * ITEMS_SPACE) - 1.0f) {
            this.isDone = true;
            this.build();
        }
        this.lifetimeDisplay = this.lifetime;
        this.previousUpdate = new Date().getTime();
        if (this.slotToBuild != null && this.lifetime > this.maxLifetime) {
            this.slotToBuild.writeCompleted(this.context, (this.lifetime - this.maxLifetime) / (float)(this.stacksToDisplay.size() * ITEMS_SPACE));
        }
    }

    public void displayUpdate() {
        this.initialize();
        float tickDuration = 50.0f;
        long currentUpdate = new Date().getTime();
        float timeSpan = currentUpdate - this.previousUpdate;
        this.previousUpdate = currentUpdate;
        float displayPortion = timeSpan / tickDuration;
        if ((double)(this.lifetimeDisplay - this.lifetime) <= 1.0) {
            this.lifetimeDisplay = (float)((double)this.lifetimeDisplay + 1.0 * (double)displayPortion);
        }
    }

    private void build() {
        if (this.slotToBuild != null) {
            BlockPos dest = Utils.convertFloor(this.destination);
            IBlockState state = this.context.world().func_180495_p(dest);
            if (this.slotToBuild.writeToWorld(this.context)) {
                this.context.world().func_180498_a(null, 2001, dest, Block.func_176210_f((IBlockState)state));
            } else {
                for (ItemStack s : this.slotToBuild.stackConsumed) {
                    if (s == null || s.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)s.func_77973_b()) instanceof BlockDecoration) continue;
                    InvUtils.dropItems(this.context.world(), s, dest);
                }
            }
        }
    }

    public LinkedList<StackAtPosition> getStacks() {
        int d = 0;
        for (StackAtPosition s : this.stacksToDisplay) {
            float stackLife = this.lifetimeDisplay - (float)d;
            if (stackLife <= this.maxLifetime && stackLife > 0.0f) {
                s.pos = this.getDisplayPosition(stackLife);
                s.display = true;
            } else {
                s.display = false;
            }
            d += ITEMS_SPACE;
        }
        return this.stacksToDisplay;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("origin", (NBTBase)NBTUtils.writeVec3(this.origin));
        nbt.func_74782_a("destination", (NBTBase)NBTUtils.writeVec3(this.destination));
        nbt.func_74776_a("lifetime", this.lifetime);
        NBTTagList items = new NBTTagList();
        for (StackAtPosition s : this.stacksToDisplay) {
            NBTTagCompound cpt = new NBTTagCompound();
            s.stack.func_77955_b(cpt);
            items.func_74742_a((NBTBase)cpt);
        }
        nbt.func_74782_a("items", (NBTBase)items);
        MappingRegistry registry = new MappingRegistry();
        NBTTagCompound slotNBT = new NBTTagCompound();
        NBTTagCompound registryNBT = new NBTTagCompound();
        this.slotToBuild.writeToNBT(slotNBT, registry);
        registry.write(registryNBT);
        nbt.func_74782_a("registry", (NBTBase)registryNBT);
        if (this.slotToBuild instanceof BuildingSlotBlock) {
            nbt.func_74774_a("slotKind", (byte)0);
        } else {
            nbt.func_74774_a("slotKind", (byte)1);
        }
        nbt.func_74782_a("slotToBuild", (NBTBase)slotNBT);
    }

    public void readFromNBT(NBTTagCompound nbt) throws MappingNotFoundException {
        this.origin = NBTUtils.readVec3(nbt, "origin");
        this.destination = NBTUtils.readVec3(nbt, "destination");
        this.lifetime = nbt.func_74760_g("lifetime");
        NBTTagList items = nbt.func_150295_c("items", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            StackAtPosition sPos = new StackAtPosition();
            sPos.stack = ItemStack.func_77949_a((NBTTagCompound)items.func_150305_b(i));
            this.stacksToDisplay.add(sPos);
        }
        MappingRegistry registry = new MappingRegistry();
        registry.read(nbt.func_74775_l("registry"));
        this.slotToBuild = nbt.func_74771_c("slotKind") == 0 ? new BuildingSlotBlock() : new BuildingSlotEntity();
        this.slotToBuild.readFromNBT(nbt.func_74775_l("slotToBuild"), registry);
    }

    public void setStacksToDisplay(List<ItemStack> stacks) {
        if (stacks != null) {
            for (ItemStack s : stacks) {
                for (int i = 0; i < s.field_77994_a; ++i) {
                    StackAtPosition sPos = new StackAtPosition();
                    sPos.stack = s.func_77946_l();
                    sPos.stack.field_77994_a = 1;
                    this.stacksToDisplay.add(sPos);
                }
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        this.origin = NetworkUtils.readVec3(stream);
        this.destination = NetworkUtils.readVec3(stream);
        this.lifetime = stream.readFloat();
        this.stacksToDisplay.clear();
        int size = stream.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            StackAtPosition e = new StackAtPosition();
            e.readData(stream);
            this.stacksToDisplay.add(e);
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        NetworkUtils.writeVec3(stream, this.origin);
        NetworkUtils.writeVec3(stream, this.destination);
        stream.writeFloat(this.lifetime);
        stream.writeShort(this.stacksToDisplay.size());
        for (StackAtPosition s : this.stacksToDisplay) {
            s.writeData(stream);
        }
    }

    public int hashCode() {
        return 131 * this.origin.hashCode() + this.destination.hashCode();
    }
}

