/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.blueprints.SchematicFactory;
import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.core.BCLog;
import buildcraft.core.blueprints.IndexRequirementMap;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.NBTUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ITickable;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;

public class BuildingSlotBlock
extends BuildingSlot {
    public BlockPos pos;
    public SchematicBlockBase schematic;
    public IndexRequirementMap internalRequirementRemovalListener;
    public Mode mode = Mode.Build;
    public int buildStage = 0;

    @Override
    public SchematicBlockBase getSchematic() {
        if (this.schematic == null) {
            return new SchematicMask(false);
        }
        return this.schematic;
    }

    @Override
    public boolean writeToWorld(IBuilderContext context) {
        if (this.internalRequirementRemovalListener != null) {
            this.internalRequirementRemovalListener.remove(this);
        }
        if (this.mode == Mode.ClearIfInvalid) {
            if (!this.getSchematic().isAlreadyBuilt(context, this.pos)) {
                context.world().func_175715_c(this.pos.hashCode(), this.pos, -1);
                if (BuildCraftBuilders.dropBrokenBlocks) {
                    BlockUtils.breakBlock((WorldServer)context.world(), this.pos);
                    return false;
                }
                context.world().func_175698_g(this.pos);
                return true;
            }
        } else {
            try {
                TileEntity e;
                this.getSchematic().placeInWorld(context, this.pos, this.stackConsumed);
                if (!this.getSchematic().isAlreadyBuilt(context, this.pos)) {
                    if (context.world().func_175623_d(this.pos)) {
                        return false;
                    }
                    if (!(this.getSchematic() instanceof SchematicBlock) || !context.world().func_180495_p(this.pos).func_177230_c().func_149667_c(((SchematicBlock)this.getSchematic()).state.func_177230_c())) {
                        BCLog.logger.warn("Placed block does not match expectations! Most likely a bug in BuildCraft or a supported mod. Removed mismatched block.");
                        IBlockState state = context.world().func_180495_p(this.pos);
                        BCLog.logger.warn("Location: " + this.pos + " - Block: " + Block.field_149771_c.func_177774_c((Object)state.func_177230_c()) + "@" + state);
                        context.world().func_175713_t(this.pos);
                        context.world().func_175698_g(this.pos);
                        return false;
                    }
                    return true;
                }
                if (!context.world().func_175623_d(this.pos) && this.getSchematic().getBuildingPermission() == BuildingPermission.ALL && this.getSchematic() instanceof SchematicBlock) {
                    SchematicBlock sb = (SchematicBlock)this.getSchematic();
                    ItemStack[] oldRequirementsArray = sb.storedRequirements;
                    List<ItemStack> oldRequirements = Arrays.asList(oldRequirementsArray);
                    sb.storedRequirements = new ItemStack[0];
                    sb.storeRequirements(context, this.pos);
                    for (ItemStack s : sb.storedRequirements) {
                        boolean contains = false;
                        for (ItemStack ss : oldRequirements) {
                            if (!this.getSchematic().isItemMatchingRequirement(s, ss)) continue;
                            contains = true;
                            break;
                        }
                        if (contains) continue;
                        BCLog.logger.warn("Blueprint has MISMATCHING REQUIREMENTS! Potential corrupted/hacked blueprint! Removed mismatched block.");
                        BCLog.logger.warn("Location: " + this.pos + " - ItemStack: " + s.toString());
                        context.world().func_175713_t(this.pos);
                        context.world().func_175698_g(this.pos);
                        return true;
                    }
                    sb.storedRequirements = oldRequirementsArray;
                }
                if ((e = context.world().func_175625_s(this.pos)) != null && e instanceof ITickable) {
                    ((ITickable)e).func_73660_a();
                }
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                context.world().func_175698_g(this.pos);
                return false;
            }
        }
        return false;
    }

    @Override
    public void postProcessing(IBuilderContext context) {
        this.getSchematic().postProcessing(context, this.pos);
    }

    @Override
    public List<ItemStack> getRequirements(IBuilderContext context) {
        if (this.mode == Mode.ClearIfInvalid) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> req = new ArrayList<ItemStack>();
        this.getSchematic().getRequirementsForPlacement(context, req);
        return req;
    }

    @Override
    public Vec3 getDestination() {
        return new Vec3((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5);
    }

    @Override
    public void writeCompleted(IBuilderContext context, double complete) {
        if (this.mode == Mode.ClearIfInvalid) {
            int progress = context.world().func_175623_d(this.pos) ? -1 : (int)(complete * 10.0) - 1;
            context.world().func_175715_c(this.pos.hashCode(), this.pos, progress);
        }
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context) {
        return this.schematic.isAlreadyBuilt(context, this.pos);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        nbt.func_74774_a("mode", (byte)this.mode.ordinal());
        nbt.func_74782_a("pos", NBTUtils.writeBlockPos(this.pos));
        if (this.schematic != null) {
            NBTTagCompound schematicNBT = new NBTTagCompound();
            SchematicFactory.getFactory(this.schematic.getClass()).saveSchematicToWorldNBT(schematicNBT, this.schematic, registry);
            nbt.func_74782_a("schematic", (NBTBase)schematicNBT);
        }
        NBTTagList nbtStacks = new NBTTagList();
        if (this.stackConsumed != null) {
            for (ItemStack stack : this.stackConsumed) {
                NBTTagCompound nbtStack = new NBTTagCompound();
                stack.func_77955_b(nbtStack);
                nbtStacks.func_74742_a((NBTBase)nbtStack);
            }
        }
        nbt.func_74782_a("stackConsumed", (NBTBase)nbtStacks);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, MappingRegistry registry) throws MappingNotFoundException {
        this.mode = Mode.values()[nbt.func_74771_c("mode")];
        this.pos = NBTUtils.readBlockPos((NBTBase)nbt);
        if (nbt.func_74764_b("schematic")) {
            this.schematic = (SchematicBlockBase)SchematicFactory.createSchematicFromWorldNBT(nbt.func_74775_l("schematic"), registry);
        }
        this.stackConsumed = new ArrayList();
        NBTTagList nbtStacks = nbt.func_150295_c("stackConsumed", 10);
        for (int i = 0; i < nbtStacks.func_74745_c(); ++i) {
            this.stackConsumed.add(ItemStack.func_77949_a((NBTTagCompound)nbtStacks.func_150305_b(i)));
        }
    }

    @Override
    public List<ItemStack> getStacksToDisplay() {
        if (this.mode == Mode.ClearIfInvalid) {
            return this.stackConsumed;
        }
        return this.getSchematic().getStacksToDisplay(this.stackConsumed);
    }

    @Override
    public int getEnergyRequirement() {
        return this.schematic.getEnergyRequirement(this.stackConsumed);
    }

    @Override
    public int buildTime() {
        if (this.schematic == null) {
            return 1;
        }
        return this.schematic.buildTime();
    }

    public static enum Mode {
        ClearIfInvalid,
        Build;

    }
}

