/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ExpressionCompiler {
    private static String operators = "+-*/^~";
    private static String splitters = "+-*/^()~,";
    private static String leftAssosiative = "+-*/^";
    private static String rightAssosiative = "~";
    private static String[] precedence = new String[]{"()", "+-", "*/", "^", "~"};
    private static String expressionRegex = "[a-z0-9]|[+-*/^()~]";
    private static Pattern expressionMather = Pattern.compile(expressionRegex);
    private static String numberRegex = "[-+]?[0-9]*\\.?[0-9]+";
    private static Pattern decimalMatcher = Pattern.compile(numberRegex);

    public static Expression compileExpression(String expression) throws InvalidExpressionException {
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (expressionMather.matcher(c + "").matches()) continue;
            throw new InvalidExpressionException("Could not compile " + expression + ", as the " + i + "th char ('" + c + "') was invalid");
        }
        String[] split = ExpressionCompiler.split(expression);
        String[] postfix = ExpressionCompiler.convertToPostfix(split);
        return ExpressionCompiler.makeExpression(postfix);
    }

    private static String[] split(String function) {
        function = function.replaceAll("\\s", "");
        ArrayList list = Lists.newArrayList();
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < function.length(); ++index) {
            char toTest = function.charAt(index);
            if (splitters.indexOf(toTest) != -1) {
                if (buffer.length() > 0) {
                    list.add(buffer.toString());
                }
                list.add(String.valueOf(toTest));
                buffer = new StringBuffer();
                continue;
            }
            buffer.append(toTest);
        }
        if (buffer.length() > 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    private static int getPrecendence(String token) {
        int p = 0;
        if (token.startsWith("\u0192")) {
            return 0;
        }
        for (String pre : precedence) {
            if (pre.contains(token)) {
                return p;
            }
            ++p;
        }
        return p;
    }

    private static String[] convertToPostfix(String[] infix) throws InvalidExpressionException {
        ArrayDeque stack = Queues.newArrayDeque();
        ArrayList postfix = Lists.newArrayList();
        int index = 0;
        for (index = 0; index < infix.length; ++index) {
            String token = infix[index];
            if (decimalMatcher.matcher(token).matches()) {
                postfix.add(token);
                continue;
            }
            if (",".equals(token)) {
                boolean found = false;
                while (!stack.isEmpty()) {
                    String fromStack = (String)stack.pop();
                    if ("(".equals(fromStack) || fromStack.startsWith("\u0192")) {
                        found = true;
                        stack.push(fromStack);
                        break;
                    }
                    postfix.add(fromStack);
                }
                if (found) continue;
                throw new InvalidExpressionException("Did not find an opening parenthesis for the comma!");
            }
            if ("(".equals(token)) {
                stack.push(token);
                continue;
            }
            if (")".equals(token)) {
                boolean found = false;
                while (!stack.isEmpty()) {
                    String fromStack = (String)stack.pop();
                    if ("(".equals(fromStack)) {
                        found = true;
                        break;
                    }
                    if (fromStack.startsWith("\u0192")) {
                        found = true;
                        postfix.add(fromStack);
                        break;
                    }
                    postfix.add(fromStack);
                }
                if (found) continue;
                throw new InvalidExpressionException("Too many closing parenthesis!");
            }
            if (operators.contains(token)) {
                String s;
                if ("-".equals(token) && (index == 0 || splitters.contains(infix[index - 1]))) {
                    token = "~";
                }
                while ((s = (String)stack.peek()) != null) {
                    boolean shouldContinue;
                    int o1 = ExpressionCompiler.getPrecendence(token);
                    int o2 = ExpressionCompiler.getPrecendence(s);
                    boolean bl = shouldContinue = leftAssosiative.contains(token) && o1 <= o2;
                    if (!shouldContinue) {
                        boolean bl2 = shouldContinue = rightAssosiative.contains(token) && o1 < o2;
                    }
                    if (!shouldContinue) break;
                    postfix.add(stack.pop());
                }
                stack.push(token);
                continue;
            }
            if (index + 1 < infix.length && "(".equals(infix[index + 1])) {
                stack.push("\u0192" + token);
                ++index;
                continue;
            }
            postfix.add(token);
        }
        while (!stack.isEmpty()) {
            String operator = (String)stack.pop();
            if ("(".equals(operator)) {
                throw new InvalidExpressionException("Too many opening parenthesis!");
            }
            if (")".equals(operator)) {
                throw new InvalidExpressionException("Too many closing parenthesis!");
            }
            postfix.add(operator);
        }
        return postfix.toArray(new String[postfix.size()]);
    }

    private static Expression makeExpression(String[] postfix) throws InvalidExpressionException {
        HashMap variableMap = Maps.newHashMap();
        int currentVar = 0;
        ArrayDeque stack = Queues.newArrayDeque();
        for (String op : postfix) {
            Node b;
            if ("-".equals(op)) {
                Node a = (Node)stack.pop();
                b = (Node)stack.pop();
                stack.push(new DoubleExpressionNode(a, b){

                    @Override
                    double apply(double a, double b) {
                        return b - a;
                    }
                });
                continue;
            }
            if ("+".equals(op)) {
                Node a = (Node)stack.pop();
                b = (Node)stack.pop();
                stack.push(new DoubleExpressionNode(a, b){

                    @Override
                    double apply(double a, double b) {
                        return a + b;
                    }
                });
                continue;
            }
            if ("*".equals(op)) {
                Node a = (Node)stack.pop();
                b = (Node)stack.pop();
                stack.push(new DoubleExpressionNode(a, b){

                    @Override
                    double apply(double a, double b) {
                        return a * b;
                    }
                });
                continue;
            }
            if ("/".equals(op)) {
                Node a = (Node)stack.pop();
                b = (Node)stack.pop();
                stack.push(new DoubleExpressionNode(a, b){

                    @Override
                    double apply(double a, double b) {
                        return b / a;
                    }
                });
                continue;
            }
            if ("~".equals(op)) {
                Node a = (Node)stack.pop();
                stack.push(new SingleExpressionNode(a){

                    @Override
                    double apply(double a) {
                        return -a;
                    }
                });
                continue;
            }
            if (decimalMatcher.matcher(op).matches()) {
                stack.push(new ValueNode(Double.valueOf(op)));
                continue;
            }
            if (op.startsWith("\u0192")) {
                throw new IllegalStateException("Cannot handle functions yet!");
            }
            int index = 0;
            if (variableMap.containsKey(op)) {
                index = (Integer)variableMap.get(op);
            } else {
                index = currentVar++;
                variableMap.put(op, index);
            }
            stack.push(new VariableNode(index));
        }
        if (stack.size() != 1) {
            throw new IllegalArgumentException("Tried to make an expression with too many nodes! (" + stack + ")");
        }
        Node n = (Node)stack.pop();
        return new Expression(n, variableMap);
    }

    public static class InvalidExpressionException
    extends Exception {
        public InvalidExpressionException(String message) {
            super(message);
        }
    }

    private static class VariableNode
    extends Node {
        final int index;

        public VariableNode(int index) {
            this.index = index;
        }

        @Override
        double evaluate(double[] variables) {
            return variables[this.index];
        }
    }

    private static class ValueNode
    extends Node {
        final double value;

        public ValueNode(double value) {
            this.value = value;
        }

        @Override
        double evaluate(double[] variables) {
            return this.value;
        }
    }

    private static abstract class SingleExpressionNode
    extends Node {
        final Node a;

        public SingleExpressionNode(Node a) {
            this.a = a;
        }

        @Override
        double evaluate(double[] variables) {
            double aV = this.a.evaluate(variables);
            return this.apply(aV);
        }

        abstract double apply(double var1);
    }

    private static abstract class DoubleExpressionNode
    extends Node {
        final Node a;
        final Node b;

        public DoubleExpressionNode(Node a, Node b) {
            this.a = a;
            this.b = b;
        }

        @Override
        double evaluate(double[] variables) {
            double aV = this.a.evaluate(variables);
            double bV = this.b.evaluate(variables);
            return this.apply(aV, bV);
        }

        abstract double apply(double var1, double var3);
    }

    public static class Expression {
        private final Node node;
        private final double[] variables;
        private final Map<String, Variable> varAccessor;

        public Expression(Node node, Map<String, Integer> vars) {
            this.node = node;
            this.variables = new double[vars.size()];
            this.varAccessor = Maps.newHashMap();
            for (Map.Entry<String, Integer> entry : vars.entrySet()) {
                this.varAccessor.put(entry.getKey(), new Variable(entry.getValue()));
            }
        }

        public Map<String, Variable> getVariables() {
            return Collections.unmodifiableMap(this.varAccessor);
        }

        public Variable getVariable(String name) {
            return this.varAccessor.get(name);
        }

        public double evaluate() {
            return this.node.evaluate(this.variables);
        }

        public class Variable {
            private final int index;

            private Variable(int index) {
                this.index = index;
            }

            public double get() {
                return Expression.this.variables[this.index];
            }

            public void set(double value) {
                ((Expression)Expression.this).variables[this.index] = value;
            }
        }
    }

    private static abstract class Node {
        private Node() {
        }

        abstract double evaluate(double[] var1);
    }
}

