/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib;

import buildcraft.api.ObjectDefinition;
import buildcraft.core.lib.IDefinitionTriMap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.item.Item;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class HashDefinitionMap<I extends Item, D extends ObjectDefinition>
implements IDefinitionTriMap<I, D> {
    private final BiMap<String, I> tagItem = HashBiMap.create();
    private final BiMap<I, D> itemDefinition = HashBiMap.create();
    private final BiMap<D, String> definitionTag = HashBiMap.create();
    private final BiMap<I, String> itemTag = this.tagItem.inverse();
    private final BiMap<D, I> definitionItem = this.itemDefinition.inverse();
    private final BiMap<String, D> tagDefinition = this.definitionTag.inverse();
    private final Set<Triple<String, I, D>> elementSet = Sets.newHashSet();
    private final Set<Triple<String, I, D>> unmodifiableSet = Collections.unmodifiableSet(this.elementSet);

    public static <I extends Item, D extends ObjectDefinition> HashDefinitionMap<I, D> create() {
        return new HashDefinitionMap<I, D>();
    }

    @Override
    public void put(I item, D definition) {
        if (item == null || definition == null) {
            throw new NullPointerException("Cannot put any null values!");
        }
        String tag = ((ObjectDefinition)definition).globalUniqueTag;
        if (this.containsTag(tag) || this.containsItem(item) || this.containsDefinition(definition)) {
            throw new IllegalArgumentException("Cannot re-put any values into the map!");
        }
        this.tagItem.put((Object)tag, item);
        this.itemDefinition.put(item, definition);
        this.definitionTag.put(definition, (Object)tag);
        this.elementSet.add(this.createTriple(tag, item, definition));
    }

    private Triple<String, I, D> createTriple(String tag, I item, D definition) {
        return ImmutableTriple.of((Object)tag, item, definition);
    }

    @Override
    public boolean containsTag(String tag) {
        return this.tagItem.containsKey((Object)tag);
    }

    @Override
    public boolean containsItem(I item) {
        return this.itemDefinition.containsKey(item);
    }

    @Override
    public boolean containsDefinition(D definition) {
        return this.definitionTag.containsKey(definition);
    }

    @Override
    public void clear() {
        this.tagItem.clear();
        this.itemDefinition.clear();
        this.definitionTag.clear();
        this.elementSet.clear();
    }

    @Override
    public void remove(String tag) {
        if (!this.containsTag(tag)) {
            return;
        }
        I item = this.getItem((D)tag);
        D definition = this.getDefinition((I)tag);
        this.remove(tag, item, definition);
    }

    @Override
    public void remove(I item) {
        if (!this.containsItem(item)) {
            return;
        }
        D definition = this.getDefinition(item);
        String tag = this.getTag((D)item);
        this.remove(tag, item, definition);
    }

    @Override
    public void remove(D definition) {
        if (!this.containsDefinition(definition)) {
            return;
        }
        String tag = this.getTag(definition);
        I item = this.getItem(definition);
        this.remove(tag, item, definition);
    }

    private void remove(String tag, I item, D definition) {
        this.tagItem.remove((Object)tag);
        this.itemDefinition.remove(item);
        this.definitionTag.remove(definition);
        Triple<String, I, D> toRemove = null;
        for (Triple<String, I, D> triple : this.elementSet) {
            if (triple.getMiddle() != item) continue;
            toRemove = triple;
            break;
        }
        this.elementSet.remove(toRemove);
    }

    @Override
    public String getTag(I item) {
        return (String)this.itemTag.get(item);
    }

    @Override
    public String getTag(D definition) {
        return (String)this.definitionTag.get(definition);
    }

    @Override
    public I getItem(String tag) {
        return (I)((Item)this.tagItem.get((Object)tag));
    }

    @Override
    public I getItem(D definition) {
        return (I)((Item)this.definitionItem.get(definition));
    }

    @Override
    public D getDefinition(String tag) {
        return (D)((ObjectDefinition)this.tagDefinition.get((Object)tag));
    }

    @Override
    public D getDefinition(I item) {
        return (D)((ObjectDefinition)this.itemDefinition.get(item));
    }

    @Override
    public Set<Triple<String, I, D>> getTripleSet() {
        return this.unmodifiableSet;
    }
}

