/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.block;

import buildcraft.core.lib.render.EntityDropParticleFX;
import buildcraft.core.lib.utils.ICustomStateMapper;
import buildcraft.core.lib.utils.Utils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBuildCraftFluid
extends BlockFluidClassic
implements ICustomStateMapper {
    protected float particleRed;
    protected float particleGreen;
    protected float particleBlue;
    protected boolean flammable;
    protected boolean dense = false;
    protected int flammability = 0;

    public BlockBuildCraftFluid(Fluid fluid, Material material) {
        super(fluid, material);
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block block) {
        super.func_176204_a(world, pos, state, block);
        if (this.flammable && world.field_73011_w.func_177502_q() == -1) {
            world.func_175698_g(pos);
            world.func_72885_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 4.0f, true, true);
        }
    }

    private double within(double current, double maximum) {
        return Math.max(-maximum, Math.min(current, maximum));
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity == null || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b) {
            return;
        }
        Vec3 acc = new Vec3(0.0, 0.0, 0.0);
        acc = this.func_176197_a(world, pos, entity, acc);
        Vec3 accDir = new Vec3(0.0, 0.0, 0.0);
        if (acc.func_72433_c() > 0.0) {
            acc = acc.func_72432_b();
            double multiplier = 0.07;
            accDir = new Vec3(acc.field_72450_a * multiplier, acc.field_72448_b * multiplier, acc.field_72449_c * multiplier);
        }
        double within = 0.05;
        entity.field_70159_w = this.within(entity.field_70159_w, within) + accDir.field_72450_a;
        entity.field_70181_x = this.within(entity.field_70181_x, within) + accDir.field_72448_b;
        entity.field_70179_y = this.within(entity.field_70179_y, within) + accDir.field_72449_c;
        if (!this.dense) {
            return;
        }
        if (entity.field_70163_u < (double)((float)pos.func_177956_o() + this.getQuantaPercentage((IBlockAccess)world, pos)) - 0.5 && entity.field_70181_x < 0.1) {
            entity.field_70181_x = 0.1;
            entity.field_70143_R = 0.0f;
        }
    }

    public BlockBuildCraftFluid setDense(boolean dense) {
        this.dense = dense;
        return this;
    }

    public BlockBuildCraftFluid setFlammable(boolean flammable) {
        this.flammable = flammable;
        return this;
    }

    public BlockBuildCraftFluid setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammable ? 300 : 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammability;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammable;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.flammable && this.flammability == 0;
    }

    public BlockBuildCraftFluid setParticleColor(float particleRed, float particleGreen, float particleBlue) {
        this.particleRed = particleRed;
        this.particleGreen = particleGreen;
        this.particleBlue = particleBlue;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180655_c(world, pos, state, rand);
        if (rand.nextInt(10) == 0 && World.func_175683_a((IBlockAccess)world, (BlockPos)pos.func_177977_b()) && !world.func_180495_p(pos.func_177979_c(2)).func_177230_c().func_149688_o().func_76230_c()) {
            double px = (float)pos.func_177958_n() + rand.nextFloat();
            double py = (double)pos.func_177956_o() - 1.05;
            double pz = (float)pos.func_177952_p() + rand.nextFloat();
            EntityDropParticleFX fx = new EntityDropParticleFX(world, px, py, pz, this.particleRed, this.particleGreen, this.particleBlue);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c().func_149688_o().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c().func_149688_o().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setCusomStateMappers() {
        final ModelResourceLocation loc = new ModelResourceLocation(Utils.getNameForBlock((Block)this).replace("|", ""), "fluid");
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return loc;
            }
        });
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }
}

