/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.block;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.ISerializable;
import buildcraft.api.tiles.IControllable;
import buildcraft.core.DefaultProps;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.TileBuffer;
import buildcraft.core.lib.block.IAdditionalDataTile;
import buildcraft.core.lib.network.PacketTileUpdate;
import cofh.api.energy.IEnergyHandler;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public abstract class TileBuildCraft
extends TileEntity
implements IEnergyHandler,
ISerializable,
ITickable,
IAdditionalDataTile {
    protected TileBuffer[] cache;
    protected HashSet<EntityPlayer> guiWatchers = new HashSet();
    protected IControllable.Mode mode;
    private boolean sendNetworkUpdate = false;
    protected int init = 0;
    private String owner = "[BuildCraft]";
    private RFBattery battery;
    private int receivedTick;
    private int extractedTick;
    private long worldTimeEnergyReceive;
    public int ledPower = 0;
    public int lastLedPower = 0;
    public boolean ledDone = false;
    public boolean lastLedDone = false;

    public String getOwner() {
        return this.owner;
    }

    public void addGuiWatcher(EntityPlayer player) {
        if (!this.guiWatchers.contains(player)) {
            this.guiWatchers.add(player);
        }
    }

    public void removeGuiWatcher(EntityPlayer player) {
        if (this.guiWatchers.contains(player)) {
            this.guiWatchers.remove(player);
        }
    }

    public void func_73660_a() {
        if (this.init != 2 && !this.func_145837_r()) {
            if (this.init < 1) {
                ++this.init;
                return;
            }
            this.initialize();
            this.init = 2;
        }
        if (this.battery != null) {
            this.receivedTick = 0;
            this.extractedTick = 0;
            if (!this.field_145850_b.field_72995_K) {
                int prePower = this.ledPower;
                int stored = this.battery.getEnergyStored();
                int max = this.battery.getMaxEnergyStored();
                this.ledPower = 0;
                if (stored != 0) {
                    this.ledPower = stored * 2 / max + 1;
                }
                if (prePower != this.ledPower) {
                    this.sendNetworkUpdate();
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.battery != null) {
            this.ledPower = this.battery.getMaxEnergyStored() > 0 ? 3 * this.battery.getEnergyStored() / this.battery.getMaxEnergyStored() : 0;
        }
        if (this.lastLedPower != this.ledPower || this.lastLedDone != this.ledDone) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175689_h(this.func_174877_v());
            } else {
                this.sendNetworkUpdate();
            }
            this.lastLedPower = this.ledPower;
            this.lastLedDone = this.ledDone;
        }
        if (this.sendNetworkUpdate && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BuildCraftCore.instance.sendToPlayers(this.getPacketUpdate(), this.field_145850_b, this.func_174877_v(), DefaultProps.NETWORK_UPDATE_RANGE);
            this.sendNetworkUpdate = false;
        }
    }

    public void initialize() {
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.cache = null;
    }

    public void func_145843_s() {
        this.init = 0;
        super.func_145843_s();
        this.cache = null;
    }

    public void onBlockPlacedBy(EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            this.owner = ((EntityPlayer)entity).getDisplayNameString();
        }
    }

    public void destroy() {
        this.cache = null;
    }

    @Override
    public void sendNetworkUpdate() {
        this.sendNetworkUpdate = true;
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeByte(this.ledPower);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.ledPower = stream.readByte();
    }

    public buildcraft.core.lib.network.base.Packet getPacketUpdate() {
        return new PacketTileUpdate(this, this);
    }

    public Packet func_145844_m() {
        this.sendNetworkUpdate();
        return null;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("owner", this.owner);
        if (this.battery != null) {
            NBTTagCompound batteryNBT = new NBTTagCompound();
            this.battery.writeToNBT(batteryNBT);
            nbt.func_74782_a("battery", (NBTBase)batteryNBT);
        }
        if (this.mode != null) {
            nbt.func_74774_a("lastMode", (byte)this.mode.ordinal());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("owner")) {
            this.owner = nbt.func_74779_i("owner");
        }
        if (this.battery != null) {
            this.battery.readFromNBT(nbt.func_74775_l("battery"));
        }
        if (nbt.func_74764_b("lastMode")) {
            this.mode = IControllable.Mode.values()[nbt.func_74771_c("lastMode")];
        }
    }

    protected int getTicksSinceEnergyReceived() {
        return (int)(this.field_145850_b.func_82737_E() - this.worldTimeEnergyReceive);
    }

    public int hashCode() {
        return this.field_174879_c.hashCode();
    }

    public boolean equals(Object cmp) {
        return this == cmp;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.battery != null;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            int received = this.battery.receiveEnergy(maxReceive - this.receivedTick, simulate);
            if (!simulate) {
                this.receivedTick += received;
                this.worldTimeEnergyReceive = this.field_145850_b.func_82737_E();
            }
            return received;
        }
        return 0;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            int extracted = this.battery.extractEnergy(maxExtract - this.extractedTick, simulate);
            if (!simulate) {
                this.extractedTick += extracted;
            }
            return extracted;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            return this.battery.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            return this.battery.getMaxEnergyStored();
        }
        return 0;
    }

    public RFBattery getBattery() {
        return this.battery;
    }

    protected void setBattery(RFBattery battery) {
        this.battery = battery;
    }

    public IBlockState getBlockState(EnumFacing side) {
        if (this.cache == null) {
            this.cache = TileBuffer.makeBuffer(this.field_145850_b, this.field_174879_c, false);
        }
        return this.cache[side.ordinal()].getBlockState();
    }

    public TileEntity getTile(EnumFacing side) {
        if (this.cache == null) {
            this.cache = TileBuffer.makeBuffer(this.field_145850_b, this.field_174879_c, false);
        }
        return this.cache[side.ordinal()].getTile();
    }

    public IControllable.Mode getControlMode() {
        return this.mode;
    }

    public void setControlMode(IControllable.Mode mode) {
        this.mode = mode;
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public String getInventoryName() {
        return "";
    }

    public String getName() {
        return this.getInventoryName();
    }

    public IChatComponent getDisplayName() {
        return new ChatComponentText(this.getInventoryName());
    }

    public void clear() {
    }

    public boolean hasCustomName() {
        return !StringUtils.isEmpty((CharSequence)this.getInventoryName());
    }
}

